package api.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

import api.backend.ApplicationContext;

public class MepEditorComposite {
	
	
	private Shell shell;
	private EditorContainer container;
	
	public MepEditorComposite(Shell shell) {
		this.shell = shell;
		createControl();
	}

	public void createControl() {
		Menu menuBar = new Menu(shell, SWT.BAR);
        MenuItem fileMenuHeader = new MenuItem(menuBar, SWT.CASCADE);
        fileMenuHeader.setText("File");

        Menu fileMenu = new Menu(shell, SWT.DROP_DOWN);
        fileMenuHeader.setMenu(fileMenu);

        MenuItem screenshotItem = new MenuItem(fileMenu, SWT.PUSH);
        screenshotItem.setText("Capture");
        screenshotItem.addListener(SWT.Selection, e ->{
        	int width = ApplicationContext.getWidth();
        	int height = ApplicationContext.getHeight();
        	ApplicationContext.getApplication().saveTextureToFile(width, height);
        }
        );
        
        
        MenuItem exitItem = new MenuItem(fileMenu, SWT.PUSH);
        exitItem.setText("Quitter");
        exitItem.addListener(SWT.Selection, e -> shell.close());
        
        shell.setMenuBar(menuBar);
        container = new EditorContainer(shell, SWT.NONE);
	}
	
	public GLCanvas getCanvas() {
		if(container != null)
			return container.getCanvas();
		return null;
	}
	
	
	
	
}
