package api.provider;

import org.jogamp.vecmath.Vector3d;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import api.graphics.BoundingBox;
import api.graphics.Model;
import api.graphics.ModelInstance;

public class ModelInfo {

	private String name;
	private String label;
	private String modelPath;
	private String imagePath;
	private Model model;
	private Vector3f scale;
	
	
	
	public ModelInstance createModelInstance() {
		ModelInstance instance = new ModelInstance(getModel());
		BoundingBox box = instance.calculateBoundingBox();
		Vector3f size = box.getSize();
		Vector3f center = box.getCenter();
		Vector3f scaling = new Vector3f(1/size.x, 1/size.y, 1/size.z).mul(scale);
		Matrix4f transform = new Matrix4f().scale(scaling).translate(center.mul(-1));
		instance.setTransform(transform);
		return instance;
		
	}
	
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getLabel() {
		return label;
	}
	public void setLabel(String label) {
		this.label = label;
	}
	public String getModelPath() {
		return modelPath;
	}
	public void setModelPath(String modelPath) {
		this.modelPath = modelPath;
	}
	
	
	public String getImagePath() {
		return imagePath;
	}
	public void setImagePath(String imagePath) {
		this.imagePath = imagePath;
	}
	public Model getModel() {
		if(model == null)
			model = new Model(modelPath);
		return model;
	}
	public void setModel(Model model) {
		this.model = model;
	}
	public Vector3f getScale() {
		return scale;
	}
	public void setScale(Vector3f scale) {
		this.scale = scale;
	}
	@Override
	public String toString() {
		return "ModelInfo [name=" + name + ", label=" + label + ", scale=" + scale + "]";
	}
	
	
	
}
