/*
 * Decompiled with CFR 0.152.
 */
package param.cam.presentation;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import param.cam.CamFactory;
import param.cam.CamPackage;
import param.cam.presentation.CamEditor;
import param.presentation.ParamEditorAdvisor;
import param.presentation.ParamEditorPlugin;
import param.provider.ParamEditPlugin;

public class CamModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(ParamEditorPlugin.INSTANCE.getString("_UI_CamEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = ParamEditorPlugin.INSTANCE.getString("_UI_CamEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected CamPackage camPackage = CamPackage.eINSTANCE;
    protected CamFactory camFactory = this.camPackage.getCamFactory();
    protected CamModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(ParamEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ParamEditorPlugin.INSTANCE.getImage("full/wizban/NewCam")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.camPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, Collator.getInstance());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.camPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.camFactory.create(eClass);
        return rootObject;
    }

    public boolean performFinish() {
        URI fileURI;
        block3: {
            try {
                fileURI = this.getModelURI();
                if (!new File(fileURI.toFileString()).exists() || MessageDialog.openQuestion((Shell)this.getShell(), (String)ParamEditorPlugin.INSTANCE.getString("_UI_Question_title"), (String)ParamEditorPlugin.INSTANCE.getString("_WARN_FileConflict", new String[]{fileURI.toFileString()}))) break block3;
                this.initialObjectCreationPage.selectFileField();
                return false;
            }
            catch (Exception exception) {
                ParamEditorPlugin.INSTANCE.log(exception);
                return false;
            }
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = CamModelWizard.this.createInitialModel();
                        if (rootObject != null) {
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", CamModelWizard.this.initialObjectCreationPage.getEncoding());
                        resource.save(options);
                    }
                    catch (Exception exception) {
                        ParamEditorPlugin.INSTANCE.log(exception);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        this.getContainer().run(false, false, operation);
        return ParamEditorAdvisor.openEditor(this.workbench, fileURI);
    }

    public void addPages() {
        this.initialObjectCreationPage = new CamModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(ParamEditorPlugin.INSTANCE.getString("_UI_CamModelWizard_label"));
        this.initialObjectCreationPage.setDescription(ParamEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public URI getModelURI() {
        return this.initialObjectCreationPage.getFileURI();
    }

    public class CamModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Text fileField;
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public CamModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CamModelWizardInitialObjectCreationPage.this.setPageComplete(CamModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label resourceURILabel = new Label(composite, 16384);
            resourceURILabel.setText(ParamEditorPlugin.INSTANCE.getString("_UI_File_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            resourceURILabel.setLayoutData((Object)data);
            Composite fileComposite = new Composite(composite, 0);
            GridData data2 = new GridData();
            data2.horizontalAlignment = 3;
            fileComposite.setLayoutData((Object)data2);
            GridLayout layout2 = new GridLayout();
            data2.horizontalAlignment = 4;
            layout2.marginHeight = 0;
            layout2.marginWidth = 0;
            layout2.numColumns = 2;
            fileComposite.setLayout((Layout)layout2);
            this.fileField = new Text(fileComposite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.horizontalSpan = 1;
            this.fileField.setLayoutData((Object)data2);
            this.fileField.addModifyListener(this.validator);
            Button resourceURIBrowseFileSystemButton = new Button(fileComposite, 8);
            resourceURIBrowseFileSystemButton.setText(ParamEditorPlugin.INSTANCE.getString("_UI_Browse_label"));
            resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String[] filters = CamEditor.FILE_EXTENSION_FILTERS.toArray(new String[CamEditor.FILE_EXTENSION_FILTERS.size()]);
                    String[] files = ParamEditorAdvisor.openFilePathDialog(CamModelWizardInitialObjectCreationPage.this.getShell(), 8192, filters);
                    if (files.length > 0) {
                        CamModelWizardInitialObjectCreationPage.this.fileField.setText(files[0]);
                    }
                }
            });
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(ParamEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data3);
            this.initialObjectField = new Combo(composite, 2048);
            data3 = new GridData();
            data3.horizontalAlignment = 4;
            data3.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data3);
            for (String objectName : CamModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(ParamEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data4 = new GridData();
            data4.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data4);
            this.encodingField = new Combo(composite, 2048);
            data4 = new GridData();
            data4.horizontalAlignment = 4;
            data4.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data4);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            URI fileURI = this.getFileURI();
            if (fileURI == null || fileURI.isEmpty()) {
                this.setErrorMessage(null);
                return false;
            }
            String extension = fileURI.fileExtension();
            if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                this.setErrorMessage(ParamEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                return false;
            }
            this.setErrorMessage(null);
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.initialObjectField.clearSelection();
                this.encodingField.clearSelection();
                this.fileField.setFocus();
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : CamModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        public URI getFileURI() {
            try {
                return URI.createFileURI((String)this.fileField.getText());
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void selectFileField() {
            this.initialObjectField.clearSelection();
            this.encodingField.clearSelection();
            this.fileField.selectAll();
            this.fileField.setFocus();
        }

        protected String getLabel(String typeName) {
            try {
                return ParamEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                ParamEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(ParamEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }
}

