/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.runtime.util;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;

public class PolymorphicDispatcherExtensions {
    protected PolymorphicDispatcherExtensions() {
    }

    public static <T> T polymorphicInvokeBasedOnFeature(Object target, EClass eClass, EStructuralFeature feature, String prefix, Object ... args) {
        T invoke = PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeatureInternal(target, eClass, feature, prefix, args);
        if (invoke == null) {
            for (EClass superType : eClass.getEAllSuperTypes()) {
                invoke = PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeatureInternal(target, superType, feature, prefix, args);
                if (invoke == null) continue;
                return invoke;
            }
        }
        return invoke;
    }

    private static <T> T polymorphicInvokeBasedOnFeatureInternal(Object target, EClass eClass, EStructuralFeature feature, String prefix, Object ... args) {
        return PolymorphicDispatcherExtensions.createPolymorphicDispatcherBasedOnFeature(target, eClass, feature, prefix, args.length).invoke(args);
    }

    private static <T> PolymorphicDispatcher<T> createPolymorphicDispatcherBasedOnFeature(Object target, EClass eClass, EStructuralFeature feature, String prefix, int numOfParams) {
        return PolymorphicDispatcherExtensions.createPolymorphicDispatcher(target, PolymorphicDispatcherExtensions.featureBasedMethodPredicate(eClass, feature, prefix, numOfParams));
    }

    private static Predicate<Method> featureBasedMethodPredicate(EClass eClass, EStructuralFeature feature, String prefix, int numOfParams) {
        String featureName = feature.getName();
        String methodNamePrefix = String.valueOf(prefix) + eClass.getName() + "_";
        String predicateMethodName = String.valueOf(methodNamePrefix) + featureName;
        if (featureName.length() > 1 && Character.isUpperCase(featureName.charAt(1)) && Character.isLowerCase(featureName.charAt(0))) {
            char[] chars = featureName.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            final String alternativePredicateMethodName = String.valueOf(methodNamePrefix) + new String(chars);
            return new PolymorphicDispatcher.MethodNameFilter(predicateMethodName, numOfParams, numOfParams){

                @Override
                public boolean apply(Method param) {
                    String paramName = param.getName();
                    return (paramName.equals(this.methodName) || paramName.equals(alternativePredicateMethodName)) && param.getParameterTypes().length >= this.minParams && param.getParameterTypes().length <= this.maxParams;
                }
            };
        }
        return PolymorphicDispatcher.Predicates.forName(predicateMethodName, numOfParams);
    }

    public static <T> PolymorphicDispatcher<T> createPolymorphicDispatcher(Object target, Predicate<Method> predicate) {
        return new PolymorphicDispatcher<T>(Collections.singletonList(target), (Predicate)predicate){

            @Override
            protected T handleNoSuchMethod(Object ... params) {
                return null;
            }
        };
    }
}

