package supercad.graphics;

import java.util.ArrayList;

import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.frs.supercad.parametric_model.model.Primitive;

import dressing.mathutils.MathUtilities;

public class Quad implements Primitive {
	
	private final Vector3[] positions = new Vector3[4];
	private Vector3 normal;
	private Matrix4 TBN;
	private final Vertex[] vertices = new Vertex[4];
	
	Quad(Vector3... positions ) {
		if(vertices.length > 3) {
			this.positions[0] = positions[0];
			this.positions[1] = positions[1];
			this.positions[2] = positions[2];
			this.positions[3] = positions[3];
			calculateVerticesData();
		}
	}
	
	private void calculateVerticesData() {
		this.TBN = MathUtilities.calculateTBN(positions[0], positions[1], positions[2], new Vector3());
		normal = positions[1].cpy().sub(positions[0]).crs(positions[2].cpy().sub(positions[0])).nor();
		for(int i =0; i < 4; i++) {
			Vertex vertexInfo = new Vertex();
			vertexInfo.setPosition(positions[i]);
			vertexInfo.setNormal(normal);
			Vector3 tsCoords = positions[i].cpy().mul(TBN);
			vertexInfo.setTextureCoords(tsCoords.x, tsCoords.y);
			vertices[i] = vertexInfo;
		}
	}

	public ArrayList<VertexInfo> getVerticesInfo(){
		ArrayList<VertexInfo> infos = new ArrayList<VertexInfo>();
		for(Vertex vertex: this.vertices) {
			infos.add(vertex.toVertexInfo());
		}
		return infos;
	}

	@Override
	public Vertex[] toVertices() {
		return vertices;
	}

	@Override
	public void build(MeshPartBuilder partBuilder) {
		VertexInfo i0 = vertices[0].toVertexInfo();
		VertexInfo i1 = vertices[1].toVertexInfo();
		VertexInfo i2 = vertices[2].toVertexInfo();
		VertexInfo i3 = vertices[3].toVertexInfo();

		partBuilder.triangle(i0, i1, i2);
		partBuilder.triangle(i2, i3, i0);

	}




}