package gdxapp.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.ui.TextField.TextFieldStyle;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener.ChangeEvent;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;

import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;

public class TextZone extends Table{
	
	Table root;
	Label sizeLbl;
	TextArea textArea;
	Image colorImage;
	SelectBox selectBox;
	ColorPalette colorPalette;
	
	
	public TextZone() {
		super();
		setFillParent(true);
		

	}
	
	
	public void construct() {
		clear();
		textArea = new TextArea("", AssetsTextures.getInstance().getSkin());		
		TextFieldStyle textStyle = new TextFieldStyle();
		textStyle.font = new BitmapFont();
		textStyle.background = textArea.getStyle().background;
		textStyle.fontColor = Color.BLACK;
		textStyle.cursor = textArea.getStyle().cursor;
		textStyle.selection = textArea.getStyle().selection;
		textArea.setStyle(textStyle);
		textArea.setPrefRows(2);
		textArea.addListener(new ChangeListener() {
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				if(Gdx.input.isKeyJustPressed(Keys.ENTER)) {
					Gdx.app.debug("TextArea", "enter pressed");
					String text = textArea.getText();
					textArea.setText( text.substring(0, text.length()-2));
				}
			}
		});
		
		sizeLbl = new Label("taille", AssetsTextures.getInstance().getSkin(), "default");
		sizeLbl.setColor(Color.BLACK);
		
		selectBox = new SelectBox(AssetsTextures.getInstance().getSkin());
		Array<String> sizes = new Array<String>();
		String[] values =  {"8","9","10","11","12","14","16","18","20","22","24","26","28","36","48","72"};
		sizes.addAll(values);
		selectBox.setItems(sizes);
		selectBox.addListener(new ChangeListener() {
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				float value = Float.valueOf((String) selectBox.getSelected());
				textArea.getStyle().font.getData().setScale(value/18f);
				
			}
		});
		selectBox.setSelected("18");
		
		Texture texture = DrawingHelper.createUniform(Color.BLUE,32,32);
		colorImage = new Image(texture);
		colorPalette = new ColorPalette();
		colorPalette.construct();
		Window palette = UIComponentCreator.createColorPaletteWindow(colorPalette);
		colorImage.addListener(new InputListener() {
			@Override
			public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
				if(button == Input.Buttons.LEFT) {
					palette.setPosition(event.getStageX(), event.getStageY());
					palette.setVisible(true);
					colorImage.getStage().addActor(palette);
				}
				return super.touchDown(event, x, y, pointer, button);
			}
		});
		root = new Table();
		root.setFillParent(true);
		root.row().height(32).expandX().align(Align.left);
		root.add(sizeLbl).width(50).align(Align.left).pad(5);
		root.add(selectBox).width(100).align(Align.left);
		root.add(colorImage).width(32);
		root.add().fillX();
		root.row().expand();
		root.add(textArea).colspan(4).fill();
		root.invalidateHierarchy();
		root.setFillParent(true);
		addActor(root);
		invalidateHierarchy();
	}
	
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		DrawingHelper.drawCutLine(new Vector2(getX(),getY()), new Vector2(getX() + getWidth(),getY()), batch, Color.BLACK, 1, 6, 3);
		DrawingHelper.drawCutLine(new Vector2(getX(),getY()), new Vector2(getX() ,getY() + getHeight()), batch, Color.BLACK, 1, 6, 3);
		DrawingHelper.drawCutLine(new Vector2(getX() + getWidth(),getY()), new Vector2(getX() + getWidth(),getY() + getHeight()), batch, Color.BLACK, 1, 6, 3);
		DrawingHelper.drawCutLine(new Vector2(getX(),getY() + getHeight()), new Vector2(getX() + getWidth(),getY() + getHeight()), batch, Color.BLACK, 1, 6 ,3);
		
		super.draw(batch, parentAlpha);
	}

	public TextArea getTextArea() {
		return textArea;
	}

	public SelectBox getSelectBox() {
		return selectBox;
	}
	
	@Override
	public Color getColor() {
		return colorPalette.getColor();
	}
	

	
	
	
	
}
