package gdxapp.ui;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;

public class CursorProvider {


	private final String RULER_ICON = "C:\\ProgramData\\supercad\\icons\\icons8-tape-measure-32.png";
	private final String HAND_ICON = "C:\\ProgramData\\supercad\\icons\\icons8-one-finger-32.png";
	private final String PEN_ICON = "C:\\ProgramData\\supercad\\icons\\icons8-pencil-32.png";
	

	private Cursor RULER;
	private Cursor HAND;
	private Cursor PENCIL;
	
	private boolean ready = false;
	
	private static CursorProvider instance;
	
	public CursorProvider() {
		super();
	}

	public void init() {
		Pixmap pm = new Pixmap(Gdx.files.absolute(RULER_ICON));
		RULER = Gdx.graphics.newCursor(pm, 1, 30);
		pm.dispose();
		pm = new Pixmap(Gdx.files.absolute(HAND_ICON));
		HAND = Gdx.graphics.newCursor(pm, 11, 2);
		pm.dispose();
		
		pm = new Pixmap(Gdx.files.absolute(PEN_ICON));
		PENCIL = Gdx.graphics.newCursor(pm, 1, 30);
		pm.dispose();
		ready = true;
	}

	public static CursorProvider getInstance() {
		if(instance == null) {			
			instance = new CursorProvider();
		}
		return instance;
	}
	
	public void setDefault() {
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
    }
	
	public void useRuler() {
		Gdx.graphics.setCursor(RULER);
	}
	
	public void useHand() {
		Gdx.graphics.setCursor(HAND);
	}
	
	public void usePencil() {
		Gdx.graphics.setCursor(PENCIL);
	}
	
}
