package gdxapp.screens.ObjectEditor.uicomponents;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.assets.AssetsTextures;
import gdxapp.scenes.SceneEvent;

public class TopBar extends Table{
	
	private TextButton layoutBtn;
	private TextButton modelingBtn;
	private TextButton sculptingBtn;
	private TextButton insertingBtn;



	public TopBar() {
		createContents();
	}

	private void createContents() {
	    layoutBtn = new TextButton("Layout", AssetsTextures.getInstance().getSkin());
	    layoutBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.LAYOUT_BTN_PRESSED.name(), null));
			}
	    });
	    
	    modelingBtn = new TextButton("Modeling", AssetsTextures.getInstance().getSkin());
	    
	    modelingBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.MODELING_BTN_PRESSED.name(), null));
			}
	    });
	    sculptingBtn = new TextButton("Sculpting", AssetsTextures.getInstance().getSkin());
	    insertingBtn = new TextButton("Insertion", AssetsTextures.getInstance().getSkin());
	    
	    add(layoutBtn);
	    add(modelingBtn);
	    add(sculptingBtn);
	    add(insertingBtn);
	    add(new ProjectionTable()).expandX().right();
	}

}
