package gdxapp.screens.ObjectEditor.uicomponents;

import java.util.Arrays;

import org.eclipse.ui.views.framelist.UpAction;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.ObjectEditor.EditorSkin;
import gdxapp.screens.ObjectEditor.TargetCamera.SIDE;

public class ProjectionTable extends Table {
	
	private ImageButton topBtn;
	private ImageButton bottomBtn;
	private ImageButton frontBtn;
	private ImageButton backBtn;
	private ImageButton leftBtn;
	private ImageButton rightBtn;
	
	private ImageButton topArrow;
	private ImageButton downArrow;
	private ImageButton leftArrow;
	private ImageButton rightArrow;
	
	
	private int[][] transitions ;
	
	ImageButton[] btns;
	ImageButton[] arrows;
	
	private Cell sideCell;


	public ProjectionTable() {
		super();
		setFillParent(true);
		createContents();
		transitions = new  int[][] {	{2, 3, 4, 5},
										{2, 3, 5, 4},
										{1, 0, 5, 4},
										{0, 1, 5, 4},
										{2, 3, 1, 0},
										{2, 3, 0, 1}	}; 
	}

	private void createContents() {
		topBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.TOP_VUE_STYLE));
		topBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SIDE_PROJECTION.name(), SIDE.TOP));
			}
		});
		
		bottomBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.BOTTOM_VUE_STYLE));
		bottomBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SIDE_PROJECTION.name(), SIDE.BOTTOM));
			}
		});
		
		frontBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.FRONT_VUE_STYLE));
		frontBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SIDE_PROJECTION.name(), SIDE.FACE));
			}
		});
		
		backBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.BACK_VUE_STYLE));
		backBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SIDE_PROJECTION.name(), SIDE.BACK));
			}
		});
		
		leftBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.LEFT_VUE_STYLE));
		leftBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SIDE_PROJECTION.name(), SIDE.LEFT));
			}
		});
		
		rightBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.RIGHT_VUE_STYLE));
		rightBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SIDE_PROJECTION.name(), SIDE.RIGHT));
			}
		});
		
		topArrow = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.UP_ARROW_STYLE));
		topArrow.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				updateSide(topArrow);
			}
		});
		downArrow = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.DOWN_ARROW_STYLE));
		downArrow.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				updateSide(downArrow);
			}
		});
		leftArrow = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.LEFT_ARROW_STYLE));
		leftArrow.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				updateSide(leftArrow);
			}
		});
		rightArrow = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.RIGHT_ARROW_STYLE));
		rightArrow.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				updateSide(rightArrow);
			}
		});
		
		btns = new ImageButton[]{frontBtn, backBtn, topBtn, bottomBtn, leftBtn, rightBtn};
		arrows = new ImageButton[]{topArrow, downArrow, leftArrow, rightArrow};
		
		pad(5);
		add(downArrow).colspan(3).center().width(32).height(32);
		row();
		add(rightArrow).left().width(32).height(32);
		sideCell = add(frontBtn);
		add(leftArrow).right().width(32).height(32);
		row();
		add(topArrow).colspan(3).center().width(32).height(32);
	}
		
	private void updateSide(ImageButton source) {
		int i = Arrays.asList(btns).indexOf(sideCell.getActor());
		int j = Arrays.asList(arrows).indexOf(source);
		
		if(i >= 0 && j >= 0) {
			int index = transitions[i][j];
			sideCell.clearActor();
			sideCell.setActor(btns[index]);
			sideCell.width(64).height(64);
		}
	}

}
