package dressing.ui.util;

import java.util.Map;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.ui.DoubleTextFieldFactory;
import param.MechanicPublicParam;
import param.TypeDefElement;

public class PublicParamEditorComposite {

	private Text text;
	private Button button;
	private Button buttonChangeable;
	private Control control;
	private ComboViewer comboViewer;
	private MechanicPublicParam param;
	private Map<MechanicPublicParam, PublicParamEditorComposite> dirtyParams;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 * @param dirtyParams 
	 */
	public PublicParamEditorComposite(Composite parent, int style,MechanicPublicParam param, Map<MechanicPublicParam, PublicParamEditorComposite> dirtyParams,boolean isshowlabel) {
		this.dirtyParams=dirtyParams;
		int nbcol=param.getUi_colspan()+param.getUi_labelColspan();
		if(!isshowlabel) {
			nbcol=1;
		}
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
		{
			
			if(isshowlabel &&param.getUi_labelColspan()>0) {
				Label lblName = new Label(parent, SWT.WRAP);
				lblName.setText(param.getUserlabel());
				GridData gd=new GridData(SWT.LEFT, SWT.CENTER, false, false, param.getUi_labelColspan(), 1);
				lblName.setLayoutData(gd);
				lblName.setBackground(parent.getBackground());
			}
			this.param=param;
			text=DoubleTextFieldFactory.createDoubleTextField(parent, SWT.BORDER);;//numberfield.getText();
			text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, param.getUi_colspan(), 1));
//			text.setBackground(parent.getBackground());
			text.setText(this.param.getDefaultvalue());
			if(param.getDescription()!=null && !param.getDescription().isEmpty())
			{
				text.setToolTipText(param.getDescription());
			}
			
			this.control = this.text;
			text.addModifyListener(new ModifyListener() {
				
				@Override
				public void modifyText(ModifyEvent e) {
					dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
					
				}
			});
		}
		else if(param.getTypedef()!=null && param.getTypedefelement()!=null) {
			if(param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				button = new Button(parent, SWT.CHECK);
				button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, nbcol, 1));
				button.setSelection(Boolean.valueOf(param.getTypedefelement().getKey()));
				button.setBackground(parent.getBackground());
				if(param.getDescription()!=null && !param.getDescription().isEmpty())
				{
					button.setToolTipText(param.getDescription());
				}
				this.param=param;
				this.control = this.button;
				button.addSelectionListener(new SelectionListener() {
					
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
					}
					
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						
					}
				});
				if(isshowlabel) {
					button.setText(param.getUserlabel());
				}
			}
			else {
				if(isshowlabel && param.getUi_labelColspan()>0) {
					Label lblName = new Label(parent, SWT.WRAP);
					lblName.setText(param.getUserlabel()!=null?param.getUserlabel():"");
					GridData gd=new GridData(SWT.LEFT, SWT.CENTER, false, false, param.getUi_labelColspan(), 1);
					lblName.setLayoutData(gd);
					lblName.setBackground(parent.getBackground());

				}
				
				this.param=param;
				comboViewer = new ComboViewer(parent, SWT.READ_ONLY);
				Combo combo = comboViewer.getCombo();
				combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, param.getUi_colspan(), 1));
				comboViewer.setContentProvider(TypeDefContentProvider.getInstance());
				comboViewer.setLabelProvider(TypeDefElementLabelProvider.getInstance());
				comboViewer.setInput(param.getTypedef());
				comboViewer.setSelection(new StructuredSelection(param.getTypedefelement()), true);
				combo.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
				if(param.getDescription()!=null && !param.getDescription().isEmpty())
				{
					combo.setToolTipText(param.getDescription());
				}
				comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {
					
					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						// TODO Auto-generated method stub
						dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
					}
				});
				this.control = this.comboViewer.getControl();
			}
			
		}
		buttonChangeable = new Button(parent, SWT.CHECK);
		buttonChangeable.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		buttonChangeable.setSelection(param.isChangeable());
		buttonChangeable.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		buttonChangeable.setText("Modifiable");

	}
	
	public Control getControl() {
		return control;
	}

	public void updateValues() {
		updateValues(this.param);
	}
	
	public void updateValues(MechanicPublicParam param) {
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
		{
			param.setDefaultvalue(DoubleTextFieldFactory.cleanLeadingZeros(text.getText().trim()));
		}
		else if(param.getTypedef()!=null && param.getTypedefelement()!=null) {
			if(param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				param.setTypedefelement(param.getTypedef().getElement(String.valueOf(button.getSelection())));
			}
			
			else {
				param.setTypedefelement((TypeDefElement) comboViewer.getStructuredSelection().getFirstElement());
			}
		}
		param.setChangeable(buttonChangeable.getSelection());
	}
	/**
	 * this method is used after creation to set values from another param such as an option param
	 * @param param
	 * @param notifyChange whether to consider this change a user change and propagate the notifications
	 */
	public void setValues(MechanicPublicParam param,boolean notifyChange) {
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
		{
			text.setText(param.getDefaultvalue());
		}else if(param.getTypedef()!=null && param.getTypedefelement()!=null) {
			if(param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				button.setSelection(Boolean.valueOf(param.getTypedefelement().getKey()));
			}else {
				comboViewer.setSelection(new StructuredSelection(param.getTypedefelement()), true);
			}
		}
		if(notifyChange)
		{
			dirtyParams.put(this.param, this);
		}
		buttonChangeable.setSelection(param.isChangeable());
		this.control.setBackground(new Color(0, 255, 20));
	}
}
