package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import dressing.controller.ProjectCreator;
import dressing.model.DesignException;

public class CreateProjectPage extends WizardPage{

	CreateProjectComposite compos;
	private ProjectCreator creator;
	PropertyChangeListener pcl;
	boolean errorfound = true;
	protected CreateProjectPage(ProjectCreator creator) {
		super("Nouveau Projet");
		setTitle("Nouveau Projet");
		this.creator = creator;
		pcl= new PropertyChangeListener() {

			@Override
			public void propertyChange(PropertyChangeEvent evt) {
					if(isCurrentPage())
					{
						if(CreateProjectPage.this!=null)
						{
							
							if (getWizard().getContainer() != null)
							{
								getWizard().getContainer().updateButtons();
							}
						}
					}
			}
		};
		this.creator.addPropertyChangeListener(pcl);
	}

	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		compos = new CreateProjectComposite(parent, SWT.NONE,this.creator);
		setControl(compos);
		getWizard().getContainer().updateButtons();
	}

	@Override
	public boolean isPageComplete() {
		try {
			creator.checkProject();
			setErrorMessage(null);
			errorfound = false;
			setMessage("Vous pouvez remplir les informations du projet", WizardPage.INFORMATION);
		} catch (DesignException e) {
			setErrorMessage(e.getMessage());
			errorfound = true;
		}
		boolean isComplete = !errorfound;
		
		return isComplete;
		
	}
	
	public void clearlistners() {
		creator.removePropertyChangeListener(pcl);
	}
	
}
