package dressing.ui.exemples.tableaux;

import java.util.ArrayList;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.ui.util.SwtTextFilter;



/**
 * 
 * @author HP this class of use as the main class for the viewer
 */
public class ClientEditor{

	public static final String NAME = "Name";
	public static final String AGE = "Age";
	/**
	 * definition of the proportie of the tableViewer matching its columns
	 */
	public static final String[] PROPS = { NAME, AGE };

	// The data model
	public static java.util.List<Client> clients;
	private static Shell shell;
	/**
	 * constructor with the instanciation of the list
	 */
	public ClientEditor() {
		

	}



//	  protected Control createContents(Composite parent) {
//		    Composite composite = new Composite(parent, SWT.NONE);
//		    composite.setLayout(new GridLayout(1, false));
//
//		    // Add a button to create the new person
//		    Button newclient = new Button(composite, SWT.PUSH);
//		    newclient.setText("Create New Person");
//
//		    // Add the TableViewer
//		    final TableViewer tv = new TableViewer(composite, SWT.FULL_SELECTION);
//		    tv.setContentProvider(new ClientContentProvider());
//		    tv.setLabelProvider(new ClientLabelProvider());
//		    tv.setInput(clients);
//
////		    // Set up the table
//		    Table table = tv.getTable();
//		    table.setLayoutData(new GridData(GridData.FILL_BOTH));
////
//		    /**
//		     * create the columns and set their text that will reference them and help us know what property to put in it
//		     */
//		    new TableColumn(table, SWT.CENTER).setText(NAME);
//		    new TableColumn(table, SWT.CENTER).setText(AGE);
////
//		    /**
//		     * we invoke th pack() method to make the shell recognize the columns and show them 
//		     * 
//		     */
//		    for (int i = 0, n = table.getColumnCount(); i < n; i++) {
//		      table.getColumn(i).pack();
//		    }
////
//		    table.setHeaderVisible(true);
//		    table.setLinesVisible(true);
//
//		    // Add a new client when the user clicks button
//		    newclient.addSelectionListener(new SelectionAdapter() {
//			
//		      public void widgetSelected(SelectionEvent event) {
//		       Client c = new Client();
//		        c.setNom("Name");		       
//		        c.setAge(Integer.valueOf("0"));		      
//		        clients.add(c);
//		        tv.refresh();
//  
//		      }
//		    });
////
//		    
//		    
//		    
//		    
//		    // Create the cell editors
//		    CellEditor[] editors = new CellEditor[2];
//		    editors[0] = new TextCellEditor(table); 
//		    editors[1] = new TextCellEditor(table);
//		  
//		    // Set the editors, cell modifier, and column properties
//		    tv.setColumnProperties(PROPS);
//		    tv.setCellModifier(new ClientCellModifier(tv));
//		    tv.setCellEditors(editors);
//
//		    return composite;
//		  }

		  /**
		   * The application entry point
		   * 
		   * @param args
		   *            the command line arguments
		   */
		  public static void main(String[] args) {
			  clients=new ArrayList<Client>();
//			  clE.configureShell();
			  Display display = new Display();
				shell = new Shell(display);
				shell.setSize(500, 700);
				shell.setText("A Table Shell Example");
				
				GridLayout gl = new GridLayout();
				gl.numColumns = 1;
				shell.setLayout(gl);
				shell.setBounds(100, 100, 1200, 1000);
	
				    // Add a button to create the new person
				    Button newclient = new Button(shell, SWT.PUSH);
				    newclient.setText("Create New Person");
		
				    // Add the TableViewer
				    final TableViewer tv = new TableViewer(shell,
							SWT.MULTI | SWT.BORDER | SWT.FULL_SELECTION | SWT.CHECK | SWT.V_SCROLL | SWT.H_SCROLL);

					TableLayout tlayout = new TableLayout();
					tlayout.addColumnData(new ColumnWeightData(40, 100, true));
					tlayout.addColumnData(new ColumnWeightData(40, 100, true));
					tlayout.addColumnData(new ColumnPixelData(100, true));
					tv.getTable().setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 2, 1));

					tv.getTable().setLayout(tlayout);
				    tv.setContentProvider(new ClientContentProvider());
				    tv.setLabelProvider(new ClientLabelProvider());
				    tv.setInput(clients);

//				    // Set up the table
				    Table table = tv.getTable();
				    table.setLayoutData(new GridData(GridData.FILL_BOTH));
				    table.setSize(800, 600);
		
		
				    /**
				     * create the columns and set their text that will reference them and help us know what property to put in it
				     */
				    TableColumn tblClmn=   new TableColumn(table, SWT.CENTER);
				    tblClmn.setText(NAME);
				    tblClmn.setWidth(300);
				    TableColumn tblClmn1=  new TableColumn(table, SWT.CENTER);
				    tblClmn1.setText(AGE);
				    tblClmn1.setWidth(300);
				    /**
				     * we invoke th pack() method to make the shell recognize the columns and show them 
				     * 
				     */
				    for (int i = 0, n = table.getColumnCount(); i < n; i++) {
				      table.getColumn(i).pack();
				    }
		//
				    table.setHeaderVisible(true);
				    table.setLinesVisible(true);

				    // Add a new client when the user clicks button
				    newclient.addSelectionListener(new SelectionAdapter() {
					
				      public void widgetSelected(SelectionEvent event) {
				       Client c = new Client();
				        c.setNom("Name");		       
				        c.setAge(Integer.valueOf("0"));		      
				        clients.add(c);
				        tv.refresh();
		  
				      }
				    });
		//
				    
				    
				    
				    
				    // Create the cell editors
				    CellEditor[] editors = new CellEditor[2];
				    editors[0] = new TextCellEditor(table); 
				    editors[1] = new TextCellEditor(table);
			
				    
				    editors[1].getControl().addListener(SWT.Verify, new Listener() {
						
						@Override
						public void handleEvent(Event event) {
							SwtTextFilter.ASINT(editors[1].getControl(), event);
							
						}
					});
				    // Set the editors, cell modifier, and column properties
				    tv.setColumnProperties(PROPS);
				    tv.setCellModifier(new ClientCellModifier(tv));
				    tv.setCellEditors(editors);

				shell.pack();
				shell.open();
				while (!shell.isDisposed()) {
					if (!display.readAndDispatch())
						display.sleep();
				}
				display.dispose();
//			  clE.createContents(shell);
		  }
//	private void configureShell() {
//		Display display = new Display();
//		shell = new Shell(display);
//		shell.setSize(500, 700);
//		shell.setBounds(200, 400,500,500);
//
//		
//	
//		shell.setText("A Table Shell Example");
//		GridLayout gl = new GridLayout();
//		gl.numColumns = 2;
//		shell.setLayout(gl);
//		shell.setBounds(100, 100, 800, 600);
//		shell.pack();
//		shell.open();
//		while (!shell.isDisposed()) {
//			if (!display.readAndDispatch())
//				display.sleep();
//		}
//		display.dispose();
//	}

}
