package dressing.model.persistence.dpos;

import com.badlogic.gdx.math.Vector3;

import gdxapp.shaders.PbrMaterial;


public class PbrMaterialDPO implements DPO<PbrMaterial>{
	
	private String name;
	private Vector3 albedo;
	private float metalness;
	private float roughness;
	private float ambiantOcclusion;
	private float opacity = 1.0f;
	private String albedoMapPath;
	private String normalMapPath;
	private String metalnessMapPath;
	private String roughnessMapPath;
	private String aoMapPath;
	private String opacityMapPath;
	
	
	public void set(PbrMaterial material) {
		setName(material.getName());
		setAlbedo(material.getAlbedo());
		setAlbedoMapPath(material.getAlbedoMapPath());
		setAmbiantOcclusion(material.getAmbiantOcclusion());
		setAoMapPath(material.getAoMapPath());
		setMetalness(material.getMetalness());
		setMetalnessMapPath(material.getMetalnessMapPath());
		setNormalMapPath(material.getNormalMapPath());
		setOpacityMapPath(material.getOpacityMapPath());
		setOpacity(material.getOpacity());
		setRoughness(material.getRoughness());
		setRoughnessMapPath(material.getRoughnessMapPath());
	}
	

	@Override
	public DPO<PbrMaterial> from(PbrMaterial entity) {
		set(entity);
		return this;
	}

	@Override
	public PbrMaterial get() {
		PbrMaterial material = new PbrMaterial();
		material.setName(name);
		material.setAlbedo(albedo);
		material.setRoughness(roughness);
		material.setMetalness(metalness);
		material.setOpacity(opacity);
		material.setAmbiantOcclusion(ambiantOcclusion);
		material.setAlbedoMapPath(albedoMapPath);
		material.setNormalMapPath(normalMapPath);
		material.setRoughnessMapPath(roughnessMapPath);
		material.setMetalnessMapPath(metalnessMapPath);
		material.setOpacityMapPath(opacityMapPath);
		material.setAoMapPath(aoMapPath);
		return material;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public Vector3 getAlbedo() {
		return albedo;
	}


	public void setAlbedo(Vector3 albedo) {
		this.albedo = albedo;
	}


	public float getMetalness() {
		return metalness;
	}


	public void setMetalness(float metalness) {
		this.metalness = metalness;
	}


	public float getRoughness() {
		return roughness;
	}


	public void setRoughness(float roughness) {
		this.roughness = roughness;
	}


	public float getAmbiantOcclusion() {
		return ambiantOcclusion;
	}


	public void setAmbiantOcclusion(float ambiantOcclusion) {
		this.ambiantOcclusion = ambiantOcclusion;
	}


	public float getOpacity() {
		return opacity;
	}


	public void setOpacity(float opacity) {
		this.opacity = opacity;
	}


	public String getAlbedoMapPath() {
		return albedoMapPath;
	}


	public void setAlbedoMapPath(String albedoMapPath) {
		this.albedoMapPath = albedoMapPath;
	}


	public String getNormalMapPath() {
		return normalMapPath;
	}


	public void setNormalMapPath(String normalMapPath) {
		this.normalMapPath = normalMapPath;
	}


	public String getMetalnessMapPath() {
		return metalnessMapPath;
	}


	public void setMetalnessMapPath(String metalnessMapPath) {
		this.metalnessMapPath = metalnessMapPath;
	}


	public String getRoughnessMapPath() {
		return roughnessMapPath;
	}


	public void setRoughnessMapPath(String roughnessMapPath) {
		this.roughnessMapPath = roughnessMapPath;
	}


	public String getAoMapPath() {
		return aoMapPath;
	}


	public void setAoMapPath(String aoMapPath) {
		this.aoMapPath = aoMapPath;
	}


	public String getOpacityMapPath() {
		return opacityMapPath;
	}


	public void setOpacityMapPath(String opacityMapPath) {
		this.opacityMapPath = opacityMapPath;
	}
	
	
}
