package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;
import dressing.ui.parts.GdxPart;
import dressing.ui.parts.ParametersPart;
import dressing.ui.parts.ProjectExplorerPart;
import dressing.ui.parts.ProjectTreePart;

public class SaveHandler {
	
	@Inject ESelectionService selectionService;
	@CanExecute
	public boolean canExecute(EPartService partService) {
		if (partService != null) {
			if (partService.getDirtyParts().isEmpty()) {
				return false;

			} else {
				for (MPart part : partService.getDirtyParts()) {
					Object o = part.getObject();
					if (o != null && o instanceof ProjectTreePart) {
						return true;
					}
					if (o != null && o instanceof ParametersPart) {
						return true;
					}
					
					if( o instanceof ProjectExplorerPart) {
						return true;
					}
					if(o instanceof GdxPart) {
						return true;
					}
				}
				return false;
			}

		}
		return false;
	}
	@Execute
	public void execute(EPartService partService,Shell shell) {				
		
		partService.savePart(partService.getActivePart(), false); //enregister 
		

		
	}
}