package dressing.handlers;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.types.PieceType;
import dressing.ui.printreport.PrintPreviewDemo;

public class PrintReportHandler {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	List<Piece2D> pieces;
	@Execute
	public void execute() {
		pieces=new ArrayList<Piece2D>();
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof DesignObject3D )
		{
			DesignObject3D object3d =(DesignObject3D)o;
			 fillpiece2d( object3d);
			PrintPreviewDemo pv=new PrintPreviewDemo(pieces);
			pv.setVisible(true);
		}	
	
	}
	
	
	private void fillpiece2d(DesignObject3D object3d) {
		for(DesignObject3D o:object3d.getChilds()) {
			if(o instanceof Piece2D) {
				pieces.add((Piece2D) o);
				if(((Piece2D) o).getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)
						||((Piece2D) o).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
					fillpiece2d( o);
				}
			}else {
				fillpiece2d( o);
			}
			
		}
	}


	@CanExecute
	public boolean canExecute() {
		

//		Object o = selectionService.getSelection("dressing.part.tree");
//		if(o!=null && o instanceof DesignObject3D && ((DesignObject3D)o).getParams()!=null)
//		{
			return true;

//		}else {
//			return false;
//		}
	}
}
