package dressing.controller.tools;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Stage;

import dressing.events.EventDriver;
import dressing.handlers.gdx.ToolControlHandler;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ArrowTaker;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.MeasuresTaker;
import gdxapp.Commun.Object2DMover;
import gdxapp.Commun.ScreenController;
import gdxapp.Commun.TextWriter;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.room.SurfaceSelector;
import gdxapp.shapes.ShapeType;
import gdxapp.zoneselector.ZoneSelector;


public class ToolController {
	private static ToolController instance;
	
    private boolean DRAW_WALL=false;
    private boolean DRAW_ROOM_POLYGONE=false;
    private boolean DRAW_ARC=false;
    private boolean DRAW_BATTANTE=false;
    private boolean ALLOW_WALL_MOVE=false;
    private boolean DRAW_POLYGONE_MARBLE=false;
    private boolean DRAW_EXTRUSION = false;
    private boolean MEASURE_DISTANCE=false;
    private boolean ARROW_TAKER=false;
    private boolean ZOOM=false;
    private boolean DRAG_OBJECTS=false;
    private boolean SELECT_ZONE=false;
    private boolean SELECT_Objects=true;
    private boolean SELECT_SURFACE=false;
    private boolean FREE_MOVE = false;
    private boolean FREEZE_MOVE = false;


	/**
	 * Returns an instance of ToolController. Since instances of this
	 * class do not maintain any state, they can be shared between multiple
	 * clients.
	 *
	 * @return an instance of ArrayContentProvider
	 *
	 * @since 3.5
	 */
	public static ToolController getInstance() {
		synchronized(ToolController.class) {
			if (instance == null) {
				instance = new ToolController();
			}
			return instance;
		}
	}
	public void setTool(DesignTools tool) {
		switch (tool) {
		case ALLOW_WALL_MOVE:
			setALLOW_WALL_MOVE();
			break;
		case DRAG_OBJECTS:
			setDRAG_OBJECTS();
			break;
		case DRAW_ROOM_POLYGONE:
			setDRAW_ROOM_POLYGONE(ShapeType.POLYGON);
			break;
		case DRAW_WALL:
			setDRAW_WALL();
			break;
		case MEASURE_DISTANCE:
			setMEASURE_DISTANCE();
			break;
		case SELECT_Objects:
			setSELECT_Objects();
			break;
		case SELECT_SURFACE:
			setSELECT_SURFACE();
			break;
		case SELECT_ZONE:
			setSELECT_ZONE();
			break;
		case ZOOM:
			setZOOM();
			break;
		case DRAW_POLYGONE_MARBLE:
			setDRAW_POLYGONE_MARBLE();
			break;
		case DRAW_EXTRUSION:
			setDraw_EXTRUSION();
			break;
		case FREE_MOVE:
			setFREE_MOVE();
			break;
		default:
			break;
		}
	}
	
	private void setDraw_EXTRUSION() {
		DRAW_EXTRUSION = !DRAW_EXTRUSION;
	}
	
	public boolean isDRAW_EXTRUSION() {
		return DRAW_EXTRUSION;
	}
	public boolean isDRAW_POLYGONE_MARBLE() {
		return DRAW_POLYGONE_MARBLE;
	}
	public void setDRAW_POLYGONE_MARBLE() {
		DRAW_POLYGONE_MARBLE = true;
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		MeasuresTaker.getInstance().end();
		Object2DMover.getInstance().finish();
		ZoneSelector.getSelector().remove();
		//ShapeDrawer.getInstance().createMarble();
		GroupSelection.getInstance().clearSelection();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
	}
	

	
	public boolean isDRAW_WALL() {
		return DRAW_WALL;
	}
	public void setDRAW_WALL() {
		DRAW_WALL = true;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		MeasuresTaker.getInstance().end();
		ZoneSelector.getSelector().remove();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		//ShapeDrawer.getInstance().finish();
	}


	public boolean isDRAW_ROOM_POLYGONE() {
		return DRAW_ROOM_POLYGONE;
	}
	

	
	public void setDRAW_ROOM_POLYGONE(ShapeType shape) {
		
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = true;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		MeasuresTaker.getInstance().end();
		Object2DMover.getInstance().finish();
		ZoneSelector.getSelector().remove();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		EventDriver.getDriver().deliverEvent(SceneEvent.INVOKE_POLY_DRAWER, shape);

	}
	public boolean isDRAW_BATTANTE() {
		return DRAW_BATTANTE;
	}

	public boolean isALLOW_WALL_MOVE() {
		return ALLOW_WALL_MOVE;
	}
	public void setALLOW_WALL_MOVE() {
		ALLOW_WALL_MOVE=!ALLOW_WALL_MOVE;
	}
	public boolean isMEASURE_DISTANCE() {
		return MEASURE_DISTANCE;
	}
	public void setMEASURE_DISTANCE() {
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = true;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		ARROW_TAKER=false;
		GroupSelection.getInstance().clearSelection();
		ZoneSelector.getSelector().remove();
		Object2DMover.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		
		
		EventDriver.getDriver().deliverEvent(SceneEvent.INVOKE_MEASURER, null);

		//ShapeDrawer.getInstance().finish();
	}
	
	public boolean isARROW_TAKER() {
		return ARROW_TAKER;
	}
	public void setARROW_TAKER() {
		ARROW_TAKER=true;
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		
		try {
			AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
			ScreenController controller = screen.getController();
			Stage stage = controller.getStage();
			if(!stage.getActors().contains(ArrowTaker.getInstance(), true)) {
				stage.addActor(ArrowTaker.getInstance());
				ArrowTaker.getInstance().setkeyboardFocus();
				GroupSelection.getInstance().clearSelection();
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
		ZoneSelector.getSelector().remove();
		MeasuresTaker.getInstance().end();
		Object2DMover.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		//ShapeDrawer.getInstance().finish();
	}
	public boolean isZOOM() {
		return ZOOM;
	}
	public void setZOOM() {
		if(ZOOM)
		{
			ToolControlHandler.getInstance().triggerSelectObject();
			return;
		}
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = true;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		MeasuresTaker.getInstance().end();
		ZoneSelector.getSelector().remove();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		//ShapeDrawer.getInstance().finish();
		ToolControlHandler.getInstance().triggerDeactivateSelectObject();

	}
	public boolean isDRAG_OBJECTS() {
		return DRAG_OBJECTS;
	}
	public void setDRAG_OBJECTS() {
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM =false;
		DRAG_OBJECTS = true;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		MeasuresTaker.getInstance().end();
		ZoneSelector.getSelector().remove();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		try {
			AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
			ScreenController controller = screen.getController();
			Stage stage = controller.getStage();
			if(!stage.getActors().contains(Object2DMover.getInstance(), true)) {
				stage.addActor(Object2DMover.getInstance());
				Object2DMover.getInstance().setkeyboardFocus();
			}
		}catch (Exception e) {
			e.printStackTrace();
		}

	}
	
	public boolean isSELECT_ZONE() {
		return SELECT_ZONE;
	}
	
	public void setSELECT_ZONE() {
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE =true;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		
		try {
			AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
			ScreenController controller = screen.getController();
			if(!controller.getStage().getActors().contains(ZoneSelector.getSelector(), true)) {
				controller.getStage().addActor(ZoneSelector.getSelector());
				ZoneSelector.getSelector().setkeyboardFocus();
				GroupSelection.getInstance().clearSelection();
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
		MeasuresTaker.getInstance().end();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
	}
	
	
	public boolean isSELECT_Objects() {
		return SELECT_Objects;
	}
	public void setSELECT_Objects() {
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = true;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		ZoneSelector.getSelector().remove();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		ToolControlHandler.getInstance().triggerDeactivateZoom();
	}
	public boolean isSELECT_SURFACE() {
		return SELECT_SURFACE;
	}
	public void setSELECT_SURFACE() {
		if(SELECT_SURFACE) {
			return;
		}
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = true;
		DRAW_POLYGONE_MARBLE = false;
		RoomController.getInstance().addSurfaceSelector();
		MeasuresTaker.getInstance().end();
		ZoneSelector.getSelector().remove();
		GroupSelection.getInstance().clearSelection();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
	}
	public void setDRAW_WALL(boolean b) {
		DRAW_WALL = true;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		MeasuresTaker.getInstance().end();
		ZoneSelector.getSelector().remove();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
	}
	public void setWriteText() {
		DRAW_WALL = false;
		DRAW_ROOM_POLYGONE = false;
		DRAW_BATTANTE = false;
		MEASURE_DISTANCE = false;
		ARROW_TAKER=false;
		ZOOM = false;
		DRAG_OBJECTS = false;
		SELECT_ZONE = false;
		SELECT_Objects = false;
		SELECT_SURFACE = false;
		DRAW_POLYGONE_MARBLE = false;
		MeasuresTaker.getInstance().end();
		ZoneSelector.getSelector().remove();
		Object2DMover.getInstance().finish();
		ArrowTaker.getInstance().finish();
		SurfaceSelector.getInstance().remove();
		Screen screen = Scene.game.getScreen();
		if(screen instanceof AbstractScreen) {
			((AbstractScreen)screen).getController().getUIStage().addActor(TextWriter.getWriter());
			TextWriter.getWriter().setkeyboardFocus();
			GroupSelection.getInstance().clearSelection();
		}
	}
	
	public void setDrawExtrusion() {
		DRAW_EXTRUSION = !DRAW_EXTRUSION;
	}
	
	public void setDrawExtrusion(boolean value) {
		DRAW_EXTRUSION = value;
	}
	
	
	
	public boolean isFREE_MOVE() {
		return FREE_MOVE;
	}
	public void setFREE_MOVE() {
		FREE_MOVE = !FREE_MOVE;
	}
	
	
	public boolean isFREEZE_MOVE() {
		return FREEZE_MOVE;
	}
	public void setFREEZE_MOVE() {
		FREEZE_MOVE = !FREEZE_MOVE;
	}
	public void unzoom() {
		Screen screen = Scene.game.getScreen();
		if(screen instanceof AbstractScreen) {
			if( ((AbstractScreen)screen).getController().getStage()!=null) {
			 	OrthographicCamera camera=	(OrthographicCamera) ((AbstractScreen)screen).getController().getStage().getCamera();
		     	camera.zoom=1;
		 		camera.setToOrtho(false);
			}	      

		}
	}
	
}


