/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.cam.graphunit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import org.frs.debitage.cam.dxf.model.DXF_STATIC_VALUE;
import org.frs.debitage.cam.dxf.model.Rotationangle;
import org.frs.debitage.cam.graphunit.PGraph;
import org.frs.debitage.cam.graphunit.PLineDXFEntity;
import org.frs.debitage.cam.graphunit.PointDXF;
import org.frs.debitage.cam.graphunit.PolyLineDXFEntity;

public class PFill2DShape
extends PGraph
implements Serializable {
    private static final long serialVersionUID = 352L;
    String textcenterd;
    private final PointDXF Startpoint;
    private final float Width;
    private final float Height;
    private final Color color;
    private PointDXF temppoint;
    private int textsize = 15;
    private Font f;

    public PFill2DShape(PointDXF ipoint, float iWidth, float iHeight, Color icolor) {
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.color = icolor;
        this.textcenterd = " ";
    }

    public PFill2DShape(PointDXF ipoint, float iWidth, float iHeight, Color icolor, String text, double sizescalefactor) {
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.color = icolor;
        this.textcenterd = text;
        this.textsize = (int)(sizescalefactor / (double)this.textsize) + 1;
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        g2d.fillRect((int)this.Startpoint.x, (int)this.Startpoint.y, (int)this.Width, (int)this.Height);
        this.drawCenteredString(this.textcenterd, (int)this.Width, (int)this.Height, g2d);
    }

    public void drawCenteredString(String s, float w, float h, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.temppoint = new PointDXF();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        g2d.setColor(Color.black);
        this.f = new Font("SansSerif", 0, this.textsize);
        g2d.setFont(this.f);
        FontMetrics fm = g2d.getFontMetrics();
        while (w - (float)fm.stringWidth(s) < 0.0f) {
            --this.textsize;
            this.f = new Font("SansSerif", 0, this.textsize);
            g2d.setFont(this.f);
            fm = g2d.getFontMetrics();
        }
        --this.textsize;
        this.f = new Font("SansSerif", 0, this.textsize);
        g2d.setFont(this.f);
        fm = g2d.getFontMetrics();
        float x = (w - (float)fm.stringWidth(s)) / 2.0f + this.temppoint.x;
        float y = (float)fm.getAscent() + (h - (float)(fm.getAscent() + fm.getDescent())) / 2.0f + this.temppoint.y;
        g2d.drawString(s, x, y);
    }

    @Override
    public String getDXFLineEntetity() {
        String s = "";
        if (!this.isDrawDXFLine()) {
            return s;
        }
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF origin = new PointDXF(this.Startpoint.getLocation());
        PointDXF p1 = origin.getLocation();
        PointDXF p2 = p1.getLocation();
        p2.x += this.Width;
        PointDXF p3 = p2.getLocation();
        p3.y += this.Height;
        PointDXF p4 = p1.getLocation();
        p4.y += this.Height;
        if (DXF_STATIC_VALUE.INVERT_CORDENATE) {
            this.InvertCodanate(p1);
            this.InvertCodanate(p2);
            this.InvertCodanate(p3);
            this.InvertCodanate(p4);
        }
        if (!DXF_STATIC_VALUE.USE_POLYLINE) {
            line1 = new PLineDXFEntity(p1, p2);
            line2 = new PLineDXFEntity(p2, p3);
            line3 = new PLineDXFEntity(p1, p4);
            line4 = new PLineDXFEntity(p4, p3);
            s = String.valueOf(s) + line1.getDXFLineEntetity();
            s = String.valueOf(s) + line2.getDXFLineEntetity();
            s = String.valueOf(s) + line3.getDXFLineEntetity();
            s = String.valueOf(s) + line4.getDXFLineEntetity();
        } else {
            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
            poly.addVertices(p1);
            poly.addVertices(p2);
            poly.addVertices(p3);
            poly.addVertices(p4);
            poly.addVertices(p1);
            s = String.valueOf(s) + poly.getDXFEntity(Rotationangle.angleRotation0);
        }
        return s;
    }
}

