package org.frs.svg;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxNativesLoader;



public class Line{
	
	static {
		GdxNativesLoader.load();
	}

	private Vector3 point;
	private Vector3 direction;
	private Vector3 color = new Vector3();
	
	public Line(Vector3 point, Vector3 direction) {
		super();
		this.point = point;
		this.direction = direction;
	}
	
	public Line cpy() {
		return new  Line(point.cpy(), direction.cpy());
	}
	
	public Vector3 prj(Vector3 point) {
		Vector3 op = point.cpy().sub(this.point);
		float norm = op.dot(this.direction)/this.direction.len2();
		Vector3 p =  this.point.cpy().add(this.direction.cpy().scl(norm));
		return p;
	}
	
	public float dst(Vector3 point) {
		Vector3 OM = this.point.cpy().sub(point);
		float OP = Math.abs(OM.dot(getDirection())/getDirection().len());
		return (float) Math.sqrt(OM.len2() - OP * OP);
	}
	
	
	public float dst(Line other, Vector3... points) {
		Vector3 S = other.getPoint().cpy().sub(getPoint());
		Vector3 V1 = getDirection().cpy();
		Vector3 V2 = other.getDirection().cpy();
		float[] values = new float[] {
			V1.len2(), -V1.dot(V2), 0,
			-V1.dot(V2), V2.len2(), 0,
			0, 			0			,1
		};
		Matrix3 M = new Matrix3(values);
		float det = Math.abs(V1.len2() * V2.len2() - V1.dot(V2) * V1.dot(V2));
		if(det < 0.0001f)
			return dst(other.getPoint());
		Vector3 result = null;
		try {
			result = new Vector3(V1.dot(S), -V2.dot(S),1).mul(M.inv());
		}catch (Exception e) {
			e.printStackTrace();
		}
		float dst = Float.POSITIVE_INFINITY;
		Vector3 p0 = new Vector3();
		Vector3 p1 = new Vector3();
		if(points != null && points.length > 1) {
			p0 = points[0];
			p1 =  points[1];
		}
		if(result != null) {
			p0.set(getPoint().cpy().add(V1.cpy().scl(result.x)));
			p1.set(other.getPoint().cpy().add(V2.cpy().scl(result.y)));
			dst = p0.dst(p1);
		}
		return dst;
	}
	
	public Object intersect(Line other) {
		Vector3 p0 = new Vector3(), p1 = new Vector3();
		if(dst(other, p0, p1) < 0.1f)
			return p0;
		return null;
	}
	
	public boolean contains(Vector3 point) {
		Vector3 v = point.cpy().sub(this.point);	
		return Math.abs(v.dot(getDirection()) - v.len() * getDirection().len()) < 0.001f; 
	}
	
	public Object intersect(Plane plane) {
		Vector3 N = plane.getNormal();
		if(Math.abs(N.dot(getDirection())) <0.001f) {
			if(plane.contains(point))
				return this;
			return null;
		}
		float D = - plane.getPoint().dot(N);
		float t = -(N.dot(point) + D)/N.dot(getDirection());
		return point.cpy().add(getDirection().scl(t));
	}
	
	public boolean isAligned(Line other) {
		return other.contains(point) && getDirection().isOnLine(other.getDirection()); 
	}
	
	public Vector3 getDirection() {
		return direction.cpy();
	}

	public boolean equals(Line other) {
		if(!getDirection().isCollinear(other.getDirection()) )
			return false;
		return other.dst(this.point) < 0.001f;
	}

	public Line transform(Matrix4 transform) {
		this.point.mul(transform);
		Matrix4 rotMat = transform.cpy().setTranslation(0, 0, 0);
		this.direction.mul(rotMat);
		return this;
	}

	
	public Vector3 getPoint() {
		return point;
	}

	public void setPoint(Vector3 point) {
		this.point = point;
	}

	public void setDirection(Vector3 direction) {
		this.direction = direction;
	}

	public Vector3 getColor() {
		return color;
	}

	public void setColor(Vector3 color) {
		this.color = color;
	}
	

	@Override
	public String toString() {
		return "Line [point=" + point + ", direction=" + direction + "]";
	}


	public static void main(String...strings) {
		Plane plane = new Plane(new Vector3(1,0,0), new Vector3(1,1,1));
		Line l0 = new Line(new Vector3(0,0,0), new Vector3(10,10,0));
		System.out.println(l0.dst(new Vector3(2,2,0)));
		//System.out.println(l0.intersect(plane));
	}
	
}
