package org.frs.html;

import java.util.ArrayList;
import java.util.Iterator;

public class CrudeHtmlElementIterator implements Iterator<CrudeHtmlElement> {
	
	private CrudeHtmlElement root;
	
	private ArrayList<CrudeHtmlElement> elements = new ArrayList<CrudeHtmlElement>();
	
	int currentIndex = -1;

	public CrudeHtmlElementIterator(CrudeHtmlElement root) {
		super();
		this.root = root;
		traverse(root);
	}

	
	private void traverse(CrudeHtmlElement root) {
		elements.addAll(root.getChildren());
		for(CrudeHtmlElement child: root.getChildren()) {
			traverse(child);
		}
	}

	@Override
	public boolean hasNext() {
		
		return elements.size() > 0 && currentIndex < elements.size() - 1;
	}

	@Override
	public CrudeHtmlElement next() {
		return elements.get(++currentIndex);
	}

}
