package tech.frsdev.j3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;

import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Font3D;
import org.jogamp.java3d.FontExtrusion;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import tech.frsdev.solids.Solide3D;

public abstract class DimDraw extends TransformGroup{
    protected final  static  GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    protected final  static  String[] fontNames = ge.getAvailableFontFamilyNames();
    protected final  static Font FONT = new Font(fontNames[0], Font.PLAIN, 1);
    protected final  static FontExtrusion  FONT_EXUSRION = new FontExtrusion();
    protected final  static Appearance appearancetext = new Appearance();
    protected final  static ColoringAttributes coloringAttributestext = new ColoringAttributes();
    protected final  static Font3D font3d = new Font3D(FONT, FONT_EXUSRION);
    static {
    	Color.RED.toString();
    	coloringAttributestext.setColor(new Color3f(1,0,0));
    	appearancetext.setColoringAttributes(coloringAttributestext);
    	
    }

		
    protected Solide3D solid;
    protected double refSize;

    protected Transform3D transform = new Transform3D();
    protected Vector3f vector= new Vector3f(0, 0, 0);
    protected BranchGroup holdingbox = new BranchGroup();
    protected float dimxinit,dimyinit,dimzinit;
    

	public DimDraw(Solide3D solid, double refsize) {
		super();
		this.solid = solid;
		this.refSize = refsize;

	}
	
	/**
	 * Must be called in the superclass not in this constrcuor
	 */
	protected void init() {
		// TODO Auto-generated method stub
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.setCapability(TransformGroup.ALLOW_PARENT_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);

		 DesignObject3D designsolid = (DesignObject3D) solid;
		 float x = (float) (designsolid.getXPosABS() *2   + solid.getXSize())/(float)refSize;
		 float y = (float) (designsolid.getYPosABS() *2   + solid.getYSize())/(float)refSize;
		 float z = (float) (designsolid.getZPosABS() *2   + solid.getZSize())/(float)refSize;
		 vector.set(x,y, z);
		 transform.setTranslation(vector);
		
		float xp0 =  (float) (solid.getXSize()/((float)refSize));
		float yp0 =  (float) (solid.getYSize()/((float)refSize));
		float zp0 =  (float) (solid.getZSize()/((float)refSize));
		
		dimxinit =xp0;
		dimyinit =yp0;
		dimzinit =zp0;
		
		regenratecotes(xp0, yp0, zp0);
		
		this.addChild(holdingbox);
		this.setTransform(transform);
		//capoabilities
	}
	
	
	
	protected void redraw()
	{
		if(solid instanceof Space3D )
		{
		     DesignObject3D designsolid = (DesignObject3D) solid;
			 float x = (float) (designsolid.getXPosABS() *2   + solid.getXSize())/(float)refSize;
			 float y = (float) (designsolid.getYPosABS() *2   + solid.getYSize())/(float)refSize;
			 float z = (float) (designsolid.getZPosABS() *2   + solid.getZSize())/(float)refSize;
			 vector.set(x,y, z);
			 transform.setTranslation(vector);
			
			float xp0 =  (float) (solid.getXSize()/((float)refSize));
			float yp0 =  (float) (solid.getYSize()/((float)refSize));
			float zp0 =  (float) (solid.getZSize()/((float)refSize));
			
			 Vector3d scale  =  new Vector3d();
			 transform.getScale(scale);
			 transform.setScale(new Vector3d(xp0/dimxinit, yp0/dimyinit, zp0/dimzinit));
			 transform.setTranslation(vector);
			 this.setTransform(transform);
			 redrawcotes(xp0, yp0, zp0);		
		}

	}
	
	protected abstract  void regenratecotes(float xp0,float yp0,float zp0);
	protected abstract void redrawcotes(float xp0,float yp0,float zp0);
}
