package gdxapp.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

import dressing.config.WorkspaceConfiguration;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;

public class BasicShader implements Shader {
	
	ShaderProgram program;
	private Camera camera;
	private RenderContext context;

	@Override
	public void init() {
		String vertx = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + "/basic/vertx.glsl").readString();
        String frag = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + "/basic/frag.glsl").readString();
        program = new ShaderProgram(vertx,frag);
        if(!program.isCompiled())
            throw new GdxRuntimeException(program.getLog());
        program.pedantic = false;
	}

	@Override
	public int compareTo(Shader other) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public boolean canRender(Renderable instance) {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void begin(Camera camera, RenderContext context) {
        this.camera = camera;
        this.context = context;
        context.setCullFace(GL20.GL_BACK);
        context.setDepthTest(GL20.GL_LESS);
        program.begin();
        program.setUniformMatrix("vp", camera.combined);
        program.setUniformf("cameraPos",camera.position);
        program.setUniformf("lightPos",new Vector3(2,4,2));
	}

	@Override
	public void render(Renderable renderable) {
        program.setUniformMatrix("model", renderable.worldTransform);
        Matrix4 normal = new Matrix4().set(renderable.worldTransform).inv().tra();
        program.setUniformMatrix("normal",new Matrix3().set(normal));
        if(renderable.material.has(ColorAttribute.Diffuse)){
            Color diffuse = ((ColorAttribute)renderable.material.get(ColorAttribute.Diffuse)).color;
            Vector3 color = new Vector3(diffuse.r,diffuse.g,diffuse.b);
            program.setUniformf("material.diffuse",color);
        }if(renderable.material.has(ColorAttribute.Specular)){
            Color spec = ((ColorAttribute)renderable.material.get(ColorAttribute.Specular)).color;
            program.setUniformf("material.specular",new Vector3(spec.r,spec.g,spec.b));
        }
        if(renderable.material.has(FloatAttribute.Shininess)){
            Float shininess  = ((FloatAttribute)renderable.material.get(FloatAttribute.Shininess)).value;
            program.setUniformf("material.shininess",shininess);
        }
        program.setUniformf("material.opacity", 1.0f);
        if(renderable.material.has(BlendingAttribute.Type)){
        	BlendingAttribute attr = ((BlendingAttribute)renderable.material.get(BlendingAttribute.Type));
            Float opacity  = attr.opacity;
            context.setBlending(true, attr.sourceFunction, attr.destFunction);
            program.setUniformf("material.opacity",opacity);
        }
        renderable.meshPart.render(program);
	}

	@Override
	public void end() {
		program.end();
	}
	
	@Override
	public void dispose() {
		program.dispose();
	}

}
