package gdxapp.screens.room;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector3;

import dressing.controller.tools.ToolController;
import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.scenes.SceneEvent;

public class CameraController implements InputProcessor {

	
	private final OrthographicCamera camera;
	private Vector3 mousePosition;
	
	public CameraController(OrthographicCamera camera) {
		super();
		this.camera = camera;
	}

	@Override
	public boolean keyDown(int keycode) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDown(int screenX, int screenY, int pointer, int button) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchUp(int screenX, int screenY, int pointer, int button) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDragged(int screenX, int screenY, int pointer) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean mouseMoved(int screenX, int screenY) {
		mousePosition =  camera.unproject(new Vector3(screenX, screenY,0));
		if(Gdx.input.isKeyPressed(Input.Keys.D)){
			System.err.println("camera over: " + mousePosition);
		}
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		if(Gdx.input.isKeyPressed(Input.Keys.SHIFT_LEFT))
			return false;
		float newZoom = camera.zoom *= 1 + (.1f * Math.signum(amount));;
		newZoom = Math.min(Math.max(0.1f, newZoom), 1e2f);    //0.1mm to  1 meter for the small grid tile
		camera.zoom = newZoom;
		Vector3 translation = mousePosition.cpy().sub(camera.position);
		camera.position.add(translation.scl(0.1f, 0.1f, 0));
		camera.update();
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.STAGE_CAMERA_CHANGED.name(), camera));
		return true;
	}

}
