package gdxapp.screens.ObjectEditor;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WallSide;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;
import gdxapp.ui.ObjectMenuList;

public class ObjectSelector implements InputProcessor, EventHandler{
	
	private ArrayList<Object3D> objects;
	
	private Camera camera;
	
	private Object3D selection;
	
	private boolean afterDragged;
	
	public ObjectSelector(Camera camera, ArrayList<Object3D> list) {
		this.camera = camera;
		objects = list;
		subscribe(SceneEvent.TARGET_CAMERA_CHANGED.name());
	}
	
	
	public Object3D selectAt(Vector3 point) {
		selection = null;
		
		var visibileObjs =  objects.stream().filter((o) -> !o.getWorldObject().isHidden()).toList();
		ArrayList<Object3D> sortedList = new ArrayList<Object3D>(visibileObjs);
		sortedList.sort((o0, o1) -> {
			float df0 = Math.abs(o0.getRotatedBoundingBox().sdf(point));
			float df1 = Math.abs(o1.getRotatedBoundingBox().sdf(point));
			return Math.round(Math.signum(df0 - df1));
		});
		ArrayList<Object3D> candidates = new ArrayList<Object3D>();
		int index = 0;
		boolean stop = false;
		do {
			float closestDst =  sortedList.get(index++).getRotatedBoundingBox().sdf(point);
			if(closestDst < 0 || closestDst < 0.05f) {
				candidates.add(sortedList.get(index - 1));
			}else {
				stop = true;
			}
		}while(!stop && index < sortedList.size());
 		
		if(!candidates.isEmpty()) {
			candidates.sort((o0,o1) -> {
				Vector3 size0 = new Vector3();
				Vector3 size1 = new Vector3();
				o0.getRotatedBoundingBox().getDimensions(size0);
				o1.getRotatedBoundingBox().getDimensions(size1);
				return Math.round(size0.len2() - size1.len2());
			});
			
			selection = candidates.get(0);
		}		

		if(selection != null) {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_SELECTED.name(), selection));
			ObjectEditorController.setSelection(selection);
			selectKitchenElementIfApplicable(selection);
			if(Gdx.input.isKeyPressed( Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed( Input.Keys.CONTROL_RIGHT)) {
				GroupSelection.getInstance().toggleSelection(selection);	
			}else {
				GroupSelection.getInstance().clearSelection();
				GroupSelection.getInstance().toggleSelection(selection);
			}
		}
		
		return selection;
	}
	private void selectKitchenElementIfApplicable(Object3D selection) {
		if (selection.getWorldObject() instanceof KitchenElement
				&& ((KitchenElement) selection.getWorldObject()).getDesignObject() instanceof DesignObject3D) {
			Display.getDefault().asyncExec(() -> GdxPart
					.setSelectedElement((Space3D) ((KitchenElement) selection.getWorldObject()).getDesignObject()));
		}
	}
	@Override
	public boolean keyDown(int keycode) {
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		return false;
	}

	@Override
	public boolean touchDown(int screenX, int screenY, int pointer, int button) {
//		ObjectMenuList.getInstance(null).remove();
//		Vector3 worldPoint = ScreenUtilities.getRealWorldPoint(screenX, screenY, camera);
//		System.err.println("touch down at: " + worldPoint);
//		//slightly move inside the surface for better accuaracy
//		Vector3 v = worldPoint.cpy().sub(camera.position);
//		v.nor().scl(0.05f);
//		worldPoint.add(v);
//		selectAt(worldPoint);
//		if(button == Input.Buttons.RIGHT) {
//			if(selection != null) {
//				HashMap<String, Object> eventInfo = new HashMap<String, Object>();
//				eventInfo.put("location", new Vector3(screenX, Gdx.app.getGraphics().getHeight() - screenY ,0));
//				eventInfo.put("source", selection);
//				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_RIGHT_CLICK.name(), eventInfo));
//			}
//		}
		return false;// (selection != null);

	}

	@Override
	public boolean touchUp(int screenX, int screenY, int pointer, int button) {
		if(afterDragged) {
			afterDragged = false;
			return false;
		}
		ObjectMenuList.getInstance(null).remove();
		Vector3 worldPoint = ScreenUtilities.getRealWorldPoint(screenX, screenY, camera);
		selectAt(worldPoint);
		if(button == Input.Buttons.RIGHT) {
			if(selection != null) {
				HashMap<String, Object> eventInfo = new HashMap<String, Object>();
				eventInfo.put("location", new Vector3(screenX, Gdx.app.getGraphics().getHeight() - screenY ,0));
				eventInfo.put("source", selection);
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_RIGHT_CLICK.name(), eventInfo));
			}
		}
		return false;
	}

	@Override
	public boolean touchDragged(int screenX, int screenY, int pointer) {
		afterDragged = true;
		return false;
	}
	

	@Override
	public boolean mouseMoved(int screenX, int screenY) {
		float z = ScreenUtilities.getDepthFromBuffer(screenX, Gdx.graphics.getHeight() - screenY);
		Vector3 realWorldPoint = camera.unproject(new Vector3(screenX, screenY, z));
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.MSG.name(), realWorldPoint.toString()));
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		// TODO Auto-generated method stub
		return false;
	}


	public Camera getCamera() {
		return camera;
	}


	public void setCamera(Camera camera) {
		this.camera = camera;
	}


	@Override
	public void handle(Event event) {
		SceneEvent sceneEvent = SceneEvent.valueOf(event.getTopic());
		switch(sceneEvent) {
			case TARGET_CAMERA_CHANGED:
			cameraChanged(event);
		}
	}


	private void cameraChanged(Event event) {
		if(event.getData() instanceof Camera) {
			setCamera((Camera) event.getData());
		}
	}


	public ArrayList<Object3D> getObjects() {
		return objects;
	}

	public void setObjects(ArrayList<Object3D> objects) {
		this.objects = objects;
	}
	
}
