package dressing.ui.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import dressing.config.ModulesPreferences;

public class StaticUiObjects {
	private static String[] MaterialColumns;
	private static String[] ChantColumns;

	public static boolean showFacade=true;
	public static boolean showDos=true;
	public static final DecimalFormat decimalMoneyFormat = new DecimalFormat("#,##0.000");
	public static final DecimalFormat decimalMoneyTotalFormat = new DecimalFormat("#,##0.000' DT'");

	public static final DecimalFormat decimalPOURCENTFormat = new DecimalFormat("#0.00");

	public static final DecimalFormat decimalCotationFormat = new DecimalFormat("##0.0");
	public static final DecimalFormat decimalReportCotationFormat = new DecimalFormat("##0");
	public static final boolean SHOW_ACCESSOIRE=true;
	public static final boolean SHOW_QUICAILLERIE=true;
	
	public static String[] getMaterialColumns() {
		if (MaterialColumns != null && MaterialColumns.length > 2) {
			return MaterialColumns;
		}
		boolean isShowSalePrice = ModulesPreferences.getInstance().getBoolean("ui.showSalePrice", true);
		boolean isShowCost = ModulesPreferences.getInstance().getBoolean("ui.showCost", true);

		List<String> columns = new ArrayList<>();

		// Base columns before the price(s)
		columns.add("Texture");
		columns.add("Epaisseur");

		// Handle price columns according to preferences
		if (isShowCost) {
			columns.add("Prix (DT/m)");
		}
		if (isShowSalePrice) {
			columns.add("Prix de Vente (DT/m²)");
		}

		// Always keep Fabricant last
		columns.add("Fabricant");
		MaterialColumns = columns.toArray(new String[0]);
		return MaterialColumns;
	}

	public static String[] getChantColumns() {
		if (ChantColumns != null && ChantColumns.length > 2) {
			return ChantColumns;
		}
		boolean isShowSalePrice = ModulesPreferences.getInstance().getBoolean("ui.showSalePrice", true);
		boolean isShowCost = ModulesPreferences.getInstance().getBoolean("ui.showCost", true);

		List<String> columns = new ArrayList<>();

		// Base columns before the price(s)
		columns.add("Nom");
		columns.add("Epaisseur");

		// Handle price columns according to preferences
		if (isShowCost) {
			columns.add("Prix (DT/m)");
		}
		if (isShowSalePrice) {
			columns.add("Prix de Vente (DT/m²)");
		}
		ChantColumns = columns.toArray(new String[0]);

		return ChantColumns;
	}
}
