package dressing.model.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

import com.badlogic.gdx.math.Vector3;

import dressing.model.persistence.wrappers.MapWrapper;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;

public class PersistenceTester {
	
	
	
	public static void schemaGen() throws JAXBException, IOException {
		SchemaOutputResolver schemaResoolver = new SchemaOutputResolver() {
			
			@Override
			public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
				File file = new File(suggestedFileName);
				StreamResult result = new StreamResult(file);
				result.setSystemId(file.toURI().toURL().toString());
				return result;
			}
		};
		JAXBContext ctxt = JAXBContext.newInstance(MapWrapper.class, String.class, Vector3.class);
		ctxt.generateSchema(schemaResoolver);
		
	}
	
	public static void xmlAdapterTest() {
		Vector3 v = new Vector3();
		String str = new String();
		SceneTexture texture = new SceneTexture("niger/niger/ni.jpg");
		texture.setCategory(CATEGORY.FLOOR);
		
		XmlAdapter<String, SceneTexture> adapter = new XmlAdapter<String, SceneTexture>() {
			
			@Override
			public SceneTexture unmarshal(String v) throws Exception {
				String[] props = v.split(";");
				SceneTexture scenetexture = new SceneTexture();
				scenetexture.setCategory(CATEGORY.valueOf(props[1]));
				scenetexture.setPath(props[0]);
				return scenetexture;
			}
			
			@Override
			public String marshal(SceneTexture v) throws Exception {
				String str = v.getPath() + ";" + v.getCategory().name();
				return str;
			}
		};
		
		JAXB.marshal(texture, System.out);
		System.out.println(str);
	}
	
	public static void main(String...args) throws Exception {
		JAXBContext ctxt = new JAXBContext() {
			
			@Override
			public Unmarshaller createUnmarshaller() throws JAXBException {
				// TODO Auto-generated method stub
				return null;
			}
			
			@Override
			public Marshaller createMarshaller() throws JAXBException {
				// TODO Auto-generated method stub
				return null;
			}
		};
	}

}
