package dressing.mathutils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class Rectangle {
	
	//the rectangle corners starting from top left in counter clock wise
	Vector2[] corners;
	Vector2 center;
	float width;
	float height;
	float rotation;
	

	public Rectangle(Vector2 center, float width, float height, float rotation) {
		this.center = center;
		this.width = width;
		this.height = height;
		this.rotation = rotation;
		this.corners = new Vector2[4];
		this.corners[0] = new Vector2(this.center.x - 0.5f * this.width, this.center.y + .5f * this.height);
		this.corners[1] = new Vector2(this.center.x - 0.5f * this.width, this.center.y - .5f * this.height);
		this.corners[2] = new Vector2(this.center.x + 0.5f * this.width, this.center.y - .5f * this.height);
		this.corners[3] = new Vector2(this.center.x + 0.5f * this.width, this.center.y + .5f * this.height);
		for(int i = 0; i < corners.length; i++) {
			this.corners[i] = MathUtilities.rotate(this.center, this.corners[i], this.rotation);
		}

	}
	
	public Rectangle(Vector2[] vertices) {
		this.corners = vertices;
		this.center = new Vector2(this.corners[2].x + this.corners[0].x, this.corners[2].y + this.corners[0].y).scl(0.5f);
		this.rotation = MathUtilities.getSignedAngle(new Vector3(corners[0].cpy().sub(corners[3]),0),
				new Vector3(0,1,0), Vector3.Z);
		this.width = this.corners[0].cpy().sub(this.corners[3]).len();
		this.height = this.corners[0].cpy().sub(this.corners[1]).len();
	}
	
	public boolean contains(Vector2 point ) {
		Vector2 vector = point.cpy().sub(this.center);
		float lengthProjection = vector.cpy().dot(corners[0].cpy().sub(corners[3]));
		if(lengthProjection > this.width/2)
			return false;
		float heightProjection = vector.cpy().dot(corners[0].cpy().sub(corners[1]));
		if(heightProjection > this.height/2)
			return false;
		return true;
	}
	
	public boolean intersects(Rectangle other) {
		return false;
	}
	public static void main(String[] args) {
		Rectangle rectangle1 = new Rectangle(new Vector2(2,2), 4, 2, 90);
		for(int i= 0; i < 4; i++) {
			System.out.println(rectangle1.corners[i]);
		}
		
	}

}
