package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import dressing.config.persistence.ResourceManagers;
import param.Material;
import param.impl.ParamFactoryImpl;

public class importMaterialFromExcellHandler {

	@Inject ESelectionService selectionService;
	private static final String LINE_BREAK = "\n";
	private static final String CELL_BREAK = "\t";
	private static final int NAME=0;
	private static final int EPAISSEUR=1;
	private static final int COULOUR=2;
	@Inject
	IEclipseContext  eclipsecontext;
	
	@Execute
	public void execute(Shell shell,ParameterizedCommand cmd ){		

				//Le string builder est termioner on cree le data transfer								
				Clipboard clipboard = new Clipboard(Display.getCurrent());
	    	    TextTransfer textTransfer = TextTransfer.getInstance();
	    	    Transfer[] transfers = new Transfer[]{textTransfer};
	    	    String result=   (String) clipboard.getContents( textTransfer);
	            String[] lines = result.split(LINE_BREAK);
	            for (int i = 0; i < lines.length; i++) { //Scho 946
	                lines[i] = lines[i].replaceAll("\t\t", "\t \t");
	                lines[i] = lines[i].replaceAll("\t\n", "\t   \n");
	                String[] cells = lines[i].split(CELL_BREAK);
	                if(cells.length>=3) {
	                	Material mat= ParamFactoryImpl.eINSTANCE.createMaterial();
	   	                mat.setName(cells[NAME]);
	   	                mat.setEpaisseur(Double.valueOf(cells[EPAISSEUR]));
	   	                mat.setImage(cells[COULOUR]);
	   	                ResourceManagers.getIntance().getMaterialGroup().getMaterial().add(mat);
	                }
	             
	            }  
	    	    System.err.println(result);
	    	    clipboard.dispose();
	}

	@CanExecute
	public boolean check()
	{
		return true;
	}
	

}
