package dressing.config.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.ui.util.ImageLoaderCache;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class IconChangerComposite extends Composite {
	
	private String iconURL = "file:\\\\C:\\ProgramData\\supercad.2.1.0\\icons\\metre.PNG";
	private ImageLoader imageLoader = new ImageLoader();
	  private Button filenameButton;
	    private Button imageButton;

		private Label lblName;


	public IconChangerComposite(Composite parent, int style,String iconURL) {
		super(parent, style);
		this.iconURL = iconURL;
		setToolTipText("changer icone");
		setLayout(new GridLayout(3, false));
		
		lblName = new Label(this, SWT.NONE);
		lblName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		lblName.setText(iconURL.substring(9));
		
		 imageButton = new Button(this, SWT.BORDER | SWT.CENTER);
		imageButton.setText("");
		
		 filenameButton = new Button(this, SWT.NONE);
		filenameButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				openfiledialogue();

			}
		});
		
		filenameButton.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));

		filenameButton.setText("...");
		
		
		
		
		
		Image image =loadImage(parent.getDisplay(), iconURL);
		ImageData images=image.getImageData().scaledTo(32,32);
		imageButton.setImage(new Image(getDisplay(), images));
		image.dispose();
		
	
	}
	 public static Image loadImage(Display display, String imagePath) {
	        Image image = null;
	        try {
	            image = new Image(display, imagePath);
	        } catch (SWTException e) {
	            e.printStackTrace();
	        }
	        return image;
	    }
		private void openfiledialogue() {
			 FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN);
		        fileDialog.setText("Select Icon Image");
		        String selectedFilePath = fileDialog.open();

		        if (selectedFilePath != null) {
		        	String  iconURLnewIcon = selectedFilePath;
		           // lblName.setText(iconURL.substring(iconURL.lastIndexOf("\\") + 1));
		            Image image =loadImage(Display.getCurrent(), iconURLnewIcon);
		            Image newimage=ImageLoaderCache.getInstance().resizeImage(image, 32, 32);
//		    		ImageData images=image.getImageData().scaledTo(32,32);
		    		imageButton.setImage( newimage);
		    		//imageLoader.data[1]=images;
		    		//imageLoader.save(iconURL, SWT.IMAGE_PNG);
		    		
		    		ImageLoaderCache.getInstance().saveImageToFile(newimage, iconURL);
		        }
			
		}
	
	 
	}

