package gdxapp.screens.modelcreator;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Align;

import dressing.events.Event;
import dressing.ui.ChangeCommandController;
import gdxapp.Commun.ScreenController;
import gdxapp.object3d.DesignModelFactory;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.shaders.MonoColorShader;

public class ModelCreatorScreenController implements ScreenController {

	private WorldObject model;
	private MonoColorShader monoColorShader;
	private ModelBatch modelBatch;
	SpriteBatch spriteBatch;
	private BitmapFont font;
	private PerspectiveCamera camera;
	private CameraInputController cameraInputController;
	private ShapeRenderer shapeRenderer;
	private ModelInstance previewInstance;

	public ModelCreatorScreenController() {
		init();
	}

	public void init() {
		camera = new PerspectiveCamera(67, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
		camera.up.set(0, 1, 0);
		camera.position.set(0, 0, 5);
		camera.near = 0.1f;
		camera.far = 20;
		camera.lookAt(0, 0, 0);
		camera.update();
		cameraInputController = new CameraInputController(camera);
		monoColorShader = new MonoColorShader();
		monoColorShader.init();
		modelBatch = new ModelBatch(new DefaultShaderProvider() {
			@Override
			protected Shader createShader(Renderable renderable) {
				return monoColorShader;
			}
		});
		spriteBatch = new SpriteBatch();
		font = new BitmapFont();
	}

	@Override
	public void dropActor(Object actor, float x, float y) {
		if (actor instanceof WorldObject) {
			setModel((WorldObject) actor);
		}

	}



	private void update() {
		Model design = DesignModelFactory.getFactory().createModelFromVertices((KitchenElement) this.model);
		this.previewInstance = new ModelInstance(design);

	}

	public WorldObject getModel() {
		return model;
	}

	public void setModel(WorldObject model) {
		this.model = model;
		Gdx.app.postRunnable(new Runnable() {

			@Override
			public void run() {
				update();

			}
		});
	}

	public ModelInstance getPreviewInstance() {
		return previewInstance;
	}

	public void setPreviewInstance(ModelInstance previewInstance) {
		this.previewInstance = previewInstance;
	}

	public void renderItemWithSpec(float padding) {
		if (this.previewInstance != null) {

			for (Material material : previewInstance.materials) {
				material.set(ColorAttribute.createDiffuse(Color.LIGHT_GRAY));
			}
			modelBatch.begin(camera);
			modelBatch.render(previewInstance);
			modelBatch.end();
			BoundingBox boundingBox = new BoundingBox();
			previewInstance.calculateBoundingBox(boundingBox);
			Vector3 dimension = new Vector3();
			boundingBox.getDimensions(dimension);
			Vector3 min = new Vector3(), max = new Vector3();
			boundingBox.getMin(min);
			boundingBox.getMax(max);

			Vector3 v0 = new Vector3(min.x, max.y, max.z);
			Vector3 v1 = new Vector3(v0).cpy().add(-padding, 0, 0);
			Vector3 v2 = new Vector3(min.x, max.y, min.z).cpy().add(-padding, 0, 0);
			Vector3 v3 = new Vector3(min.x, max.y, min.z);

			Vector3 v4 = new Vector3(v3).cpy().add(0, padding, 0);
			Vector3 v5 = new Vector3(max.x, max.y, min.z).cpy().add(0, padding, 0);
			Vector3 v6 = new Vector3(max.x, max.y, min.z);

			Vector3 v7 = new Vector3(v6).cpy().add(padding, 0, 0);
			Vector3 v8 = new Vector3(max.x, min.y, min.z).cpy().add(padding, 0, 0);
			Vector3 v9 = new Vector3(max.x, min.y, min.z);

			Gdx.gl20.glEnable(GL20.GL_VERTEX_PROGRAM_POINT_SIZE);

			if (shapeRenderer == null)
				shapeRenderer = new ShapeRenderer();
			// shapeRenderer.setProjectionMatrix(camera.combined);
			shapeRenderer.setProjectionMatrix(spriteBatch.getProjectionMatrix());
			shapeRenderer.setColor(Color.BLACK);
			shapeRenderer.begin(ShapeType.Filled);
			Vector3 v00 = camera.project(v0.cpy());
			Vector3 v01 = camera.project(v1.cpy());
			Vector3 v02 = camera.project(v2.cpy());
			Vector3 v03 = camera.project(v3.cpy());
			Vector3 v04 = camera.project(v4.cpy());
			Vector3 v05 = camera.project(v5.cpy());
			Vector3 v06 = camera.project(v6.cpy());
			Vector3 v07 = camera.project(v7.cpy());
			Vector3 v08 = camera.project(v8.cpy());
			Vector3 v09 = camera.project(v9.cpy());
			Vector3 vl = v01.cpy().add(v02).scl(0.5f);
			Vector2 vl2 = new Vector2(vl.x, vl.y);
			float rotl = new Vector2(v02.x, v02.y).sub(new Vector2(v01.x, v01.y)).angle();

			Vector3 vt = v04.cpy().add(v05).scl(0.5f);
			Vector2 vt2 = new Vector2(vt.x, vt.y);
			float rott = new Vector2(v05.x, v05.y).sub(new Vector2(v04.x, v04.y)).angle();

			Vector3 vr = v07.cpy().add(v08).scl(0.5f);
			Vector2 vr2 = new Vector2(vr.x, vr.y);
			float rotr = new Vector2(v07.x, v07.y).sub(new Vector2(v08.x, v08.y)).angle();
			shapeRenderer.rectLine(v00.x, v00.y, v01.x, v01.y, 4);
			shapeRenderer.rectLine(v01.x, v01.y, v02.x, v02.y, 4);
			shapeRenderer.rectLine(v02.x, v02.y, v03.x, v03.y, 4);
			shapeRenderer.rectLine(v03.x, v03.y, v04.x, v04.y, 4);
			shapeRenderer.rectLine(v04.x, v04.y, v05.x, v05.y, 4);
			shapeRenderer.rectLine(v05.x, v05.y, v06.x, v06.y, 4);
			shapeRenderer.rectLine(v06.x, v06.y, v07.x, v07.y, 4);
			shapeRenderer.rectLine(v07.x, v07.y, v08.x, v08.y, 4);
			shapeRenderer.rectLine(v08.x, v08.y, v09.x, v09.y, 4);
			shapeRenderer.end();

			GlyphLayout layout = new GlyphLayout(font, boundingBox.getDepth() + "");
			float textWidth = layout.width;
			float textHeight = font.getLineHeight();
			float scale = 25 / textWidth;
			if (scale == 0) {
				scale = 1;
			}
			font.setColor(Color.RED);
			font.getData().setScale(scale, 1);

			spriteBatch.getProjectionMatrix().translate(vl2.x, vl2.y, 0).rotate(Vector3.Z, rotl);
			spriteBatch.begin();
			font.draw(spriteBatch, "" + boundingBox.getDepth(), 0, 0, 0, Align.center, false);
			spriteBatch.end();
			spriteBatch.getProjectionMatrix().rotate(Vector3.Z, -rotl).translate(-vl2.x, -vl2.y, 0);

			spriteBatch.getProjectionMatrix().translate(vt2.x, vt2.y, 0).rotate(Vector3.Z, rott);
			spriteBatch.begin();
			font.draw(spriteBatch, "" + boundingBox.getWidth(), 0, 0, 0, Align.center, false);
			spriteBatch.end();
			spriteBatch.getProjectionMatrix().rotate(Vector3.Z, -rott).translate(-vt2.x, -vt2.y, 0);

			spriteBatch.getProjectionMatrix().translate(vr2.x, vr2.y, 0).rotate(Vector3.Z, rotr);
			spriteBatch.begin();
			font.draw(spriteBatch, "" + boundingBox.getHeight(), 0, 0, 0, Align.center, false);
			spriteBatch.end();
			spriteBatch.getProjectionMatrix().rotate(Vector3.Z, -rotr).translate(-vr2.x, -vr2.y, 0);
			font.getData().setScale(1, 1);
		}	

	}

	public ModelBatch getModelBatch() {
		return modelBatch;
	}

	public void setModelBatch(ModelBatch modelBatch) {
		this.modelBatch = modelBatch;
	}

	public PerspectiveCamera getCamera() {
		return camera;
	}

	public void setCamera(PerspectiveCamera camera) {
		this.camera = camera;
	}

	public CameraInputController getCameraInputController() {
		return cameraInputController;
	}

	public void setCameraInputController(CameraInputController cameraInputController) {
		this.cameraInputController = cameraInputController;
	}

	public ShapeRenderer getShapeRenderer() {
		return shapeRenderer;
	}

	public void setShapeRenderer(ShapeRenderer shapeRenderer) {
		this.shapeRenderer = shapeRenderer;
	}

	@Override
	public void handle(Event event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addActor(Object actor) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void removeActor(Object actor) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void rectifyPosition(Object object) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateWorldObject(Object object2d) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateObject(WorldObject object) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Object getObject(WorldObject worldObject) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void reloadActors() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void reloadActor(WorldObject... worldObject) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Stage getUIStage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public float[] getScales() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ChangeCommandController getChangeCommandController() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void clear() {
		// TODO Auto-generated method stub
		
	}

	



}
