package gdxapp.Commun;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.utils.Array;

import dressing.handlers.gdx.ToolControlHandler;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.model.ProjectManager;
import dressing.ui.util.MeasureLineWidow;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.Wall2D;
import gdxapp.shapes.LineSegment;
import geometry.Shape;


public class MeasuresTaker extends Actor {
	
	public enum ActionFocus {
		START, END,OFFSET
	}
	private ArrayList<Measure> measures = new ArrayList<Measure>();
	private Measure tmpMeasure; 
	private MeasurerEventProcessor inputProcessor;
	private ArrayList<Vector2> measurePoints;
	private static MeasuresTaker measurer;
	private Measure selectedMeasure;
	private ActionFocus focus=ActionFocus.START; 
	public static MeasuresTaker getInstance() {
	 		synchronized(MeasuresTaker.class) {
	 			if (measurer == null) {
	 				 measurer = new MeasuresTaker();
	 			}
	 			return measurer;
	 		}
	 }
	private MeasuresTaker() {
		super();
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		inputProcessor = new MeasurerEventProcessor(this);
		addListener(inputProcessor);
	}
	
	public void begin() {
		var pref = ProjectManager.getManager().getCurrentScene().getPreferences();
		tmpMeasure = new Measure();
		tmpMeasure.setScale(pref.getWORLD_WIDTH() /getStage().getWidth());
		if(((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
			SurfaceController controller=(SurfaceController) ((AbstractScreen) Scene.game.getScreen()).getController();
			tmpMeasure.setContext(controller.getSurface());
		}
		calculateMeasurePoints();

	}
	
	public void finsih() {	
		tmpMeasure = null;
		focus=ActionFocus.START;
		remove();
	}
	public void setkeyboardFocus() {
		if (getStage() != null){
				getStage().setKeyboardFocus(this);
		}
	}
	public void addNewMeasure() {
		Measure measure = tmpMeasure.copy();
		ProjectManager.instance.getCurrentScene().addMeasure(measure);
		tmpMeasure = null;
		focus=ActionFocus.START;
		ToolControlHandler.getInstance().threadSafeTriggerSelectObject();
	}
	public void removeMesure(Measure measure) {
		ProjectManager.instance.getCurrentScene().removeMeasure(measure);
	}
	public void clearMeasures() {
		ArrayList<Measure> measures=getMeasures();
		if(measures != null)
		{
			ArrayList<Measure> actorsToRemove = new ArrayList<Measure>();
			for(Measure actor:measures) {
				actorsToRemove.add(actor);
			}
			for(Measure actor: actorsToRemove) {
	    		removeMesure(actor);
	    	}
			measures.clear();
		}
	}
	
	public void calculateMeasurePoints() {
		if(measurePoints == null)
			measurePoints = new ArrayList<Vector2>();
		measurePoints.clear();
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(controller instanceof SurfaceController) {
			Array<Object2D>  actors=((SurfaceController) controller).getAttachedActors();
			for(Actor actor:actors) {
				if(actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					measurePoints.addAll(object2D.calculateAttachmentPosition());
				}
			}
			if(measurer.getTmpMeasure()!=null && measurer.getTmpMeasure().getLine()!=null && 
					measurer.getTmpMeasure().getLine().getStart()!=null) {
				measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, measurer.getStage().getHeight()));
				measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, 0));
				measurePoints.add(new Vector2(measurer.getStage().getWidth(), measurer.getTmpMeasure().getLine().getStart().y));
				measurePoints.add(new Vector2(0,  measurer.getTmpMeasure().getLine().getStart().y));

			}
		}else if(controller instanceof RoomController){
			Array<Actor> actors =new Array<Actor>();
			actors.addAll(getStage().getActors());
			for(Actor actor:actors ) {
				if(actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					measurePoints.addAll(object2D.calculateAttachmentPosition());
				}
				if(actor instanceof Wall2D) {
					Wall2D wall=(Wall2D) actor;
					ArrayList<Shape> edges=wall.getSides();
					for(Shape e:edges) {						
						if(e instanceof Edge ) {
							Edge edge=(Edge) e;
							measurePoints.add(edge.getV0());
							measurePoints.add(edge.getV1());
							measurePoints.add(edge.getMiddle());
						}
					}
				}
			}
		}
		
	}
	public Vector2 getNearestMeasurePoint(float x, float y) {
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(controller instanceof SurfaceController &&measurer.getTmpMeasure()!=null && measurer.getTmpMeasure().getLine()!=null && 
				measurer.getTmpMeasure().getLine().getStart()!=null) {
			measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, measurer.getStage().getHeight()));
			measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, 0));
			measurePoints.add(new Vector2(measurer.getStage().getWidth(), measurer.getTmpMeasure().getLine().getStart().y));
			measurePoints.add(new Vector2(0,  measurer.getTmpMeasure().getLine().getStart().y));

		}
		Vector2 nearest = null;
		if(measurePoints != null && measurePoints.size()>0) {
			Vector2 point = new Vector2(x,y);
			nearest = this.measurePoints.get(0);
			for(Vector2 measurepoint: this.measurePoints) {
				if(measurepoint.dst(point) < nearest.dst(point))
					nearest = measurepoint;
			}
		}
		return nearest;
	}
	public Edge getNearestEdge(float x, float y) {
		Edge edge=null;
		float pdistance=1000000.0f;
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		Array<Actor>  actors = new Array<Actor>();
		if(controller!=null) {
			if(controller instanceof SurfaceController) {
				if(((SurfaceController) controller).getAttachedActors()!=null && !((SurfaceController) controller).getAttachedActors().isEmpty())
				{
					actors.addAll(((SurfaceController) controller).getAttachedActors());
				}
			}else {
				if(getStage()!=null && getStage().getActors()!=null) {
					actors.addAll(getStage().getActors());
				}	
			}	
		}
		
		for(Actor actor: actors) {
			if(actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				for(Edge e:object2D.getEdges()) {
					float distance=MathUtilities.lineToPointDistance(x, y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
					if(distance<pdistance) {
						pdistance=distance;
						edge=e;
					}
				}
				
			}
			if(actor instanceof Wall2D) {
				Wall2D wall=(Wall2D) actor;
				ArrayList<Shape> edges=wall.getSides();
				for(Shape e:edges) {
					if(e instanceof Edge)
					{
						float distance=MathUtilities.lineToPointDistance(x, y, ((Edge) e).getV0().x, ((Edge) e).getV0().y, ((Edge) e).getV1().x, ((Edge) e).getV1().y);
						if(distance<pdistance) {
							pdistance=distance;
							edge=(Edge) e;
						}
					}
				}
			}
		}
		return edge;
	}
	public void selectMeasure(float x, float y) {
		ArrayList<Measure> measures=getMeasures();
		setSelectedMeasure(null);
		float distance=1000000.0f;
		Vector2 point=new Vector2(x, y);
		Measure closest=null;
		for(Measure measure: measures) {
			if(measure!=null ) {
				Vector2 start=measure.getLine().getStart();
				Vector2 end=measure.getLineSegment().getEnd();
				if(start!=null && end!=null) {
					float distancetoline=MathUtilities.lineToPointDistance(x, y, start.x, start.y, end.x, end.y);
					if(measure.getLineSegment().contains(point)) {
						if(distancetoline<distance ) {
							closest=measure;
							distance=distancetoline;
						}
						if(start.dst(point )<distance){
							closest=measure;
							distance=distancetoline;
							
						}
						if(end.dst(point )<distance){
							closest=measure;
							distance=distancetoline;
							
						}
					}
					
				}
				Vector2 startimage=measure.getLineSegment().getStartImage();
				Vector2 endimage=measure.getLineSegment().getEndImage();
				if(startimage!=null && endimage!=null) {
					float distancetoline=MathUtilities.lineToPointDistance(x, y, startimage.x, startimage.y, endimage.x, endimage.y);
					float scale=measure.getLineSegment().getScale()[0];
					boolean isImageContains= MathUtilities.iscontains(x, y, startimage.x, startimage.y, endimage.x, endimage.y)&&( distancetoline<(0.2f*scale)) ;
					if(isImageContains) {
						if(distancetoline<distance ) {
							closest=measure;
							distance=distancetoline;
							
						}
						if(startimage.dst(point )<distance){
							closest=measure;
							distance=distancetoline;
							
						}
						if(endimage.dst(point )<distance){
							closest=measure;
							distance=distancetoline;
							
						}
					}
					
				}
			}
		}
		setSelectedMeasure(closest);
	}
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		GroupSelection.getInstance().clearSelection();
		if(tmpMeasure != null)
		{
			Vector2 end=tmpMeasure.getLine().getEnd()!=null? tmpMeasure.getLine().getEnd():tmpMeasure.getLine().getTmpVertex();
			if(tmpMeasure.getLine()!=null && tmpMeasure.getLine().getStart()!=null&& end!=null &&end.cpy().sub(tmpMeasure.getLine().getStart()).len()>0) {
			Edge e=getNearestEdge(end.x, end.y);
				if(e!=null)
				{
					float distance=MathUtilities.lineToPointDistance(end.x, end.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
					if(distance>0.01f) {
						tmpMeasure.getLine().setTmpcolor(Color.RED);
					}
				}
				
				tmpMeasure.draw(batch, parentAlpha);
				tmpMeasure.getLine().setTmpcolor(Color.BLACK);
			}
			

		}
		if( getSelectedMeasure()!=null) {
			getSelectedMeasure().getLine().setTmpcolor(Color.GREEN);
		}

	}
	
	
	public ArrayList<Measure> getMeasures() {
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(measures==null) {
			measures = new ArrayList<Measure>();
		}
		measures.clear();
		for(Measure measure:ProjectManager.instance.getCurrentScene().getMeasures()) {
			if(measure!=null)
			{
				if(controller instanceof RoomController ) {
					if(measure.getContext()==null) {
						measures.add(measure);
					}
				}
				if(controller instanceof SurfaceController) {
					if(measure.getContext()!=null && measure.getContext().equals(((SurfaceController) controller).getSurface())) {
						measures.add(measure);
					}
				}
			}
		}
		return measures;
	}

	public void setMeasures(ArrayList<Measure> measures) {
		this.measures = measures;
	}

	
	public Measure getTmpMeasure() {
		return tmpMeasure;
	}

	public void setTmpMeasure(Measure tmpMeasure) {
		this.tmpMeasure = tmpMeasure;
	}
	
	

	public Measure getSelectedMeasure() {
		return selectedMeasure;
	}

	public void setSelectedMeasure(Measure selectedMeasure) {
		if(selectedMeasure==null && this.selectedMeasure!=null) {
			this.selectedMeasure.getLine().setTmpcolor(this.selectedMeasure.getLine().getColor());;
		}
		this.selectedMeasure = selectedMeasure;
	}

	public class MeasurerEventProcessor extends ActorInputListener{
		
		private final String TAG = MeasurerEventProcessor.class.getName();
		
		private MeasuresTaker measurer;
		private long lastClickDate = System.currentTimeMillis();

		public MeasurerEventProcessor(MeasuresTaker measurer) {
			super();
			this.measurer = measurer;
		}

		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
//			Gdx.app.debug(TAG, " touch down");
			if(button == Input.Buttons.RIGHT)
			{
				long newClickDate = System.currentTimeMillis();
				measurer.selectMeasure(x, y);
				if(newClickDate - lastClickDate < 300 && measurer.getSelectedMeasure()!=null) {
					Display.getDefault().asyncExec(new Runnable() {
					    public void run() {
					    	MeasureLineWidow window = MeasureLineWidow.getInstance();
							window.setMeasure(measurer.getSelectedMeasure(),true);
							window.show();
					    }
					});
				}
				lastClickDate = newClickDate;

				return true;
			}
			if(button ==  Input.Buttons.LEFT) {
				
				if(measurer.getTmpMeasure() == null )
				{
					measurer.begin();
				}
				Vector2 point = new Vector2(x,y);
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = new Vector2(nearestPoint);
					}else if(new Vector2(nearestPoint).cpy().dst(point)/measurer.getTmpMeasure().getLineSegment().getScale()[0]<0.05f) {
						point = new Vector2(nearestPoint);
					}
				}
				
				if(!measurer.focus.equals(ActionFocus.OFFSET)) {
					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
							Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
							point = new Vector2(point1.x,point1.y);						
						}
						else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=measurer.getTmpMeasure().getLineSegment().getScale()[0];
							if(distance<0.05f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				}
				if(measurer.focus.equals(ActionFocus.START)) {
					measurer.getTmpMeasure().getLine().setStart(point);
					measurer.getTmpMeasure().getLine().setTmpVertex(point);
					measurer.focus=	ActionFocus.END;

				}else if(measurer.focus.equals(ActionFocus.END)) {
					float len=point.cpy().sub(tmpMeasure.getLine().getStart()).scl(tmpMeasure.getLineSegment().getScale()[0]).len();
					if(len>0.01f) {
						measurer.getTmpMeasure().getLine().setEnd(point);
						measurer.focus=	ActionFocus.OFFSET;
					}
					

				}else {
					measurer.addNewMeasure();

				}
				return true;

			}
			return false;
		}

		@Override
		public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
			
			
		}

		@Override
		public void touchDragged(InputEvent event, float x, float y, int pointer) {
			if(measurer.getTmpMeasure() != null ) {
				Vector2 point = new Vector2(x,y);
				LineSegment lineSegment = measurer.getTmpMeasure().getLineSegment();
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = nearestPoint;
					}else if(nearestPoint.cpy().dst(point)/measurer.getTmpMeasure().getLineSegment().getScale()[0]<0.05f) {
						point = nearestPoint;
					}
				}
				if(!measurer.focus.equals(ActionFocus.OFFSET)) {

					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
							point =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
						}else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=measurer.getTmpMeasure().getLineSegment().getScale()[0];
							if(distance<0.05f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				}
				if(MeasuresTaker.this.focus.equals(ActionFocus.END))
				{
					lineSegment.getLine().setTmpVertex(new Vector2(point));
				}else if(MeasuresTaker.this.focus.equals(ActionFocus.OFFSET)) {
					Vector2 start=measurer.getTmpMeasure().getLine().getStart();
					Vector2 end=measurer.getTmpMeasure().getLine().getEnd();
					float offset=MathUtilities.lineToPointDistance(point.x, point.y, start.x, start.y, end.x,  end.y);
					Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, start.x, start.y, end.x, end.y);
					Vector2 vector1 = point1.cpy().sub(new Vector2(point.x,  point.y));
					Vector2 director = end.cpy().sub(start).nor();
					Vector2 normal = new Vector2(-director.y, director.x);
					float scalar1=vector1.cpy().dot(new Vector2(normal.x,normal.y));
					if(scalar1> 0) {
						offset *= -1;
					}
					measurer.getTmpMeasure().getLine().setOffset(offset);
				}
			}
		}

		@Override
		public boolean mouseMoved(InputEvent event, float x, float y) {			
			if(measurer.getTmpMeasure() != null ) {
				Vector2 point = new Vector2(x,y);
				LineSegment lineSegment = measurer.getTmpMeasure().getLineSegment();
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = nearestPoint;
					}else if(nearestPoint.cpy().dst(point)/measurer.getTmpMeasure().getLineSegment().getScale()[0]<0.05f) {
						point = nearestPoint;
					}
				}
				if(!measurer.focus.equals(ActionFocus.OFFSET)) {

					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
							point =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);							
						}else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=measurer.getTmpMeasure().getLineSegment().getScale()[0];
							if(distance<0.05f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				}
				if(MeasuresTaker.this.focus.equals(ActionFocus.END))
				{
					lineSegment.getLine().setTmpVertex(new Vector2(point));
				}else if(MeasuresTaker.this.focus.equals(ActionFocus.OFFSET)) {
					Vector2 start=measurer.getTmpMeasure().getLine().getStart();
					Vector2 end=measurer.getTmpMeasure().getLine().getEnd();
					float offset=MathUtilities.lineToPointDistance(point.x, point.y, start.x, start.y, end.x,  end.y);
					Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, start.x, start.y, end.x, end.y);
					Vector2 vector1 = point1.cpy().sub(new Vector2(point.x,  point.y));
					Vector2 director = end.cpy().sub(start).nor();
					Vector2 normal = new Vector2(-director.y, director.x);
					float scalar1=vector1.cpy().dot(new Vector2(normal.x,normal.y));
					if(scalar1> 0) {
						offset *= -1;
					}
					measurer.getTmpMeasure().getLine().setOffset(offset);
				}
			}
			return true;
		}

		@Override
		public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
			super.enter(event, x, y, pointer, fromActor);
		}

		@Override
		public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
			super.exit(event, x, y, pointer, toActor);
		}

		@Override
		public boolean scrolled(InputEvent event, float x, float y, int amount) {
			Gdx.app.debug(TAG, " scrolled");
			return super.scrolled(event, x, y, amount);
		}

		@Override
		public boolean keyDown(InputEvent event, int keycode) {
			Gdx.app.debug(TAG, " key down");
			return super.keyDown(event, keycode);
		}

		@Override
		public boolean keyUp(InputEvent event, int keycode) {
			Gdx.app.debug(TAG, " key up");
			if(keycode == Keys.ESCAPE)
			{
				tmpMeasure = null;
				focus=ActionFocus.START;
				ToolControlHandler.getInstance().threadSafeTriggerSelectObject();
				return true;
			}
			if(keycode == Keys.FORWARD_DEL && Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
			{
				measurer.clearMeasures();
				return true;
			}
			if(keycode == Keys.FORWARD_DEL) {
				Measure selected=getSelectedMeasure();
				if(selected!=null && selected.getLineSegment()!=null)
				{
					this.measurer.removeMesure(selected);
					setSelectedMeasure(null);
				}
				return true;

			}
			return false;
		}
		
	}

}
