package dressing.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

import com.badlogic.gdx.math.Vector3;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.events.EventDriver;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Space3DFree;
import dressing.model.types.PortType;
import dressing.model.types.PorteDirection;
import dressing.profiling.TimeProfiler;
import dressing.ui.ChangeCommand;
import dressing.ui.ChantListWindow;
import dressing.ui.CommandStack;
import dressing.ui.DesignChangeParamCommand;
import dressing.ui.ListPieceModelComoposite;
import dressing.ui.MaterialListWindow;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.components.TableComboViewerSearch;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import param.Chant;
import param.Material;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPublicParam;
import param.ModelRoot;
import param.TypeDef;
import param.TypeDefElement;

public class MesureWidow extends org.eclipse.jface.window.Window {

	private DataBindingContext m_bindingContext;

	public MesureWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM | SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}

	public Shell shell;
	public KitchenElement kitchenElement;
	MechanicDesign design;
	Spinner spny;
	Spinner spnlongeur;
	Spinner spnHauteur;
	Spinner spnProfondeur;
	Spinner spnLargeur;
	MechanicPublicParam longeur;
	MechanicPublicParam hauteur;
	MechanicPublicParam profondeur;
	MechanicPublicParam largeur;
	private DesignObject3D space;
	Label lblLargeur;
	Object2D object2d;
	List<Surface> beforeurfaces = null;
	TypeDefElement poigneeOrientation = null;
	TypeDefElement poigneePosition = null;
	TypeDefElement poigneeType = null;

	ComboViewer comboViewer_PorteType;
	ComboViewer comboViewer_PorteDirection;
	private ComboViewer comboViewer_FacadeType;
	//
	TypeDefElement porteType = null;
	TypeDefElement porteDirection = null;
	//
	Label lblSense;
	ComboViewer cVSensPorte;

	//
	ComboViewer cVPositionType;
	Label lblPositionType;
	//
	Spinner spnNbetg;
	//
	Spinner spnCoinsRetrait;
	//
	Button btnBosolGauche;
	Button btnBosolDroite;
	Button btnPersageGauche;
	Button btnPersageDroite;
	//
	private Spinner spnEtagerePos;
	private ComboViewer cVEmbaseType;
	private Button btnSocle;
	private Button btnJouet;
	private Button btnSPDroite;
	private Button btnSPGauche;
	//
	private Button btnPlaque;
	//
	private Button btnOmmitDos;
	//
	public String[] sensPorteValue = { "GAUCHE", "DROITE", "DOUBLE" };
	//
	public Map<MechanicDesignElment, DesignELementFacadeTypeComposite> elmentfacadeEditors = new HashMap<MechanicDesignElment, DesignELementFacadeTypeComposite>();

	//
	Listener controlListener = new Listener() {
		@Override
		public void handleEvent(Event event) {
			CommandStack command = updateObject();
			if (command != null) {
				if (((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController() != null) {
					((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
							.addCommand(command);
				}
			}
		}
	};
	Listener KeyUpListener = new Listener() {

		@Override
		public void handleEvent(Event event) {
			if (event.keyCode == SWT.CR || event.keyCode == SWT.KEYPAD_CR) {
				CommandStack command = updateObject();
				if (command != null) {
					if (((AbstractScreen) Scene.game.getScreen()).getController()
							.getChangeCommandController() != null) {
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
								.addCommand(command);
					}

				}
			}

		}
	};
	ISelectionChangedListener selectionListener = new ISelectionChangedListener() {
		public void selectionChanged(SelectionChangedEvent event) {
			if (validate(event.getSource())) {
				CommandStack command = updateObject();
				if (command != null) {
					if (((AbstractScreen) Scene.game.getScreen()).getController()
							.getChangeCommandController() != null) {
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
								.addCommand(command);
					}

				}
			} else {
				if (event.getSource().equals(comboViewer_PorteType) && porteType != null) {
					comboViewer_PorteType.setSelection(new StructuredSelection(porteType), true);
				}
				if (event.getSource().equals(comboViewer_PorteDirection) && porteDirection != null) {
					comboViewer_PorteDirection.setSelection(new StructuredSelection(porteDirection), true);
				}
			}

		}
	};
	SelectionListener buttonListener = new SelectionListener() {

		@Override
		public void widgetSelected(SelectionEvent e) {
			CommandStack command = updateObject();
			if (command != null) {
				if (((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController() != null) {
					((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
							.addCommand(command);
				}

			}
		}

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			// TODO Auto-generated method stub

		}
	};
	private static MesureWidow instance;
	private Button btnIlot;
	private TableComboViewerSearch tableComboVwr_facademat;
	private TableComboViewerSearch tableComboVwr_Eltmat;
	private TableComboViewerSearch tableComboVwr_Dosmat;
	private CTabFolder tabFolder;
	private CTabItem tbtmGnral;
	private CTabItem tbtmModel;
	private CTabItem tbtmFacades;
	private Composite composite_model_1_1_1;
	private ScrolledComposite model_scrolledComposite;
	private Composite composite_facade;
	private ScrolledComposite facade_scrolledComposite;
	private Composite pieceFacadeTypeComposite;
	private Spinner spnJouetReour;
	private Spinner spnVitreBandeL;
	private MaterialTypeInstanceComposite facadeMaterialType;
	private MaterialTypeInstanceComposite elementMaterialType;
	private MaterialTypeInstanceComposite dosMaterialType;
	private MaterialTypeInstanceComposite vitreMaterialType;
	private CTabItem tbtmModelElements;
	private ListPieceModelComoposite pieceModel_Composite;
	protected Group groupChant;
	protected TableComboViewerSearch tableComboVwr_ChantElement;
	protected TableComboViewerSearch tableComboVwr_ChantFacade;

	public static MesureWidow getInstance() {
		synchronized (MesureWidow.class) {
			if (instance == null) {
				instance = new MesureWidow(GdxPart.parentShell);
				instance.create();
				instance.constrainShellSize();
			}
			return instance;
		}
	}

	public WorldObject getObject() {
		return kitchenElement;
	}

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}

	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}

	public void setObject(KitchenElement actor) {
		this.kitchenElement = actor;
		if (actor.getType() != null && actor.getType().equals(ObjectType.DEFINED)) {
			this.space = actor.getDesignObject();
			this.design = (MechanicDesign) this.space.getMechanicDesignDefinition();
		}

	}

	public Object2D getObject2d() {
		return object2d;
	}

	public void setKitchenElemtn(KitchenElement element) {
			this.kitchenElement = element;
			this.space = this.kitchenElement.getDesignObject();
			this.design = (MechanicDesign) this.space.getMechanicDesignDefinition();
		if (this.kitchenElement != null) {
			this.getShell().setText("Mesure:\t  " + this.kitchenElement.getName());
		}
		
		createController();

	}

	/**
	 * Create contents of the window.
	 * 
	 * @return
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		TimeProfiler.getInstance().start("MESUREWINDOWCOMPOSITE");

		
		this.shell = parent.getShell();
		parent.getShell().setText("Mesure");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
	
		tabFolder = new CTabFolder(composite, SWT.BORDER);
		tabFolder.setHighlightEnabled(false);
		tabFolder.setSimple(false);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tabFolder.setSelectionBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));

		
		tbtmGnral = new CTabItem(tabFolder, SWT.NONE);
		tbtmGnral.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmGnral.setText("Général");

		tbtmModel = new CTabItem(tabFolder, SWT.NONE);
		tbtmModel.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmModel.setText("Modèle");
		
		createPieceModelTab();
		
		tbtmFacades = new CTabItem(tabFolder, SWT.NONE);
		tbtmFacades.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmFacades.setText("Façade");

		Composite composite_1 = new Composite(tabFolder, SWT.FILL);
		tbtmGnral.setControl(composite_1);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.heightHint = 558;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(2, true));

		Group grpMesures = new Group(composite_1, SWT.NONE);
		GridData gd_grpMesures = new GridData(SWT.FILL, SWT.TOP, false, false, 1, 3);
		gd_grpMesures.widthHint = 273;
		grpMesures.setLayoutData(gd_grpMesures);
		grpMesures.setText("Mesures");
		grpMesures.setLayout(new GridLayout(2, false));

		Label lblL = new Label(grpMesures, SWT.NONE);
		lblL.setText("Longeur");

		spnlongeur = new Spinner(grpMesures, SWT.BORDER);
		spnlongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnlongeur.setMaximum(1000000000);

		Label lblH = new Label(grpMesures, SWT.NONE);
		lblH.setText("Hauteur");

		spnHauteur = new Spinner(grpMesures, SWT.BORDER);
		spnHauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnHauteur.setMaximum(10000000);

		Label lblP = new Label(grpMesures, SWT.NONE);
		lblP.setText("Profondeur");

		spnProfondeur = new Spinner(grpMesures, SWT.BORDER);
		spnProfondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnProfondeur.setMaximum(10000000);

		lblLargeur = new Label(grpMesures, SWT.NONE);
		lblLargeur.setText("Largeur");

		spnLargeur = new Spinner(grpMesures, SWT.BORDER);
		spnLargeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnLargeur.setMaximum(100000000);

		Label lblCoinsRetrait = new Label(grpMesures, SWT.NONE);
		lblCoinsRetrait.setText("Coins Retrait");

		spnCoinsRetrait = new Spinner(grpMesures, SWT.BORDER);
		spnCoinsRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnCoinsRetrait.setMaximum(100000000);

		Label lblJouetRetour = new Label(grpMesures, SWT.NONE);
		lblJouetRetour.setText("Jouet Retour");

		spnJouetReour = new Spinner(grpMesures, SWT.BORDER);
		spnJouetReour.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnJouetReour.setMaximum(100000000);
		spnJouetReour.setMinimum(20);
		grpMesures.setTabList(
				new Control[] { spnlongeur, spnHauteur, spnProfondeur, spnLargeur, spnCoinsRetrait, spnJouetReour });

		Group grpPositions = new Group(composite_1, SWT.NONE);
		grpPositions.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		grpPositions.setText("Positions");
		grpPositions.setLayout(new GridLayout(2, false));

		Label lblY = new Label(grpPositions, SWT.NONE);
		lblY.setText("Y");

		spny = new Spinner(grpPositions, SWT.BORDER);
		spny.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spny.setMaximum(1000000000);

		lblPositionType = new Label(grpPositions, SWT.NONE);
		lblPositionType.setText("Type Position");

		cVPositionType = new ComboViewer(grpPositions, SWT.READ_ONLY);
		Combo combo_PositionType = cVPositionType.getCombo();
		combo_PositionType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		cVPositionType.setContentProvider(TypeDefContentProvider.getInstance());
		cVPositionType.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		Label lblEtagrePosition = new Label(grpPositions, SWT.NONE);
		lblEtagrePosition.setText("Etagère Position");

		spnEtagerePos = new Spinner(grpPositions, SWT.BORDER);
		spnEtagerePos.setMaximum(100000000);
		spnEtagerePos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		grpPositions.setTabList(new Control[] { spny, combo_PositionType });

		Group grpAutres = new Group(composite_1, SWT.NONE);
		grpAutres.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 4));
		grpAutres.setText("Autres");
		grpAutres.setLayout(new GridLayout(5, false));

		Label lblNombreEtagere = new Label(grpAutres, SWT.NONE);
		lblNombreEtagere.setText("Nombre Etagère");

		spnNbetg = new Spinner(grpAutres, SWT.BORDER);
		spnNbetg.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1));
		spnNbetg.setMaximum(1000000000);

		lblSense = new Label(grpAutres, SWT.NONE);
		lblSense.setText("Sens");

		cVSensPorte = new ComboViewer(grpAutres, SWT.READ_ONLY);
		Combo combo_SensPorte = cVSensPorte.getCombo();
		combo_SensPorte.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1));

		Label lblTypeEmbase = new Label(grpAutres, SWT.NONE);
		lblTypeEmbase.setText("Type Embase");

		cVEmbaseType = new ComboViewer(grpAutres, SWT.READ_ONLY);
		Combo comboEmbaseType = cVEmbaseType.getCombo();
		comboEmbaseType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1));
		cVEmbaseType.setContentProvider(TypeDefContentProvider.getInstance());
		cVEmbaseType.setLabelProvider(TypeDefElementLabelProvider.getInstance());

		btnPlaque = new Button(grpAutres, SWT.CHECK);
		btnPlaque.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnPlaque.setText("Plaque");

		btnOmmitDos = new Button(grpAutres, SWT.CHECK);
		btnOmmitDos.setText("Sans Dos");

		btnSocle = new Button(grpAutres, SWT.CHECK);
		btnSocle.setText("Socle");

		btnJouet = new Button(grpAutres, SWT.CHECK);
		btnJouet.setText("Jouet");

		btnIlot = new Button(grpAutres, SWT.CHECK);
		btnIlot.setText("Ilot");

		cVSensPorte.setLabelProvider(new ViewerLabelProvider());
		cVSensPorte.setContentProvider(new ArrayContentProvider());
		cVSensPorte.setInput(sensPorteValue);
		grpAutres.setTabList(new Control[] { combo_SensPorte, spnNbetg });
		
		Group grpUsinage = new Group(composite_1, SWT.NONE);
		grpUsinage.setLayout(new GridLayout(3, false));
		GridData gd_grpUsinage = new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1);
		gd_grpUsinage.widthHint = 271;
		grpUsinage.setLayoutData(gd_grpUsinage);
		grpUsinage.setText("Usinage");

		Label lblViseDeConnexion = new Label(grpUsinage, SWT.NONE);
		lblViseDeConnexion.setText("Vise de connexion");

		btnPersageGauche = new Button(grpUsinage, SWT.CHECK);
		btnPersageGauche.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnPersageGauche.setText("Gauche");

		btnPersageDroite = new Button(grpUsinage, SWT.CHECK);
		btnPersageDroite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnPersageDroite.setText("Droite");

		Label lblBosole = new Label(grpUsinage, SWT.NONE);
		lblBosole.setText("Boussole");

		btnBosolGauche = new Button(grpUsinage, SWT.CHECK);
		btnBosolGauche.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnBosolGauche.setText("Gauche");

		btnBosolDroite = new Button(grpUsinage, SWT.CHECK);
		btnBosolDroite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnBosolDroite.setText("Droite");

		Label lblSp = new Label(grpUsinage, SWT.NONE);
		lblSp.setText("Rupture Sans Poignée");

		btnSPGauche = new Button(grpUsinage, SWT.CHECK);
		btnSPGauche.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnSPGauche.setText("Gauche");

		btnSPDroite = new Button(grpUsinage, SWT.CHECK);
		btnSPDroite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnSPDroite.setText("Droite");

		grpUsinage.setTabList(new Control[] { btnPersageDroite, btnPersageGauche, btnBosolDroite, btnBosolGauche });
		new Label(composite_1, SWT.NONE);
		composite_1.setTabList(new Control[] { grpMesures, grpPositions, grpUsinage, grpAutres });
		
		//
		composite_facade = createFacadeTabComposite();
		//
		composite_model_1_1_1 = createModelTabComposite();

		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		new Label(composite_model_1_1_1, SWT.NONE);
		
		//
		tabFolder.setSelection(tbtmGnral);
		Composite composite_2 = createButtonBar(composite);
		composite.setTabList(new Control[] { tabFolder, composite_2 });

		setInputs();

		ControlAdapter adaptor = new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				Rectangle area2 = MesureWidow.this.getShell().getClientArea();
				composite.setBounds(area2);
			}

		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);
		TimeProfiler.getInstance().stop("MESUREWINDOWCOMPOSITE");
		return composite;

	}

	protected Composite createFacadeTabComposite() {
		facade_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		facade_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		facade_scrolledComposite.setExpandHorizontal(true);
		facade_scrolledComposite.setExpandVertical(true);

		composite_facade = new Composite(facade_scrolledComposite, SWT.NONE);
		tbtmFacades.setControl(facade_scrolledComposite);
		composite_facade.setLayout(new GridLayout(2, false));

		Label lblTypePorte = new Label(composite_facade, SWT.NONE);
		GridData gd_lblTypePorte = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_lblTypePorte.widthHint = 60;
		lblTypePorte.setLayoutData(gd_lblTypePorte);
		lblTypePorte.setText("Type");

		comboViewer_PorteType = new ComboViewer(composite_facade, SWT.READ_ONLY);
		Combo combo_PorteType = comboViewer_PorteType.getCombo();
		combo_PorteType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		comboViewer_PorteType.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_PorteType.setLabelProvider(TypeDefElementLabelProvider.getInstance());

		Label lblDirection = new Label(composite_facade, SWT.NONE);
		lblDirection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblDirection.setText("Direction");

		comboViewer_PorteDirection = new ComboViewer(composite_facade, SWT.READ_ONLY);
		Combo combo_PorteDirection = comboViewer_PorteDirection.getCombo();
		combo_PorteDirection.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_PorteDirection.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_PorteDirection.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		Label lblFacade_1 = new Label(composite_facade, SWT.NONE);
		lblFacade_1.setText("Type Façade");

		comboViewer_FacadeType = new ComboViewer(composite_facade, SWT.READ_ONLY);
		Combo combo_FacadeType = comboViewer_FacadeType.getCombo();
		combo_FacadeType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_FacadeType.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_FacadeType.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		//
		Label lblMaterialType = new Label(composite_facade, SWT.NONE);
		lblMaterialType.setText("Type Matériaux du vitre");

		vitreMaterialType = new MaterialTypeInstanceComposite(composite_facade, SWT.NONE);
		vitreMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		vitreMaterialType.setSize(vitreMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		//
		Label lblVitreBandeL = new Label(composite_facade, SWT.NONE);
		lblVitreBandeL.setText("Bande de Vitre");

		spnVitreBandeL = new Spinner(composite_facade, SWT.BORDER);
		spnVitreBandeL.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnVitreBandeL.setMaximum(100000000);
		spnVitreBandeL.setMinimum(20);

		//
		//

		pieceFacadeTypeComposite = new Composite(composite_facade, SWT.NONE);
		pieceFacadeTypeComposite.setLayout(new GridLayout(6, false));
		pieceFacadeTypeComposite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));

		//
		composite_facade.setTabList(new Control[] { combo_PorteType, combo_PorteDirection, combo_FacadeType,
				vitreMaterialType, pieceFacadeTypeComposite });
		facade_scrolledComposite.setContent(composite_facade);
		facade_scrolledComposite.setMinSize(composite_facade.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		return composite_facade;
	}

	protected void createPieceFacadeTypeComposite() {
		if (this.kitchenElement != null) {
			if (pieceFacadeTypeComposite != null) {
				pieceFacadeTypeComposite.dispose();
				composite_facade.redraw();
			}
			//
			pieceFacadeTypeComposite = new Composite(composite_facade, SWT.NONE);
			pieceFacadeTypeComposite.setLayout(new GridLayout(4, false));
			pieceFacadeTypeComposite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));

			//
			elmentfacadeEditors.clear();
			if (this.kitchenElement.getDesignObject() != null) {
				for (Piece2D piece : this.kitchenElement.getDesignObject().getListPieces()) {
					if (piece.getMechanicDesignElementDefinition() != null && piece.isFacade()) {
						MechanicDesignElment element = piece.getMechanicDesignElementDefinition();
						Label lblName = new Label(pieceFacadeTypeComposite, SWT.NONE);
//						lblName.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
						lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
						lblName.setText(element.getName());
						DesignELementFacadeTypeComposite elementComposite = new DesignELementFacadeTypeComposite(
								pieceFacadeTypeComposite, element, SWT.NONE);
						GridData gd_elementComposite = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
						elementComposite.setLayoutData(gd_elementComposite);
						elmentfacadeEditors.put(element, elementComposite);

					}
				}
			}
			pieceFacadeTypeComposite.pack();
			composite_facade.requestLayout();
			facade_scrolledComposite.setMinSize(composite_facade.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		}

	}

	protected Composite createModelTabComposite() {
		TimeProfiler.getInstance().start("createModelTabComposite");
		model_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		model_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		model_scrolledComposite.setExpandHorizontal(true);
		model_scrolledComposite.setExpandVertical(true);
		composite_model_1_1_1 = new Composite(model_scrolledComposite, SWT.NONE);
		tbtmModel.setControl(model_scrolledComposite);
		composite_model_1_1_1.setLayout(new GridLayout(9, false));

		Label lblFacade_2 = new Label(composite_model_1_1_1, SWT.NONE);
		lblFacade_2.setText("Façade");
		SingleImageItemLabelProvider matLabelProvider = SingleImageItemLabelProvider.getInstance();
		tableComboVwr_facademat = new TableComboViewerSearch(composite_model_1_1_1, SWT.NONE);
		TableCombo tableCombo = tableComboVwr_facademat.getTableCombo();
		tableCombo.setEditable(true);
		tableCombo.setUpdateSelectionOnEnter(true);
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo.defineColumns(StaticUiObjects.getMaterialColumns());
		tableComboVwr_facademat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_facademat.setLabelProvider(matLabelProvider);
		tableComboVwr_facademat.getTableCombo().setShowTableHeader(true);
		tableComboVwr_facademat.setInput(ResourceManagers.getIntance().getMaterials());
		tableComboVwr_facademat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_facademat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						SceneTexture texture = ModelProvider.getMaterialSceneTexture(mat);
						if (texture != null) {
							facadeMaterialType.getTableComboViewerTexture()
									.setSelection(new StructuredSelection(texture), true);
						}

					}
				}
			}
		});
		Button btnList = new Button(composite_model_1_1_1, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = 30;
		gd_btnList.heightHint = 30;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new MaterialListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_facademat.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboVwr_facademat.refresh();
				if (ret == Window.OK) {
					tableComboVwr_facademat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		facadeMaterialType = new MaterialTypeInstanceComposite(composite_model_1_1_1, SWT.NONE);
		facadeMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		facadeMaterialType.setSize(facadeMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		Label lblElement_1 = new Label(composite_model_1_1_1, SWT.NONE);
		lblElement_1.setText("Élément");

		tableComboVwr_Eltmat = new TableComboViewerSearch(composite_model_1_1_1, SWT.NONE);
		TableCombo tableCombo_1 = tableComboVwr_Eltmat.getTableCombo();
		tableCombo_1.setEditable(true);
		tableCombo_1.setUpdateSelectionOnEnter(false);
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo_1.defineColumns(StaticUiObjects.getMaterialColumns());
		tableComboVwr_Eltmat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_Eltmat.setLabelProvider(matLabelProvider);
		tableComboVwr_Eltmat.getTableCombo().setShowTableHeader(true);
		tableComboVwr_Eltmat.setInput(ResourceManagers.getIntance().getMaterials());
		tableComboVwr_Eltmat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_Eltmat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						SceneTexture texture = ModelProvider.getMaterialSceneTexture(mat);
						if (texture != null) {
							elementMaterialType.getTableComboViewerTexture()
									.setSelection(new StructuredSelection(texture), true);
						}

					}
				}
			}
		});
		Button btnList2 = new Button(composite_model_1_1_1, SWT.CENTER);
		GridData gd_btnList2 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList2.widthHint = 30;
		gd_btnList2.heightHint = 30;
		btnList2.setLayoutData(gd_btnList2);
		btnList2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new MaterialListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_Eltmat.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboVwr_Eltmat.refresh();
				if (ret == Window.OK) {
					tableComboVwr_Eltmat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList2.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		elementMaterialType = new MaterialTypeInstanceComposite(composite_model_1_1_1, SWT.NONE);
		elementMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		elementMaterialType.setSize(elementMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		Label lblDos = new Label(composite_model_1_1_1, SWT.NONE);
		lblDos.setText("Dos");

		tableComboVwr_Dosmat = new TableComboViewerSearch(composite_model_1_1_1, SWT.NONE);
		TableCombo tableCombo_1_1 = tableComboVwr_Dosmat.getTableCombo();
		tableCombo_1_1.setEditable(true);
		tableCombo_1_1.setUpdateSelectionOnEnter(false);
		tableCombo_1_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo_1_1.defineColumns(StaticUiObjects.getMaterialColumns());
		tableComboVwr_Dosmat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_Dosmat.setLabelProvider(matLabelProvider);
		tableComboVwr_Dosmat.getTableCombo().setShowTableHeader(true);
		tableComboVwr_Dosmat.setInput(ResourceManagers.getIntance().getMaterials());
		tableComboVwr_Dosmat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_Dosmat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						SceneTexture texture = ModelProvider.getMaterialSceneTexture(mat);
						if (texture != null) {
							dosMaterialType.getTableComboViewerTexture().setSelection(new StructuredSelection(texture),
									true);
						}

					}
				}
			}
		});
		Button btnList3 = new Button(composite_model_1_1_1, SWT.CENTER);
		GridData gd_btnList3 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList3.widthHint = 30;
		gd_btnList3.heightHint = 30;
		btnList3.setLayoutData(gd_btnList3);
		btnList3.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new MaterialListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_Dosmat.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboVwr_Dosmat.refresh();
				if (ret == Window.OK) {
					tableComboVwr_Dosmat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList3.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		//
		dosMaterialType = new MaterialTypeInstanceComposite(composite_model_1_1_1, SWT.NONE);
		dosMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		dosMaterialType.setSize(dosMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		groupChant = new Group(composite_model_1_1_1, SWT.NONE);
		groupChant.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 9, 1));
		groupChant.setText("Chants");
		groupChant.setLayout(new GridLayout(3, false));

		Label lblChantFacade = new Label(groupChant, SWT.NONE);
		lblChantFacade.setText("Façade");

		tableComboVwr_ChantFacade = new TableComboViewerSearch(groupChant, SWT.READ_ONLY);
		TableCombo tableComboChantFacade = tableComboVwr_ChantFacade.getTableCombo();
		tableComboChantFacade.setEditable(true);
		GridData chntFacadeData=new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		chntFacadeData.widthHint=200;
		tableComboChantFacade.setLayoutData(chntFacadeData);
		tableComboChantFacade.defineColumns(StaticUiObjects.getChantColumns());
		tableComboVwr_ChantFacade.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_ChantFacade.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_ChantFacade.getTableCombo().setShowTableHeader(true);
		tableComboVwr_ChantFacade.setInput(ResourceManagers.getIntance().getChants().getChant());
		//
		Button btnList4 = new Button(groupChant, SWT.CENTER);
		GridData gd_btnList4 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList4.widthHint = 30;
		gd_btnList4.heightHint = 30;
		btnList4.setLayoutData(gd_btnList4);
		btnList4.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new ChantListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_ChantFacade.setInput(ResourceManagers.getIntance().getChants().getChant());
				tableComboVwr_ChantFacade.refresh();
				if (ret == Window.OK) {
					tableComboVwr_ChantFacade.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList4.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		//
		Label lblChantElement = new Label(groupChant, SWT.NONE);
		lblChantElement.setText("Élément");

		tableComboVwr_ChantElement = new TableComboViewerSearch(groupChant, SWT.READ_ONLY);
		TableCombo tableComboChantElement = tableComboVwr_ChantElement.getTableCombo();
		tableComboChantElement.setEditable(true);
		GridData chntElementData=new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		chntElementData.widthHint=200;
		tableComboChantElement.setLayoutData(chntElementData);
		tableComboChantElement.defineColumns(StaticUiObjects.getChantColumns());
		tableComboVwr_ChantElement.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_ChantElement.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_ChantElement.getTableCombo().setShowTableHeader(true);
		tableComboVwr_ChantElement.setInput(ResourceManagers.getIntance().getChants().getChant());
		//
		Button btnList5 = new Button(groupChant, SWT.CENTER);
		GridData gd_btnList5 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList5.widthHint = 30;
		gd_btnList5.heightHint = 30;
		btnList5.setLayoutData(gd_btnList5);
		btnList5.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new ChantListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_ChantElement.setInput(ResourceManagers.getIntance().getChants().getChant());
				tableComboVwr_ChantElement.refresh();
				if (ret == Window.OK) {
					tableComboVwr_ChantElement.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList5.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		//
		
		composite_model_1_1_1
				.setTabList(new Control[] { tableCombo, tableCombo_1, tableCombo_1_1 });
		model_scrolledComposite.setContent(composite_model_1_1_1);
		model_scrolledComposite.setMinSize(composite_model_1_1_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		TimeProfiler.getInstance().stop("createModelTabComposite");
		return composite_model_1_1_1;
	}

	public Composite createPieceModelTab() {
		tbtmModelElements = new CTabItem(tabFolder, SWT.NONE);
		tbtmModelElements.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmModelElements.setText("Modèle des pièces");
		pieceModel_Composite = new ListPieceModelComoposite(tabFolder, SWT.NONE, design, space);
		pieceModel_Composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		pieceModel_Composite.setLayout(new GridLayout(1, false));
		tbtmModelElements.setControl(pieceModel_Composite);
		pieceModel_Composite.setSize(pieceModel_Composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		return pieceModel_Composite;
	}

	protected Composite createButtonBar(Composite parent) {
		Composite composite_2 = new Composite(parent, SWT.NONE);
		composite_2.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1));
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);

		Button btnRun = new Button(composite_2, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);
		btnRun.setText("Terminer");

		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		composite_2.setTabList(new Control[] { btnRun, btnFermer });

		btnFermer.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				MesureWidow.this.hide();
			}

		});
		btnRun.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				terminer();
			}

		});
		m_bindingContext = initDataBindings();

		return composite_2;
	}

	private void terminer() {

		// ProgressBarMonitor.addtask();

		CommandStack command = updateObject();

		if (object2d != null) {
			Display.getDefault().asyncExec(new Runnable() {

				@Override
				public void run() {
					float oldRotation = kitchenElement.getRotation();
					Vector3 oldPosition = kitchenElement.getRealWorldPosition();
					Vector4 oldDimention = kitchenElement.getObjectDimention();
					CommandStack stack;
					if (command == null) {
						stack = new CommandStack("change from window submit", "change from window",
								new ArrayList<ChangeCommand>());
					} else {
						stack = command;
					}
					if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof RoomController) {
//						RoomController.adaptObject2DtoWallsByditanceToEdge(object2d);
//						RoomController.adaptobjecttoBrothersBySurface(object2d);
					}
					if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
						((SurfaceController) ((AbstractScreen) Scene.game.getScreen()).getController())
								.surfaceAssist(object2d);

					}
					float newRotation = kitchenElement.getRotation();
					Vector3 newPosition = kitchenElement.getRealWorldPosition();
					Vector4 newDimention = kitchenElement.getObjectDimention();
					if (newRotation != oldRotation) {
						RotateCommand rotate = new RotateCommand("rotate" + MesureWidow.this.kitchenElement.getName(),
								"rotate", MesureWidow.this.kitchenElement, oldRotation, newRotation);
						stack.addCommand(rotate);
					}
					if (!newPosition.epsilonEquals(oldPosition, 0.0000001f)) {
						MoveCommand move = new MoveCommand("move" + MesureWidow.this.kitchenElement.getName(), "move",
								oldPosition, newPosition, MesureWidow.this.kitchenElement);
						stack.addCommand(move);
					}
					if (!newDimention.epsilonEquals(oldDimention, 0.0000001f)) {
						ScaleCommand scale = new ScaleCommand("move" + MesureWidow.this.kitchenElement.getName(),
								"move", oldDimention, newDimention, MesureWidow.this.kitchenElement);
						stack.addCommand(scale);
					}
					if (stack.getStack() != null && stack.getStack().size() > 0) {
						if (((AbstractScreen) Scene.game.getScreen()).getController()
								.getChangeCommandController() != null) {
							((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
									.addCommand(stack);
						}

					}
					System.gc();
					// ProgressBarMonitor.removetask();

				}
			});
		}

		hide();
	}

	public synchronized void show() {
		if (!shell.isDisposed()) {
			MesureWidow.this.shell.setVisible(true);
			MesureWidow.this.shell.setActive();

		}

	}

	public synchronized void hide() {
		if (!shell.isDisposed()) {
//			removeListeners();
			MesureWidow.this.shell.setVisible(false);
		}

	}

	public void removeListeners() {

		spnHauteur.removeListener(SWT.FocusOut, controlListener);
		spnlongeur.removeListener(SWT.FocusOut, controlListener);
		spnProfondeur.removeListener(SWT.FocusOut, controlListener);
		spny.removeListener(SWT.FocusOut, controlListener);
		spnHauteur.removeListener(SWT.KeyUp, KeyUpListener);
		spnlongeur.removeListener(SWT.KeyUp, KeyUpListener);
		spnProfondeur.removeListener(SWT.KeyUp, KeyUpListener);
		spny.removeListener(SWT.KeyUp, KeyUpListener);
		spnLargeur.removeListener(SWT.FocusOut, controlListener);
		spnLargeur.removeListener(SWT.KeyUp, KeyUpListener);
		spnNbetg.removeListener(SWT.FocusOut, controlListener);
		spnNbetg.removeListener(SWT.KeyUp, KeyUpListener);
		comboViewer_PorteType.removeSelectionChangedListener(selectionListener);
		comboViewer_PorteDirection.removeSelectionChangedListener(selectionListener);
		//
		comboViewer_FacadeType.removeSelectionChangedListener(selectionListener);
		//
		cVPositionType.removeSelectionChangedListener(selectionListener);

		cVSensPorte.removeSelectionChangedListener(selectionListener);
		//
		btnBosolDroite.removeSelectionListener(buttonListener);
		btnBosolGauche.removeSelectionListener(buttonListener);
		btnPersageDroite.removeSelectionListener(buttonListener);
		btnPersageGauche.removeSelectionListener(buttonListener);
		//
		btnPlaque.removeSelectionListener(buttonListener);
		//
		btnIlot.removeSelectionListener(buttonListener);
		//
		btnOmmitDos.removeSelectionListener(buttonListener);

		//
		spnCoinsRetrait.removeListener(SWT.KeyUp, KeyUpListener);
		spnCoinsRetrait.removeListener(SWT.FocusOut, controlListener);
		//

		//
		spnJouetReour.removeListener(SWT.KeyUp, KeyUpListener);
		spnJouetReour.removeListener(SWT.FocusOut, controlListener);
		//
		//
		spnVitreBandeL.removeListener(SWT.KeyUp, KeyUpListener);
		spnVitreBandeL.removeListener(SWT.FocusOut, controlListener);
		//
		spnEtagerePos.removeListener(SWT.KeyUp, KeyUpListener);
		spnEtagerePos.removeListener(SWT.FocusOut, controlListener);

		cVEmbaseType.removeSelectionChangedListener(selectionListener);
		btnSocle.removeSelectionListener(buttonListener);
		btnJouet.removeSelectionListener(buttonListener);
		btnSPDroite.removeSelectionListener(buttonListener);
		btnSPGauche.removeSelectionListener(buttonListener);

		//
		poigneePosition = null;
		poigneeOrientation = null;
		porteType = null;
		porteDirection = null;
		poigneeOrientation = null;
		poigneePosition = null;
		poigneeType = null;
	}

	public CommandStack updateObject() {
		if (MesureWidow.this.kitchenElement != null) {
			CommandStack stack = new CommandStack("change from window", "change from window",
					new ArrayList<ChangeCommand>());
			try {
				Vector4 oldDimention = kitchenElement.getObjectDimention();

				
				Vector4 newDimention = new Vector4();

				if (kitchenElement.getType().equals(ObjectType.DEFINED) && space != null) {
					boolean changed = false;
					boolean dimentionchanged = false;
					MechanicPublicParam paramL = this.design.getPublicParam("global.l");
					if (paramL != null && spnlongeur.isEnabled()) {
						String l = paramL.getDefaultvalue();
						int longeur = Float.valueOf(l).intValue();
						int spnl = spnlongeur.getSelection();
						if (longeur != spnl) {
							paramL.setDefaultvalue(String.valueOf(spnl));
							changed = true;
							dimentionchanged = true;
						}
						newDimention.x = spnl / 1000f;
					}
					MechanicPublicParam paramH = this.design.getPublicParam("global.h");
					if (paramH != null && spnHauteur.isEnabled()) {
						String h = paramH.getDefaultvalue();
						int hauteur = Float.valueOf(h).intValue();
						int spnh = spnHauteur.getSelection();
						if (hauteur != spnh) {
							paramH.setDefaultvalue(String.valueOf(spnh));
							changed = true;
							dimentionchanged = true;
						}
						newDimention.y = spnh / 1000f;
					}
					MechanicPublicParam paramP = this.design.getPublicParam("global.p");
					if (paramP != null && spnProfondeur.isEnabled()) {
						String p = paramP.getDefaultvalue();
						int pronfondeur = Float.valueOf(p).intValue();
						int spnp = spnProfondeur.getSelection();
						if (pronfondeur != spnp) {
							paramP.setDefaultvalue(String.valueOf(spnp));
							changed = true;
							dimentionchanged = true;
						}
						newDimention.z = spnp / 1000f;
					}
					try {
						MechanicPublicParam paramlargeur = this.design.getPublicParam("global.largeur");
						if (paramlargeur != null && spnLargeur.isEnabled()) {
							String L = paramlargeur.getDefaultvalue();
							int largeur = Float.valueOf(L).intValue();
							int spnL = spnLargeur.getSelection();
							if (largeur != spnL) {
								paramlargeur.setDefaultvalue(String.valueOf(spnL));
								changed = true;
								dimentionchanged = true;
							}
							newDimention.w = spnL / 1000f;
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
					//
					DesignChangeParamCommand paramChange = UpdateForBooleanParams("USE_PERSAGELEFT", btnPersageGauche,
							true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("USE_PERSAGERIGHT", btnPersageDroite, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("USE_BOSOLLEFT", btnBosolGauche, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("USE_BOSOLRIGHT", btnBosolDroite, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("Plaque_exist", btnPlaque, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					//
					paramChange = UpdateForBooleanParams("is_ilot", btnIlot, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("ommit_dos", btnOmmitDos, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("contains_socle", btnSocle, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("is_jouet", btnJouet, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("sansPoignee_CavityLeft", btnSPGauche, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//
					paramChange = UpdateForBooleanParams("sansPoignee_CavityRight", btnSPDroite, true);
					if (paramChange != null) {
						stack.addCommand(paramChange);
						changed = true;
					}
					//

					try {
						MechanicPublicParam paramCoinsRetrait = this.design.getPublicParam("coins.retrait");
						if (paramCoinsRetrait != null && spnCoinsRetrait.isEnabled()) {
							String r = paramCoinsRetrait.getDefaultvalue();
							int retrait = Float.valueOf(r).intValue();
							int spnretrait = spnCoinsRetrait.getSelection();
							if (retrait != spnretrait) {
								paramCoinsRetrait.setDefaultvalue(String.valueOf(spnretrait));
								changed = true;
								DesignChangeParamCommand poignerChange = new DesignChangeParamCommand(
										"Changer la position du poigner" + MesureWidow.this.kitchenElement.getName(),
										"move", MesureWidow.this.kitchenElement, "coins.retrait", true, r,
										String.valueOf(spnretrait));
								stack.addCommand(poignerChange);
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
					//
					//

					try {
						MechanicPublicParam paramJouetRetour = this.design.getPublicParam("facade.retourL");
						if (paramJouetRetour != null && spnJouetReour.isEnabled()) {
							String r = paramJouetRetour.getDefaultvalue();
							int retrait = Float.valueOf(r).intValue();
							int spnretrait = spnJouetReour.getSelection();
							if (retrait != spnretrait) {
								paramJouetRetour.setDefaultvalue(String.valueOf(spnretrait));
								changed = true;
								DesignChangeParamCommand paramJouetRetourChange = new DesignChangeParamCommand(
										"Changer la position du poigner" + MesureWidow.this.kitchenElement.getName(),
										"move", MesureWidow.this.kitchenElement, "facade.retourL", true, r,
										String.valueOf(spnretrait));
								stack.addCommand(paramJouetRetourChange);
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
					//

					try {
						MechanicPublicParam paramVitreBandeL = this.design.getPublicParam("vitre.bandeL");
						if (paramVitreBandeL != null && spnVitreBandeL.isEnabled()) {
							String r = paramVitreBandeL.getDefaultvalue();
							int retrait = Float.valueOf(r).intValue();
							int spnretrait = spnVitreBandeL.getSelection();
							if (retrait != spnretrait) {
								paramVitreBandeL.setDefaultvalue(String.valueOf(spnretrait));
								changed = true;
								DesignChangeParamCommand paramVitreBandeLChange = new DesignChangeParamCommand(
										"Changer la position du poigner" + MesureWidow.this.kitchenElement.getName(),
										"move", MesureWidow.this.kitchenElement, "vitre.bandeL", true, r,
										String.valueOf(spnretrait));
								stack.addCommand(paramVitreBandeLChange);
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}

					//
					MechanicPublicParam paramPorteType = this.space.getElementPorteType();
					if (paramPorteType != null && comboViewer_PorteType.getControl().isEnabled()) {
						TypeDefElement porteType = paramPorteType.getTypedefelement();
						IStructuredSelection selection = comboViewer_PorteType.getStructuredSelection();
						Object se = selection.getFirstElement();
						if (se != null && se instanceof TypeDefElement) {
							TypeDefElement sporteType = (TypeDefElement) se;
							if (sporteType != porteType) {
								this.porteType = sporteType;
								changed = true;
								paramPorteType.setTypedefelement(sporteType);
								DesignChangeParamCommand poignerChange = new DesignChangeParamCommand(
										"Changer le Type du porte" + MesureWidow.this.kitchenElement.getName(), "move",
										MesureWidow.this.kitchenElement, "PORT_TYPE", true, porteType, sporteType);
								stack.addCommand(poignerChange);
							}
						}
					}
					//
					MechanicPublicParam paramPorteDirection = this.space.getElementPorteDirection();
					if (paramPorteDirection != null && comboViewer_PorteDirection.getControl().isEnabled()) {
						TypeDefElement porteDirection = paramPorteDirection.getTypedefelement();
						IStructuredSelection selection = comboViewer_PorteDirection.getStructuredSelection();
						Object se = selection.getFirstElement();
						if (se != null && se instanceof TypeDefElement) {
							TypeDefElement sporteDirection = (TypeDefElement) se;
							if (sporteDirection != porteDirection) {
								this.porteDirection = sporteDirection;
								changed = true;
								paramPorteDirection.setTypedefelement(sporteDirection);
								//
								DesignChangeParamCommand poignerChange = new DesignChangeParamCommand(
										"Changer le direction du porte" + MesureWidow.this.kitchenElement.getName(),
										"move", MesureWidow.this.kitchenElement, "PORT_TYPE", true, porteDirection,
										sporteDirection);
								stack.addCommand(poignerChange);

								//
							}
						}
					}
					//
					MechanicPublicParam paramPositionType = this.space.getElementPositionType();
					if (paramPositionType != null && cVPositionType.getControl().isEnabled()) {
						TypeDefElement positionType = paramPositionType.getTypedefelement();
						IStructuredSelection selection = cVPositionType.getStructuredSelection();
						Object se = selection.getFirstElement();
						if (se != null && se instanceof TypeDefElement) {
							TypeDefElement spositionType = (TypeDefElement) se;
							if (spositionType != positionType) {
								changed = true;
								paramPositionType.setTypedefelement(spositionType);
								//
								DesignChangeParamCommand PositionTypeChange = new DesignChangeParamCommand(
										"Changer le Type du position" + MesureWidow.this.kitchenElement.getName(),
										"change position", MesureWidow.this.kitchenElement, "POSITION_TYPE", true,
										positionType, spositionType);
								stack.addCommand(PositionTypeChange);

								//
							}
						}
					}
					//
					try {
						MechanicPublicParam paramNbEtagere = this.space.getElementNombrEtagere();
						if (paramNbEtagere != null && spnNbetg.isEnabled()) {
							String nb = paramNbEtagere.getDefaultvalue();
							int nbEtg = Float.valueOf(nb).intValue();
							int spnNbEtg = spnNbetg.getSelection();
							if (spnNbEtg != nbEtg) {
								paramNbEtagere.setDefaultvalue(String.valueOf(spnNbEtg));
								changed = true;
								//
								DesignChangeParamCommand PositionTypeChange = new DesignChangeParamCommand(
										"Changer le nombre des etagere" + MesureWidow.this.kitchenElement.getName(),
										"change nb Etagere", MesureWidow.this.kitchenElement, "ETAGERE_COUNT", true,
										String.valueOf(nbEtg), String.valueOf(spnNbEtg));
								stack.addCommand(PositionTypeChange);

								//
							}

						}
					} catch (Exception e) {
						e.printStackTrace();
					}

					//
					//
					try {
						MechanicPublicParam paramEtagerePos = this.design.getPublicParam("separator.position");
						if (paramEtagerePos != null && spnEtagerePos.isEnabled()) {
							String spos = paramEtagerePos.getDefaultvalue();
							int posEtg = Float.valueOf(spos).intValue();
							int spnPosEtg = spnEtagerePos.getSelection();
							if (spnPosEtg != posEtg) {
								paramEtagerePos.setDefaultvalue(String.valueOf(spnPosEtg));
								changed = true;
								//
								DesignChangeParamCommand PositionTypeChange = new DesignChangeParamCommand(
										"Changer le position d'étagère" + MesureWidow.this.kitchenElement.getName(),
										"change position Etagère", MesureWidow.this.kitchenElement,
										"separator.position", true, String.valueOf(posEtg), String.valueOf(spnPosEtg));
								stack.addCommand(PositionTypeChange);

								//
							}

						}
					} catch (Exception e) {
						e.printStackTrace();
					}

					//
					try {
						MechanicPublicParam paramEmbaseType = this.design.getPublicParam("EMBASE_TYPE");
						if (paramEmbaseType != null && cVEmbaseType.getControl().isEnabled()) {
							TypeDefElement typeEmbase = paramEmbaseType.getTypedefelement();
							IStructuredSelection selection = cVEmbaseType.getStructuredSelection();
							Object se = selection.getFirstElement();
							if (se != null && se instanceof TypeDefElement) {
								TypeDefElement sEmbaseType = (TypeDefElement) se;
								if (sEmbaseType != typeEmbase) {
									changed = true;
									paramEmbaseType.setTypedefelement(sEmbaseType);
									DesignChangeParamCommand changerParamtype = new DesignChangeParamCommand(
											"Changer le type d'embase" + MesureWidow.this.kitchenElement.getName(),
											"embase type", MesureWidow.this.kitchenElement, "EMBASE_TYPE", true,
											typeEmbase, sEmbaseType);
									stack.addCommand(changerParamtype);
								}
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
					//
					try {
						MechanicPublicParam paramFacadeType = this.design.getPublicParam("FACADE_TYPE");
						if (paramFacadeType != null && comboViewer_FacadeType.getControl().isEnabled()) {
							TypeDefElement typeFacade = paramFacadeType.getTypedefelement();
							IStructuredSelection selection = comboViewer_FacadeType.getStructuredSelection();
							Object se = selection.getFirstElement();
							if (se != null && se instanceof TypeDefElement) {
								TypeDefElement sFacadeType = (TypeDefElement) se;
								if (sFacadeType != typeFacade) {
									changed = true;
									paramFacadeType.setTypedefelement(sFacadeType);
									DesignChangeParamCommand changerParamtype = new DesignChangeParamCommand(
											"Changer le type de facade" + MesureWidow.this.kitchenElement.getName(),
											"type de facade", MesureWidow.this.kitchenElement, "FACADE_TYPE", true,
											typeFacade, sFacadeType);
									stack.addCommand(changerParamtype);
								}
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
					//
					try {

						IStructuredSelection selection = tableComboVwr_Eltmat.getStructuredSelection();
						Object se = selection.getFirstElement();
						if (se != null && se instanceof Material) {
							if (se != this.design.getPrincipalmaterial()) {
								changed = true;
								this.design.setPrincipalmaterial((Material) se);
							}
						}
						IStructuredSelection selection2 = tableComboVwr_facademat.getStructuredSelection();
						Object se2 = selection2.getFirstElement();
						if (se2 != null && se2 instanceof Material) {
							if (se2 != this.design.getFacadeMaterial()) {
								changed = true;
								this.design.setFacadeMaterial((Material) se2);
							}
						}
						IStructuredSelection selectionDos = tableComboVwr_Dosmat.getStructuredSelection();
						Object dos = selectionDos.getFirstElement();
						if (dos != null && dos instanceof Material) {
							if (dos != this.design.getSecondmaterial()) {
								changed = true;
								this.design.setSecondmaterial((Material) dos);
							}
						}
						//
						if (this.vitreMaterialType.isDirty()) {
							MaterialTypeInstance material = vitreMaterialType.getMaterial();
							MaterialTypeInstance vitreMaterialType = design.getDefaultVitreMaterialType();
							vitreMaterialType.setIsColor(material.isIsColor());
							vitreMaterialType.setMaterial(material.getMaterial());
							vitreMaterialType.setTexture(this.vitreMaterialType.getSelectedTexture());
							if (this.vitreMaterialType.getColorComposite().isDirty()) {
								vitreMaterialType.setColor(this.vitreMaterialType.getColorComposite().getEmfColor());
							}
							changed = true;

						}
						if (this.facadeMaterialType.isDirty()) {
							MaterialTypeInstance material = facadeMaterialType.getMaterial();
							MaterialTypeInstance facadeMaterialType = design.getFacadeMaterialType();
							facadeMaterialType.setIsColor(material.isIsColor());
							facadeMaterialType.setMaterial(material.getMaterial());
							facadeMaterialType.setTexture(this.facadeMaterialType.getSelectedTexture());
							if (this.facadeMaterialType.getColorComposite().isDirty()) {
								facadeMaterialType.setColor(this.facadeMaterialType.getColorComposite().getEmfColor());
							}
							changed = true;

						}
						if (this.elementMaterialType.isDirty()) {
							MaterialTypeInstance material = elementMaterialType.getMaterial();
							MaterialTypeInstance elementMaterialType = design.getPrincipalMaterialType();
							elementMaterialType.setIsColor(material.isIsColor());
							elementMaterialType.setMaterial(material.getMaterial());
							elementMaterialType.setTexture(this.elementMaterialType.getSelectedTexture());
							if (this.elementMaterialType.getColorComposite().isDirty()) {
								elementMaterialType
										.setColor(this.elementMaterialType.getColorComposite().getEmfColor());
							}
							changed = true;

						}
						if (this.dosMaterialType.isDirty()) {
							MaterialTypeInstance material = dosMaterialType.getMaterial();
							MaterialTypeInstance dosMaterialType = design.getSecondMaterialType();
							dosMaterialType.setIsColor(material.isIsColor());
							dosMaterialType.setMaterial(material.getMaterial());
							dosMaterialType.setTexture(this.dosMaterialType.getSelectedTexture());
							if (this.dosMaterialType.getColorComposite().isDirty()) {
								dosMaterialType.setColor(this.dosMaterialType.getColorComposite().getEmfColor());
							}
							changed = true;
						}
						IStructuredSelection selectionchantFacade = tableComboVwr_ChantFacade.getStructuredSelection();
						Object chantFacade = selectionchantFacade.getFirstElement();
						if (chantFacade != null && chantFacade instanceof Chant) {
							if (chantFacade != this.design.getChantFacade()) {
								this.design.setChantFacade((Chant) chantFacade);
							}
						}
						//

						IStructuredSelection selectionchantElement = tableComboVwr_ChantElement
								.getStructuredSelection();
						Object chantElement = selectionchantElement.getFirstElement();
						if (chantElement != null && chantElement instanceof Chant) {
							if (chantElement != this.design.getChantElement()) {
								this.design.setChantElement((Chant) chantElement);
							}
						}
						//
						changed = pieceModel_Composite.updateValues() || changed;
						if (elmentfacadeEditors != null && !elmentfacadeEditors.isEmpty()) {
							for (MechanicDesignElment element : elmentfacadeEditors.keySet()) {
								DesignELementFacadeTypeComposite editor = elmentfacadeEditors.get(element);
								if (editor != null && !editor.isDisposed() && editor.isDirty()) {
									element.setFacadeType(editor.getElement().getFacadeType());
									element.setFacadeTypeFree(editor.getElement().isFacadeTypeFree());
									//
									if (editor.getElementMaterialType().isDirty()) {
										MaterialTypeInstance material = editor.getElementMaterialType().getMaterial();
										MaterialTypeInstance elementMaterialType = element.getVitreMaterialType();
										elementMaterialType.setIsColor(material.isIsColor());
										elementMaterialType.setMaterial(material.getMaterial());
										elementMaterialType
												.setTexture(editor.getElementMaterialType().getSelectedTexture());
										if (editor.getElementMaterialType().getColorComposite().isDirty()) {
											elementMaterialType.setColor(
													editor.getElementMaterialType().getColorComposite().getEmfColor());
										}
									}

									//
									element.setVitreMaterialTypeFree(editor.getElement().isVitreMaterialTypeFree());
									changed = true;
								}
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
					if (changed) {
						((Space3DFree) MesureWidow.this.space).update();

					}
					if (dimentionchanged) {
						ScaleCommand scale = new ScaleCommand("move" + MesureWidow.this.kitchenElement.getName(),
								"move", oldDimention, newDimention, MesureWidow.this.kitchenElement);
						stack.addCommand(scale);
					}
					//
					//
				}

				updateKitchenElement();

				if (stack.getStack() != null && stack.getStack().size() > 0) {
					return stack;
				}

			} catch (Exception ex) {
				MessageBox dialog = new MessageBox(MesureWidow.this.getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
				dialog.setText("Error");
				dialog.setMessage("un erreur est servenue lors de mise à jour du model à cause de :" + ex.getMessage());
				// open dialog and await user selection
				dialog.open();
				ex.printStackTrace();
			}

		}
		return null;
	}

	private void updateKitchenElement() {
		Vector4 dim = this.kitchenElement.getObjectDimention();
		float y = spny.getSelection() * 0.001f;
		float altitude = y + dim.y / 2.0f;
		kitchenElement.getRealWorldPosition().y = altitude;
		kitchenElement.setRequireRefrech(true);
		EventDriver.getDriver().deliverEvent(SceneEvent.OBJECT_CHANGED, kitchenElement);

	}

	public void createController() {
		if( tabFolder==null) {
			System.err.println("Mesure window composite is not ready");
			return;//composite not readu
		}
		if (kitchenElement != null && !shell.isDisposed()) {
//			removeListeners();
			tabFolder.setSelection(tbtmGnral);

			if (kitchenElement.getType().equals(ObjectType.DEFINED)) {
				CreateControlForDesign();
			} else {

				//
				pieceFacadeTypeComposite.dispose();
				elmentfacadeEditors.clear();

				//
				if (kitchenElement.getRealWorldDimension() != null) {
					Vector4 dim = kitchenElement.getRealWorldDimension();
					//
					spnlongeur.setSelection((int) (dim.x * 1000));
					spnHauteur.setSelection((int) (dim.y * 1000));
					spnProfondeur.setSelection((int) (dim.z * 1000));
					//
					spnlongeur.setEnabled(true);
					spnHauteur.setEnabled(true);
					spnProfondeur.setEnabled(true);

				}
				spnLargeur.setEnabled(false);
				cVPositionType.getControl().setEnabled(false);
				//
				spnNbetg.setEnabled(false);

				//
				comboViewer_PorteDirection.getControl().setEnabled(false);
				comboViewer_PorteType.getControl().setEnabled(false);
				btnBosolDroite.setEnabled(false);
				btnBosolGauche.setEnabled(false);
				btnPersageDroite.setEnabled(false);
				btnPersageGauche.setEnabled(false);
				//
				btnPlaque.setEnabled(false);
				//
				btnIlot.setEnabled(false);
				//
				btnOmmitDos.setEnabled(false);
				//
				spnCoinsRetrait.setEnabled(false);
				//
				spnJouetReour.setEnabled(false);
				//
				spnVitreBandeL.setEnabled(false);
				//
				spnEtagerePos.setEnabled(false);
				cVEmbaseType.getControl().setEnabled(false);
				comboViewer_FacadeType.getControl().setEnabled(false);

				btnSocle.setEnabled(false);
				btnJouet.setEnabled(false);
				btnSPDroite.setEnabled(false);
				btnSPGauche.setEnabled(false);

				//
				tableComboVwr_Eltmat.getControl().setEnabled(false);
				tableComboVwr_facademat.getControl().setEnabled(false);
				tableComboVwr_Dosmat.getControl().setEnabled(false);

				vitreMaterialType.setEnabled(false);
				facadeMaterialType.setEnabled(false);
				elementMaterialType.setEnabled(false);
				dosMaterialType.setEnabled(false);
			}

			if (kitchenElement.getRealWorldPosition() != null) {
				Vector3 pos = kitchenElement.getRealWorldPosition();
				int y = (int) (pos.y * 1000);
				if (kitchenElement.getRealWorldDimension() != null) {
					Vector4 dim = kitchenElement.getRealWorldDimension();
					y -= (int) (dim.y * 500);

				}

				spny.setSelection(y);

			}
			//

			//
			if (kitchenElement.getType().equals(ObjectType.DEFINED)) {
				String caissonType = kitchenElement.getDesignObject().getDesignCaissonType();
				int family = WorldObjectFactory.getDesignFamily(kitchenElement);

			}

		}
		//
		if (kitchenElement.getType().equals(ObjectType.MODELED) && kitchenElement.getModel() != null
				&& kitchenElement.getModel().getInfo() != null
				&& kitchenElement.getModel().getInfo().getProperties() != null) {
			if (kitchenElement.getModel().getInfo().getProperties().containsKey("sens-porte")) {
				String value = kitchenElement.getModel().getInfo().getProperties().getProperty("sens-porte");
				cVSensPorte.getControl().setEnabled(true);
				cVSensPorte.setSelection(new StructuredSelection(value));

				cVSensPorte.refresh();
			}
		} else {
			cVSensPorte.getControl().setEnabled(false);
		}
		//
//			addListeners();

		//
	}

	public void addListeners() {
		if (spnHauteur.isEnabled()) {
			spnHauteur.addListener(SWT.FocusOut, controlListener);
			spnHauteur.addListener(SWT.KeyUp, KeyUpListener);

		}
		if (spnlongeur.isEnabled()) {
			spnlongeur.addListener(SWT.FocusOut, controlListener);
			spnlongeur.addListener(SWT.KeyUp, KeyUpListener);
		}
		if (spnProfondeur.isEnabled()) {
			spnProfondeur.addListener(SWT.FocusOut, controlListener);
			spnProfondeur.addListener(SWT.KeyUp, KeyUpListener);
		}
		if (spny.isEnabled()) {
			spny.addListener(SWT.FocusOut, controlListener);
			spny.addListener(SWT.KeyUp, KeyUpListener);
		}

		//
		if (spnNbetg.isEnabled()) {
			spnNbetg.addListener(SWT.FocusOut, controlListener);
			spnNbetg.addListener(SWT.KeyUp, KeyUpListener);
		}

		//
		if (cVSensPorte.getControl().isEnabled()) {
			cVSensPorte.addSelectionChangedListener(selectionListener);
		}
		if (spnLargeur.isEnabled()) {
			spnLargeur.addListener(SWT.FocusOut, controlListener);
			spnLargeur.addListener(SWT.KeyUp, KeyUpListener);
		}
		if (cVPositionType.getControl().isEnabled()) {
			cVPositionType.addSelectionChangedListener(selectionListener);
		}

		if (comboViewer_PorteType.getControl().isEnabled()) {
			comboViewer_PorteType.addSelectionChangedListener(selectionListener);
		}
		if (comboViewer_PorteDirection.getControl().isEnabled()) {
			comboViewer_PorteDirection.addSelectionChangedListener(selectionListener);
		}
		//
		if (btnBosolDroite.isEnabled()) {
			btnBosolDroite.addSelectionListener(buttonListener);
		}
		if (btnBosolGauche.isEnabled()) {
			btnBosolGauche.addSelectionListener(buttonListener);
		}
		if (btnPersageDroite.isEnabled()) {
			btnPersageDroite.addSelectionListener(buttonListener);
		}
		if (btnPersageGauche.isEnabled()) {
			btnPersageGauche.addSelectionListener(buttonListener);
		}
		//
		if (btnPlaque.isEnabled()) {
			btnPlaque.addSelectionListener(buttonListener);
		}
		//
		if (btnIlot.isEnabled()) {
			btnIlot.addSelectionListener(buttonListener);
		}
		//
		if (btnOmmitDos.isEnabled()) {
			btnOmmitDos.addSelectionListener(buttonListener);
		}
		//
		if (spnCoinsRetrait.isEnabled()) {
			spnCoinsRetrait.addListener(SWT.FocusOut, controlListener);
			spnCoinsRetrait.addListener(SWT.KeyUp, KeyUpListener);
		}
		if (spnJouetReour.isEnabled()) {
			spnJouetReour.addListener(SWT.FocusOut, controlListener);
			spnJouetReour.addListener(SWT.KeyUp, KeyUpListener);
		}
		//
		if (spnVitreBandeL.isEnabled()) {
			spnVitreBandeL.addListener(SWT.FocusOut, controlListener);
			spnVitreBandeL.addListener(SWT.KeyUp, KeyUpListener);
		}
		//
		if (spnEtagerePos.isEnabled()) {
			spnEtagerePos.addListener(SWT.FocusOut, controlListener);
			spnEtagerePos.addListener(SWT.KeyUp, KeyUpListener);
		}
		if (cVEmbaseType.getControl().isEnabled()) {
			cVEmbaseType.addSelectionChangedListener(selectionListener);

		}
		if (comboViewer_FacadeType.getControl().isEnabled()) {
			comboViewer_FacadeType.addSelectionChangedListener(selectionListener);
		}
		if (btnSocle.isEnabled()) {
			btnSocle.addSelectionListener(buttonListener);
		}
		if (btnJouet.isEnabled()) {
			btnJouet.addSelectionListener(buttonListener);
		}
		if (btnSPDroite.isEnabled()) {
			btnSPDroite.addSelectionListener(buttonListener);
		}
		if (btnSPGauche.isEnabled()) {
			btnSPGauche.addSelectionListener(buttonListener);
		}

		//
	}

	public void CreateControlForDesign() {
		if (design != null) {
			try {

				createControlForIntegerParams("global.l", spnlongeur);
				createControlForIntegerParams("global.h", spnHauteur);
				createControlForIntegerParams("global.p", spnProfondeur);
				createControlForIntegerParams("global.largeur", spnLargeur);
				createControlForIntegerParams("separator.position", spnEtagerePos);
				createControlForIntegerParams("coins.retrait", spnCoinsRetrait);
				createControlForIntegerParams("facade.retourL", spnJouetReour);
				createControlForIntegerParams("vitre.bandeL", spnVitreBandeL);

				createControlForIntegerParams("ETAGERE_COUNT", spnNbetg);
				//
				createControlForBooleanParams("USE_PERSAGELEFT", btnPersageGauche);
				createControlForBooleanParams("USE_PERSAGERIGHT", btnPersageDroite);

				createControlForBooleanParams("USE_BOSOLLEFT", btnBosolGauche);
				createControlForBooleanParams("USE_BOSOLRIGHT", btnBosolDroite);

				createControlForBooleanParams("sansPoignee_CavityLeft", btnSPGauche);
				createControlForBooleanParams("sansPoignee_CavityRight", btnSPDroite);
				createControlForBooleanParams("is_ilot", btnIlot);

				createControlForBooleanParams("Plaque_exist", btnPlaque);
				createControlForBooleanParams("ommit_dos", btnOmmitDos);
				createControlForBooleanParams("is_jouet", btnJouet);
				createControlForBooleanParams("contains_socle", btnSocle);
				//
				createControlForTypeParams("EMBASE_TYPE", cVEmbaseType);
				createControlForTypeParams("POSITION_TYPE", cVPositionType);

				createControlForTypeParams("PORT_TYPE", comboViewer_PorteType);
				createControlForTypeParams("PORTE_DIRECTION", comboViewer_PorteDirection);
				createControlForTypeParams("FACADE_TYPE", comboViewer_FacadeType);

//				tableComboVwr_facademat.setInput(ResourceManagers.getIntance().getMaterials());
//				tableComboVwr_Eltmat.setInput(ResourceManagers.getIntance().getMaterials());
//				tableComboVwr_Dosmat.setInput(ResourceManagers.getIntance().getMaterials());

				tableComboVwr_Eltmat.setSelection(new StructuredSelection(design.getPrincipalmaterial()), true);
				tableComboVwr_Eltmat.getControl().setEnabled(true);
				tableComboVwr_facademat.setSelection(new StructuredSelection(design.getFacadeMaterial()), true);
				tableComboVwr_facademat.getControl().setEnabled(true);
				tableComboVwr_Dosmat.setSelection(new StructuredSelection(design.getSecondmaterial()), true);
				tableComboVwr_Dosmat.getControl().setEnabled(true);
				//
				if (design.getDefaultVitreMaterialType() != null) {
					vitreMaterialType.setMaterial(design.getDefaultVitreMaterialType());
					vitreMaterialType.setEnabled(true);
				} else {
					vitreMaterialType.setEnabled(false);
				}
				if (design.getFacadeMaterialType() != null) {
					facadeMaterialType.setMaterial(design.getFacadeMaterialType());
					facadeMaterialType.setEnabled(true);
				} else {
					facadeMaterialType.setEnabled(false);
				}
				if (design.getPrincipalMaterialType() != null) {
					elementMaterialType.setMaterial(design.getPrincipalMaterialType());
					elementMaterialType.setEnabled(true);
				} else {
					elementMaterialType.setEnabled(false);
				}
				if (design.getSecondMaterialType() != null) {
					dosMaterialType.setMaterial(design.getSecondMaterialType());
					dosMaterialType.setEnabled(true);
				} else {
					dosMaterialType.setEnabled(false);
				}
				if (design.getChantFacade() != null) {
					tableComboVwr_ChantFacade.setSelection(new StructuredSelection(design.getChantFacade()), true);
					tableComboVwr_ChantFacade.getControl().setEnabled(true);
				} else {
					tableComboVwr_ChantFacade.getControl().setEnabled(false);
				}
				if (design.getChantElement() != null) {
					tableComboVwr_ChantElement.setSelection(new StructuredSelection(design.getChantElement()), true);
					tableComboVwr_ChantElement.getControl().setEnabled(true);
				} else {
					tableComboVwr_ChantElement.getControl().setEnabled(false);
				}
				pieceModel_Composite.setRootspace(space);
				createPieceFacadeTypeComposite();
			} catch (Exception e) {

				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}

	}

	public boolean validate(Object object2) {
		boolean valide = true;
		PortType portType = null;
		PorteDirection porteDirection = null;

		//
		IStructuredSelection selectionPorteType = comboViewer_PorteType.getStructuredSelection();
		Object sPorteType = selectionPorteType.getFirstElement();

		if (sPorteType != null && sPorteType instanceof TypeDefElement) {
			TypeDefElement sPorteTypes = (TypeDefElement) sPorteType;
			portType = PortType.valueOf(sPorteTypes.getKey());

		}
		//
		IStructuredSelection selectionPorteDirction = comboViewer_PorteDirection.getStructuredSelection();
		Object sPorteDirection = selectionPorteDirction.getFirstElement();

		if (sPorteDirection != null && sPorteDirection instanceof TypeDefElement) {
			TypeDefElement sPorteDirections = (TypeDefElement) sPorteDirection;
			porteDirection = PorteDirection.valueOf(sPorteDirections.getKey());

		}

		if (object2 != null && object2.equals(comboViewer_PorteType) && portType != null) {

			String caissonType = space.getDesignCaissonType();
			if ((portType.equals(PortType.BASCULANT) || portType.equals(PortType.BASCULANT2H))
					&& (!caissonType.contentEquals("HAUT") || space.getName().toUpperCase().contains("NICHE"))) {
				valide = false;
				MessageBox dialog = new MessageBox(MesureWidow.this.getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
				dialog.setText("Error");
				dialog.setMessage("impossible de faire la combination de porte " + portType.toString()
						+ " avec la porte en direction " + space.getName());
				// open dialog and await user selection
				dialog.open();
			}
		}

		return valide;
	}

	public static TypeDef getTypeDef(String key) {
		ModelRoot root = ModelProvider.getModelroot();
		EList<TypeDef> types = root.getCategorie().getTypedef();
		for (TypeDef type : types) {
			if (type.getKey().contentEquals(key)) {
				return type;
			}
		}

		return null;
	}

	public DesignChangeParamCommand UpdateForBooleanParams(String paramKey, Button control, boolean isPublic) {
		try {
			MechanicPublicParam param = this.design.getPublicParam(paramKey);
			if (param != null && control.isEnabled()) {
				TypeDefElement element1 = param.getTypedefelement();
				String b = param.getTypedefelement().getKey();
				boolean value = Boolean.valueOf(b);
				boolean slection = control.getSelection();
				if (value != slection) {
					TypeDefElement element = param.getTypedef().getElement(String.valueOf(slection));
					param.setTypedefelement(element);
					;
					DesignChangeParamCommand UsePersageLeftChange = new DesignChangeParamCommand(
							"Changer la parametre" + paramKey + " " + MesureWidow.this.kitchenElement.getName(),
							paramKey, MesureWidow.this.kitchenElement, paramKey, isPublic, element1, element);
					return UsePersageLeftChange;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public void createControlForIntegerParams(String param, Spinner control) {
		boolean valid = false;
		try {
			MechanicPublicParam parametre = this.design.getPublicParam(param);

			if (parametre != null) {
				String sValue = parametre.getDefaultvalue();
				int value = Float.valueOf(sValue).intValue();
				control.setSelection(value);
				valid = parametre.isChangeable();
			} else {
				valid = false;
			}
		} catch (Exception e) {
			e.printStackTrace();
			valid = false;
		}
		control.setEnabled(valid);
	}

	public void createControlForBooleanParams(String param, Button control) {
		boolean valid = false;
		try {
			MechanicPublicParam parametre = this.design.getPublicParam(param);
			if (parametre != null) {
				TypeDefElement elment = parametre.getTypedefelement();
				boolean value = Boolean.valueOf(elment.getKey());

				control.setSelection(value);
				valid = parametre.isChangeable();
			} else {
				valid = false;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			valid = false;
		}
		control.setEnabled(valid);
	}

	public boolean createControlForTypeParams(String param, ComboViewer control) {
		boolean valid = false;
		try {
			MechanicPublicParam parametre = this.design.getPublicParam(param);
			if (parametre != null) {
				TypeDefElement element = parametre.getTypedefelement();
				control.setSelection(new StructuredSelection(element), true);
				valid = parametre.isChangeable();

			} else {
				valid = false;
			}
		} catch (Exception e) {
			valid = false;
		}

		control.getControl().setEnabled(valid);
		return valid;
	}

	public void setInputs() {
		cVEmbaseType.setInput(getTypeDef("EMBASE_TYPE"));
		cVPositionType.setInput(getTypeDef("POSITION_TYPE"));

		comboViewer_PorteType.setInput(getTypeDef("PORT_TYPE"));
		comboViewer_PorteDirection.setInput(getTypeDef("PORTE_DIRECTION"));
		comboViewer_FacadeType.setInput(getTypeDef("FACADE_TYPE"));

	}

	private static class ViewerLabelProvider extends LabelProvider {
		public Image getImage(Object element) {
			return super.getImage(element);
		}

		public String getText(Object element) {
			return (String) element;
		}
	}

	private static class ContentProvider implements IStructuredContentProvider {
		public Object[] getElements(Object inputElement) {
			if (inputElement instanceof Collection) {
				return ((Collection) inputElement).toArray();
			}
			return (Object[]) inputElement;
		}

		public void dispose() {
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		return bindingContext;
	}

}
