package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

import gdxapp.scenes.ScenePreferences;

public class SceneAppearanceSettingPage extends WizardPage {
	
	private ScenePreferences preferences;

	private SceneAppearanceSettingComposite composite;
	
	protected SceneAppearanceSettingPage(ScenePreferences preferences) {
		super("Apparence du Scéne");
		this.preferences = preferences;
	}

	@Override
	public void createControl(Composite parent) {
		composite = new SceneAppearanceSettingComposite(parent, preferences);
		composite.addPropertyChangeListener(new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				getWizard().getContainer().updateButtons();
				
			}
		});
		setControl(composite);
	}

	@Override
	public boolean isPageComplete() {
		return composite!=null && composite.hasValidInput();
	}
	
	
	public void onFinish() {
		composite.apply();
	}

	@Override
	public Point getMinimumPageSize() {
		// TODO Auto-generated method stub
		return new Point(1080, 720);
	}
	
	
}
