package dressing.events;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ScreenController;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
public class EventDriver {
	
	private ConcurrentHashMap<String, HashSet<EventHandler>> subscriptions = new ConcurrentHashMap<String, HashSet<EventHandler>>();
	
	private static EventDriver driver = new EventDriver();
	
	private EventDriver() {}
	

	
	public void deliverEvent(SceneEvent topic, Object data) {
		Event event = new Event(topic.name(), data);
		notifySubscribers(event);
	}
	
	public void deliverEvent(Event event) {
		notifySubscribers(event);
	}
	
	synchronized public void registerSubscription(String topic, EventHandler handler) {
		HashSet<EventHandler> topicFollower = subscriptions.get(topic);
		if(topicFollower == null) {
			topicFollower = new HashSet<EventHandler>();
			subscriptions.put(topic, topicFollower);
		}
		topicFollower.add(handler);
	}
	
	synchronized public void removeSubscription(String topic, EventHandler handler) {
		HashSet<EventHandler> topicFollower = subscriptions.get(topic);
		if(topicFollower == null)
			return;
		topicFollower.remove(handler);
	}


	synchronized private void notifySubscribers(Event event) {
		HashSet<EventHandler> handlers = subscriptions.get(event.getTopic());
		if(handlers != null && !handlers.isEmpty()) {
			EventHandler[] handlersArray = new EventHandler[1];
			handlersArray = handlers.toArray(handlersArray);
			for(int i = 0; i < handlersArray.length; i++) {
				handlersArray[i].handle(event);
			}
		  
		}
	}

	public static EventDriver getDriver() {
		return driver;
	}

	synchronized void removeSubscriber(EventHandler eventHandler) {
		for(HashSet<EventHandler> set: subscriptions.values()) {
			set.remove(eventHandler);
		}
	}
	

}
