package dressing.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;

import dressing.config.persistence.ResourceManagers;
import dressing.controller.ProjectCreator;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.scenes.ScenePreferences;
import param.Material;
import param.impl.MaterialImpl;

public class UserPreference {
	
	private Properties properties;
	private ScenePreferences scenePreferences;
	private int maxProjectBackUps = 10;
	private transient boolean loaded = false;

	private static UserPreference preference = new UserPreference();
	
	private transient Material primaryMaterial = null;
	private transient Material backMaterial = null;
	private transient Material faceMaterial = null;
	private UUID idPrimaryMaterial = null;
	private UUID idbackMaterial = null;
	private UUID idFaceMaterial = null;
	
	public UserPreference() {}
	
	
	public void save() {
		Runnable task = () -> {
			File f = new File(WorkspaceConfiguration.SETTING_PATH);
			if(!f.exists()) {
				f.getParentFile().mkdirs();
				try {
					f.createNewFile();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					System.err.println("could not create user preference file");
					return;
				}
			}
			if (f.exists()) {
				MapperProvider.getXmlMapper().write(this, f);
			}
		};
		Thread thread = new Thread(task);
		thread.start();
	}
	
	public void load() {
		properties = new Properties();
		File f = new File(WorkspaceConfiguration.SETTING_PATH);
		FileInputStream inputstream = null;
		if (f.exists()) {
			try {
				inputstream = new FileInputStream(f);
				UserPreference loadedPreference = MapperProvider.getXmlMapper().fromXml(inputstream, UserPreference.class );
				inputstream.close();
				loadedPreference.loaded = true;

				// FIX: initialize materials on the LOADED instance
				loadedPreference.loadMaterials();

				// FINALLY: replace the singleton instance
				preference = loadedPreference;
			} catch (IOException e) {
				e.printStackTrace();
				if(preference == null)
					preference = new UserPreference();
			} finally {
				try {
					if (inputstream != null)
						inputstream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}
	
	public void loadMaterials() {
		Material mat18 = ResourceManagers.getIntance().getSystemMaterialGroup().getMaterial().stream()
				.filter(mat -> mat.getEpaisseur() == 18.0).findAny().orElse(null);

		Material mat5 = ResourceManagers.getIntance().getSystemMaterialGroup().getMaterial().stream()
				.filter(mat -> mat.getEpaisseur() == 5.0).findAny().orElse(null);

		setFaceMaterial(idFaceMaterial!=null?(MaterialImpl) ResourceManagers.getIntance().getMaterial(idFaceMaterial):mat18);
		setPrimaryMaterial(idPrimaryMaterial!=null?(MaterialImpl) ResourceManagers.getIntance().getMaterial(idPrimaryMaterial):mat18);
		setBackMaterial(idbackMaterial!=null?(MaterialImpl) ResourceManagers.getIntance().getMaterial(idbackMaterial):mat5);
		
	}
	

	public Material getPrimaryMaterial() {
		return primaryMaterial;
	}

	public void setPrimaryMaterial(Material primaryMaterial) {
		this.primaryMaterial = primaryMaterial;
		if(this.primaryMaterial!=null)
		{
			this.idPrimaryMaterial=this.primaryMaterial.getModelId();
		}
	}

	public Material getBackMaterial() {
		return backMaterial;
	}


	public void setBackMaterial(Material backMaterial) {
		this.backMaterial = backMaterial;
		if(this.backMaterial!=null)
		{
			this.idbackMaterial=this.backMaterial.getModelId();
		}
	}


	public Material getFaceMaterial() {
		return faceMaterial;
	}

	public void setFaceMaterial(Material faceMaterial) {
		this.faceMaterial = faceMaterial;
		if(this.faceMaterial!=null)
		{
			this.idFaceMaterial=this.faceMaterial.getModelId();
		}
	}
	public synchronized static UserPreference getInstance() {
		if (preference == null) {
			preference = new UserPreference();
		}
		return preference;
	}
	public static UserPreference getPreference() {
		return preference;
	}

	public static void setPreference(UserPreference preference) {
		UserPreference.preference = preference;
	}

	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	public boolean isLoaded() {
		return loaded;
	}

	public void setLoaded(boolean loaded) {
		this.loaded = loaded;
	}
	
	public ScenePreferences getScenePreferences() {

		return scenePreferences;
	}

	public void setScenePreferences(ScenePreferences scenePreferences) {
		this.scenePreferences = scenePreferences;
	}
	
	public int getMaxProjectBackUps() {
		return maxProjectBackUps;
	}

	public void setMaxProjectBackUps(int maxProjectBackUps) {
		this.maxProjectBackUps = maxProjectBackUps;
	}

	public static void main(String[] args) {
		preference.load();
	}
	
	
	
}
