package dressing.config;

public class ModulesPreferences extends PreferencesProporties {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static ModulesPreferences instance;

	/**
	 * Returns an instance of ArrayContentProvider. Since instances of this class do
	 * not maintain any state, they can be shared between multiple clients.
	 *
	 * @return an instance of ArrayContentProvider
	 *
	 * @since 3.5
	 */
	public static ModulesPreferences getInstance() {
		synchronized (ModulesPreferences.class) {
			if (instance == null) {
				instance = new ModulesPreferences();
			}
			return instance;
		}
	}

	public ModulesPreferences() {
		super();
	}

	@Override
	protected String getPath() {
		
		return WorkspaceConfiguration.getModulesPrefs();
	}

}
