package test;

import java.util.Date;
import java.util.List;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFContentProvider;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.paramManagerModel;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Preferences;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import gdxapp.scenes.ScenePreferences;
import param.DesignClasse;
import param.Material;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.MechanicPublicParam;
import param.impl.MechanicPrivateParamImpl;
import param.impl.MechanicPublicParamImpl;
import param.impl.ParamFactoryImpl;
import param.Option;
import param.PublicParamGroup;

public class TestMechanicDesign extends EditorWindow{
	public Shell shell;
	paramManagerModel model=new paramManagerModel(false);
	private ListViewer lV_includedClasses;
	private Button removeClassButton;
	private ListViewer lv_ExcludedClasses;
	private Button addClassButton;
	private ListViewer lv_IncludedFamilies;
	private Button removefamilyButton;
	private ListViewer lv_ExcludedFamilies;
	private Button addfamilyButton;
	private ListViewer lv_IncludedDesigns;
	private Button removeDesignButton;
	private Button addDesignButton;
	private ListViewer lv_ExcludedDesigns;
	private Text text;
	private Text text_1;
	private Text text_2;
	private Text text_3;
	private Text text_4;
	private Text text_5;
	private Text text_6;
	private org.eclipse.swt.widgets.List includedClasses;
	private org.eclipse.swt.widgets.List excludedClasses;
	private org.eclipse.swt.widgets.List includedFamilies;
	private org.eclipse.swt.widgets.List excludedFamilies;
	private org.eclipse.swt.widgets.List includedDesigns;
	private org.eclipse.swt.widgets.List excludedDesigns;
	private ListViewer privateParamsListViewer_1;
	private org.eclipse.swt.widgets.List privateParamsList_1;
	private ListViewer publicParamsListViewer;
	private org.eclipse.swt.widgets.List publicParamsList;
	private Combo comboPrivateTypeDef;
	private Combo comboPrivateTypeDefElement;
	private Combo comboPublicTypeDef;
	private Combo comboPublicTypeDefElment;
	private Button btnChangable;
	private ComboViewer cbVPublicTypeDef;
	private ComboViewer cbVPublicTypeDefElment;
	private ComboViewer cbVPrivateTypeDef;
	private ComboViewer cbvPrivateTypeDefElement;
	private MechanicPrivateParamImpl privateParam=(MechanicPrivateParamImpl) ParamFactoryImpl.eINSTANCE.createMechanicPrivateParam();
	private MechanicPublicParamImpl publicParam=(MechanicPublicParamImpl) ParamFactoryImpl.eINSTANCE.createMechanicPublicParam();
	private Button btnPrivate;
	private Button btnPublic;
	private Button btnType;
	private Button btnValue;
	private Button btnLabel;
	private ListViewer lv_IncludedDesignElements;
	private org.eclipse.swt.widgets.List includedDesignElementsList;
	private Button removeDesignElementsButton_1;
	private ListViewer lv_ExcludedDesignElements_1;
	private org.eclipse.swt.widgets.List excludedDesignElementsList;
	private Button addDesignElementsButton_1;
	public TestMechanicDesign(Shell parentShell) {
		super(parentShell,EditorWindow.update);
		setTitle("Ajouter des élément de test");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		
		Composite composite_1 = new Composite(parent, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 685;
		gd_composite_1.heightHint = 410;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(1, false));
		
		ExpandBar expandBar = new ExpandBar(composite_1, SWT.NONE);
		GridData gd_expandBar = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_expandBar.heightHint = 308;
		expandBar.setLayoutData(gd_expandBar);
		
		ExpandItem xpndtmClass = new ExpandItem(expandBar, SWT.NONE);
		xpndtmClass.setText("Class");
		
		ScrolledComposite scrolledComposite = new ScrolledComposite(expandBar, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		xpndtmClass.setControl(scrolledComposite);
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);
		xpndtmClass.setHeight(100);
		
		Composite composite_3 = new Composite(scrolledComposite, SWT.NONE);
		composite_3.setLayout(new GridLayout(3, false));
		
		lV_includedClasses = new ListViewer(composite_3, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedClasses = lV_includedClasses.getList();
		includedClasses.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lV_includedClasses.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lV_includedClasses.setContentProvider(ArrayContentProvider.getInstance());
		
		removeClassButton = new Button(composite_3, SWT.NONE);
		removeClassButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				IStructuredSelection selection = lV_includedClasses.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof DesignClasse) {
						model.removeClasses(select);
						update();
					}
				}
				
			}
		});
		removeClassButton.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, false, false, 1, 1));
		removeClassButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		
		lv_ExcludedClasses = new ListViewer(composite_3, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedClasses = lv_ExcludedClasses.getList();
		excludedClasses.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_ExcludedClasses.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedClasses.setContentProvider(ArrayContentProvider.getInstance());
		
		addClassButton = new Button(composite_3, SWT.NONE);
		addClassButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				IStructuredSelection selection = lv_ExcludedClasses.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof DesignClasse) {
						model.addClasses(select);
						update();
					}
				}
				
			}
		});
		addClassButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		addClassButton.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		scrolledComposite.setContent(composite_3);
		scrolledComposite.setMinSize(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		ExpandItem xpndtmFamille = new ExpandItem(expandBar, SWT.NONE);
		xpndtmFamille.setText("family");
		
		Composite composite_3_1 = new Composite(expandBar, SWT.NONE);
		xpndtmFamille.setControl(composite_3_1);
		xpndtmFamille.setHeight(200);
		composite_3_1.setLayout(new GridLayout(3, false));
		
		lv_IncludedFamilies = new ListViewer(composite_3_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedFamilies = lv_IncludedFamilies.getList();
		GridData gd_includedFamilies = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_includedFamilies.heightHint = 54;
		includedFamilies.setLayoutData(gd_includedFamilies);
		lv_IncludedFamilies.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_IncludedFamilies.setContentProvider(ArrayContentProvider.getInstance());
		removefamilyButton = new Button(composite_3_1, SWT.NONE);
		removefamilyButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_IncludedFamilies.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesignGroup) {
						model.removeFamilies(select);
						update();
					}
				}
			}
		});
		removefamilyButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		removefamilyButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		
		lv_ExcludedFamilies = new ListViewer(composite_3_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedFamilies = lv_ExcludedFamilies.getList();
		GridData gd_excludedFamilies = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_excludedFamilies.heightHint = 54;
		excludedFamilies.setLayoutData(gd_excludedFamilies);
		lv_ExcludedFamilies.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedFamilies.setContentProvider(ArrayContentProvider.getInstance());
		
		addfamilyButton = new Button(composite_3_1, SWT.NONE);
		addfamilyButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_ExcludedFamilies.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesignGroup) {
						model.addFamilies(select);
						update();
					}
				}
			}
		});
		addfamilyButton.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		addfamilyButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		
		ExpandItem xpndtmDesigns = new ExpandItem(expandBar, SWT.NONE);
		xpndtmDesigns.setText("designs");
		
		Composite composite_3_1_1 = new Composite(expandBar, SWT.NONE);
		xpndtmDesigns.setControl(composite_3_1_1);
		xpndtmDesigns.setHeight(500);
		composite_3_1_1.setLayout(new GridLayout(3, false));
		
		lv_IncludedDesigns = new ListViewer(composite_3_1_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedDesigns = lv_IncludedDesigns.getList();
		includedDesigns.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_IncludedDesigns.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_IncludedDesigns.setContentProvider(ModelEMFContentProvider.getInstance());
		
		removeDesignButton = new Button(composite_3_1_1, SWT.NONE);
		removeDesignButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_IncludedDesigns.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesign) {
						model.removeDesigns(select);
						update();
					}else
					if (select != null && select.get(0) instanceof Option) {
						model.removeDesignsOptions(select);
						update();
					}
				}
			}
		});
		removeDesignButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		removeDesignButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		
		lv_ExcludedDesigns = new ListViewer(composite_3_1_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedDesigns = lv_ExcludedDesigns.getList();
		GridData gd_excludedDesigns = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_excludedDesigns.heightHint = 58;
		excludedDesigns.setLayoutData(gd_excludedDesigns);
		lv_ExcludedDesigns.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedDesigns.setContentProvider(ModelEMFContentProvider.getInstance());
		
		addDesignButton = new Button(composite_3_1_1, SWT.NONE);
		addDesignButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_ExcludedDesigns.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesign) {
						model.addDesigns(select);
						update();
					}else
					if (select != null && select.get(0) instanceof Option) {
						model.addDesignsOptions(select);
						update();
					}
				}
			}
		});
		addDesignButton.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		addDesignButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		update();			

		return composite_1;
	}

	public void update() {
		lV_includedClasses.setInput(model.getIncludedclasses());
		lv_IncludedFamilies.setInput(model.getIncludedfamily());
		lv_IncludedDesigns.setInput(model.getIncludeddesignOptions());
		lv_ExcludedClasses.setInput(model.getExcludedclasses());
		lv_ExcludedFamilies.setInput(model.getExcludedfamily());
		lv_ExcludedDesigns.setInput(model.getExcludeddesignOptions());
		
	}
	@Override
	public boolean terminer() {
		// TODO Auto-generated method stub
		addSelectedDesignsToKitchen();
		finish();
		return true;
	}

	public void addSelectedDesignsToKitchen() {
		float start=0.0f;
		float xtart=4.0f;
		System.err.println(new Date().getTime());
		for (Option option : model.getIncludeddesignOptions()) {
			try {
				final DesignObject3D designObject;

				MechanicDesign origin = option.getDesign();
				MechanicDesign design = EcoreUtil.copy(origin);
				design.injectOption(option);

				design.setName(option.getLabel());
				if(ProjectManager.getManager().getCurrentKitchen()!=null) {
					Kitchen kitchen=ProjectManager.getManager().getCurrentKitchen();
					MechanicDesignCreator.getInstance().updateMaterialFromKitchen(kitchen, design);
				}
				//

				designObject = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), null,
						null, design, MechanicDesignCreator.create, false);
				ProjectManager.getManager().getCurrentKitchen().addElement(designObject);

				WorldObject object = WorldObjectFactory.getFactory().createObjectFromDefinition(designObject);
				object.setRotation(-90);
				start+=object.getRealWorldDimension().x;
				object.getRealWorldPosition().z+=start-object.getRealWorldDimension().x/2.0f;
				object.getRealWorldPosition().x=xtart-object.getRealWorldDimension().z/2.0f;
				var scene = ProjectManager.getManager().getCurrentScene();
				scene.addActor(object, false);
				if(start>scene.getPreferences().getWORLD_WIDTH()) {
					start=0.0f;
					xtart+=1.0f;
				}
//				((AbstractScreen) Scene.game.getScreen()).getController().reloadActors();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		System.err.println(new Date().getTime());
		ProjectManager.getManager().getCurrentScene().update();
	}

	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected void cancel() {
		// TODO Auto-generated method stub
		
	}

	
	
}
