package gdxapp.Commun;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;

import dressing.controller.tools.ToolController;
import dressing.handlers.gdx.ToolControlHandler;
import dressing.mathutils.MathUtilities;
import dressing.model.ProjectManager;
import dressing.ui.util.NoteEditorWidow;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;
import gdxapp.scenes.Scene;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.SurfaceScreen;
import gdxapp.ui.Note;
import gdxapp.ui.TextZone;
import gdxapp.ui.UIComponentCreator;

public class TextWriter extends Group {
	
	ArrayList<TextZone> textZones = new ArrayList<TextZone>();
	TextWriterInputProcessor inputProcessor;
	TextZone textZone;
	Vector2 start;
	Vector2 end;
	Vector2[] corners;
	private int cornerSelected;
	private static TextWriter writer = new TextWriter();
	
	private TextWriter() {
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		setPosition(0, 0);
		inputProcessor = new TextWriterInputProcessor();
		addListener(inputProcessor);
	}
	
	
	
	public void begin(Vector2 start, Vector2 end) {
		textZone = new TextZone();
		addActor(textZone);
		textZone.setWidth(Math.abs(start.x - end.x));
		textZone.setHeight(Math.abs(start.y - end.y));
		textZone.setPosition(Math.min(start.x, end.x),Math.min(end.y, start.y));
		textZone.construct();
		textZone.setFillParent(true);
		textZones.add(textZone);
		calculateCorners();	}
	
	public void update() {
		textZone.setWidth(Math.abs(start.x - end.x));
		textZone.setHeight(Math.abs(start.y - end.y));
		textZone.setPosition(Math.min(start.x, end.x),Math.min(end.y, start.y));
		calculateCorners();
	}



	
	public void calculateCorners() {
		if(corners == null)
			corners = new Vector2[4];
		corners[0] = new Vector2(Math.min(start.x, end.x),Math.min(start.y, end.y));
		corners[1] = new Vector2(Math.max(start.x, end.x),Math.min(start.y, end.y));
		corners[2] = new Vector2(Math.max(start.x, end.x),Math.max(start.y, end.y));
		corners[3] = new Vector2(Math.min(start.x, end.x),Math.max(start.y, end.y));
	}
	
	public void finish() {
//		Note note = new Note();
//		Color color = textZone.getColor();
//		String text = textZone.getTextArea().getText();
//		float scale = Float.valueOf((String)textZone.getSelectBox().getSelected())/32f;
//		note.setColor(color);
//		note.setContent(text);
//		note.setPosition(textZone.getX(), textZone.getY());
//		note.setSize(scale);
//		note.calculateSize();
//		Screen screen = Scene.game.getScreen();
//		if(screen instanceof SurfaceScreen) {
//			SurfaceController controller = (SurfaceController) ((SurfaceScreen) screen).getController();
//			note.setContext(controller.getSurface());
//		}
//		getStage().addActor(note);
//		ProjectManager.getManager().getCurrentScene().addNote(note);
		textZone = null;
		start = null;
		end = null;
		clearChildren();
		boolean removed = remove();
		Gdx.app.debug("TEXTWRITER", "removed " + removed);
		ToolControlHandler.getInstance().threadSafeTriggerSelectObject();
	}
	
	public void clear() {
		if(textZones != null)
			textZones.clear();
	}
	
	
	
	
	
	
	public synchronized int getCornerSelected() {
		return cornerSelected;
	}

	public synchronized void setCornerSelected(int cornerSelected) {
		this.cornerSelected = cornerSelected;
	}


	public static TextWriter getWriter() {
		return writer;
	}


	public static void setWriter(TextWriter writer) {
		TextWriter.writer = writer;
	}
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		if(textZone != null) {
			super.draw(batch, parentAlpha);
			drawCorners(batch);
		}
		else if(start != null && end != null) {
			DrawingHelper.drawCutLine(start, new Vector2(end.x,start.y), batch, Color.BLACK, 1);
			DrawingHelper.drawCutLine(start, new Vector2(start.x,end.y), batch, Color.BLACK, 1);
			DrawingHelper.drawCutLine(end, new Vector2(start.x,end.y), batch, Color.BLACK, 1);
			DrawingHelper.drawCutLine(end, new Vector2(end.x,start.y), batch, Color.BLACK, 1);
			drawCorners(batch);
		}
	}
	
	public void drawCorners(Batch batch) {
		DrawingHelper.drawSquare(start, batch, Color.BLACK,5);
		DrawingHelper.drawSquare(end, batch, Color.BLACK,5);
		DrawingHelper.drawSquare(new Vector2(start.x,end.y), batch, Color.BLACK,5);
		DrawingHelper.drawSquare(new Vector2(end.x,start.y), batch, Color.BLACK,5);
	}
	
	public boolean mouseOverStretchingPoints(float x, float y) {
		if(corners != null) {
			Vector2 point = new Vector2(x,y);
			for(int i = 0; i < corners.length; i++) {
				float distance = MathUtilities.distance(point, corners[i], corners[(i+1) % 4 ]);
				if(distance < 10) {
					setCornerSelected(point.dst(corners[i]) < point.dst(corners[(i+1) % 4 ])? i : (i+1) % 4);
					return true;
				}
			}
		}
		setCornerSelected(-1);
		return false;
	}

	public void setkeyboardFocus() {
		if (getStage() != null){
					getStage().setKeyboardFocus(this);
		}
	}

	public Vector2 getStart() {
		return start;
	}


	public void setStart(Vector2 start) {
		this.start = start;
	}


	public Vector2 getEnd() {
		return end;
	}


	public void setEnd(Vector2 end) {
		this.end = end;
	}


	class TextWriterInputProcessor extends ActorInputListener{

		private final String TAG = TextWriterInputProcessor.class.getName();
		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
//			if(textZone == null) {
//				setStart(new Vector2(x,y));
//				setEnd(null);
//			}
			return true;
		}

		@Override
		public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
			Gdx.app.debug(TAG, "touch up");
//			if(start != null && end != null && textZone == null) {
//					begin(start, end);
//			}
			Note note=Note.getDefault();
			note.setPosition(x, y);
			Screen screen = Scene.game.getScreen();
			if(screen instanceof SurfaceScreen) {
				SurfaceController controller = (SurfaceController) ((SurfaceScreen) screen).getController();
				note.setContext(controller.getSurface());
			}
			getStage().addActor(note);
			ProjectManager.getManager().getCurrentScene().addNote(note);
			Display.getDefault().asyncExec(new Runnable() {
				public void run() {
					NoteEditorWidow window = NoteEditorWidow.getInstance();
					window.setNote(note);
					window.show();
				}
			});
			writer.finish();		
		}

		@Override
		public void touchDragged(InputEvent event, float x, float y, int pointer) {
//			if(textZone == null) {
//				setEnd(new Vector2(x,y));
//			}else if(getCornerSelected() >= 0) {
//				setStart(new Vector2(corners[(getCornerSelected()+2)%4].x,corners[(getCornerSelected()+2)%4].y));
//				setEnd(new Vector2(x,y));
//				calculateCorners();
//				update();
//			}
			super.touchDragged(event, x, y, pointer);
		}

		@Override
		public boolean mouseMoved(InputEvent event, float x, float y) {
//			if(mouseOverStretchingPoints(x, y)) {
//				Gdx.graphics.setCursor(AssetsTextures.instance.getCursors().get("enlarge-32.png"));
//			}else {
//				Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
//			}
			return true;
		}

		@Override
		public boolean keyDown(InputEvent event, int keycode) {
//			Gdx.app.debug(TAG, "key down");
			return super.keyDown(event, keycode);
		}

		@Override
		public boolean keyUp(InputEvent event, int keycode) {
//			Gdx.app.debug(TAG, "key up");
//			if(keycode == Keys.ESCAPE) {
//				if(textZone != null)
//					writer.finish();
//			}
			return super.keyUp(event, keycode);
		}

		@Override
		public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
			// TODO Auto-generated method stub
			super.enter(event, x, y, pointer, fromActor);
			
		}

		@Override
		public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
			// TODO Auto-generated method stub
			super.exit(event, x, y, pointer, toActor);
		}
		
	}




}
