package dressing.ui.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;

import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.ModulesPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.shaders.PbrMaterial;
import param.Chant;
import param.Material;
import param.MaterialType;
import param.impl.MaterialImpl;

public class SingleImageItemLabelProvider extends LabelProvider implements ITableLabelProvider ,ITableColorProvider {

	public final static String LABEL_PROPERTY = "user.title";
	public final static String DEFAULT_TITLE = "Unknown Title";
	private static SingleImageItemLabelProvider instance;
	
	public static SingleImageItemLabelProvider getInstance() {
		synchronized(SingleImageItemLabelProvider.class) {
			if (instance == null) {
				instance = new SingleImageItemLabelProvider();
			}
			return instance;
		}
	}	
	public SingleImageItemLabelProvider() {
		super();
	}

	public Image getColumnImage(Object element, int columnIndex) {
		String path="";
		
		if(element instanceof MaterialImpl) {
			MaterialImpl item = (MaterialImpl) element;
			if (columnIndex == 0) {
				SceneTexture texture=ModelProvider.getMaterialSceneTexture(item);
				if(texture!=null) {
					return texture.getLabelImage();
				}else 
				if (item != null && item.getImage() != null&& !item.getImage().isEmpty()) {
					path = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + item.getImage();
				}
			}
			
		}
		else if(element instanceof SceneTexture ) {
			SceneTexture texture = (SceneTexture) element;
				if (texture != null && texture.getPath() != null) 
					{
					return texture.getLabelImage();
					}	
		}else if (element instanceof PbrMaterial) {
			PbrMaterial mtl = (PbrMaterial) element;
			path =  mtl.getAlbedoMapPath();
		}
		
		if (path != null && !path.isEmpty()) {
			try {
				SceneTexture sceneTexture  = ModelProvider.getTexture(path);
				if(sceneTexture != null)
					return sceneTexture.getLabelImage();
				
			} catch (Exception e) {
				System.err.println("failed to get image label " + path);
				e.printStackTrace();
				return null;
			}
		}
		return null;
	}

	public String getPbrMaterialImageLabelPath(PbrMaterial element) {
		String albedoFileName = element.getAlbedoMapPath();
		String path = albedoFileName;
		if(albedoFileName != null) {
			File file = new File(albedoFileName);
			if(!file.exists()) {
				String altPath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + file.getName();
				file = new File(altPath);
				if(file.exists()) {
					path = file.getAbsolutePath();
				}
			}
		}else {
			path = element.getNormalMapPath();
			if(path == null)
				return null;
			File file = new File(path);
			if(!file.exists()) {
				String altPath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + file.getName();
				file = new File(altPath);
				if(file.exists())
					path = altPath;
			}
		}
		return path;
	}

	public String getColumnText(Object element, int columnIndex) {
		boolean isShowSalePrice = ModulesPreferences.getInstance().getBoolean("ui.showSalePrice", true);
	    boolean isShowCost = ModulesPreferences.getInstance().getBoolean("ui.showCost", true);
	    if (element instanceof Material) {
	        Material item = (Material) element;

	        int index = 0;

	        // Column 0 : Texture
	        if (columnIndex == index++) {
	            return item.getName();
	        }

	        // Column 1 : Epaisseur
	        if (columnIndex == index++) {
	            return String.valueOf(item.getEpaisseur());
	        }

	        // Optional columns
	        if (isShowCost) {
	            if (columnIndex == index++) {
	                return String.valueOf(item.getPrice()); // Prix (DT/m)
	            }
	        }

	        if (isShowSalePrice) {
	            if (columnIndex == index++) {
	                return String.valueOf(item.getSalePrice()); // Prix de Vente (DT/m²)
	            }
	        }

	        // Last column : Fabricant
	        if (columnIndex == index++) {
	            return item.getFabricant() != null ? item.getFabricant().getName() : "";
	        }

	        return "";
		} else if (element instanceof SceneTexture) {
			SceneTexture item = (SceneTexture) element;
			return readFileLabelProperty(Paths.get(item.getPath()));
		} else if (element instanceof MaterialType) {
			MaterialType item = (MaterialType) element;
			return item.getName();
		}else // For Chant
		    if (element instanceof Chant) {
		        Chant item = (Chant) element;

		        int index = 0;

		        if (columnIndex == index++) {
		            return item.getName();
		        }

		        if (columnIndex == index++) {
		            return String.valueOf(item.getEpaisseur());
		        }

		        if (isShowCost) {
		            if (columnIndex == index++) {
		                return String.valueOf(item.getPrice());
		            }
		        }

		        if (isShowSalePrice) {
		            if (columnIndex == index++) {
		                return String.valueOf(item.getSalePrice());
		            }
		        }

		        if (columnIndex == index++) {
		            return item.getFabricant() != null ? item.getFabricant().getName() : "";
		        }

		        return "";
		    }
		if(element.equals(SetCommand.UNSET_VALUE)) {
			return "";
		}
		return element.toString();
	}

	public String readFileLabelProperty(Path path) {
		return readFileProperties(path, LABEL_PROPERTY);
	}

	private String readFileProperties(Path path, String property) {

		if (path == null) {
			return DEFAULT_TITLE;
		}
		UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class);
		try {
			if (view.list().contains(property)) {
				int size = view.size(property);
				ByteBuffer buffer = ByteBuffer.allocate(size);
				view.read(property, buffer);
				buffer.flip();
				return StandardCharsets.UTF_8.decode(buffer).toString();
			}
		} catch (IOException e) {
			e.printStackTrace();

		}
		return path.getFileName() != null ? path.getFileName().toString() : DEFAULT_TITLE;
	}

	private void setFileProperty(Path path, String key, String value) throws IOException {
		UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class);
		view.write(key, ByteBuffer.wrap(value.getBytes()));

	}

	public void setFileLabelProperty(Path path, String lable) throws IOException {
		setFileProperty(path, LABEL_PROPERTY, lable);
	}
	@Override
	public Color getForeground(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public Color getBackground(Object element, int columnIndex) {
		if (element instanceof Material) {
			Material art = (Material) element;
			if (art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
				return StaticUiObjects.SYSTEM_MATERIAL_LIST_BACKGROUND_COLOR;
			}
		}
		return null;
		
	}

}
