package dressing.ui;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Country;
import param.Finition;
import param.ParamFactory;

public class CountryComboSelect extends ElementComboSelect {

	public CountryComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll(ResourceManagers.getIntance().getGestion().getCountries());
		return input;
	}

	@Override
	public void addElement() {
		Country country=ParamFactory.eINSTANCE.createCountry();
		country.setName("");
		CountryEditorWindow coutryEditorWindow = new CountryEditorWindow(getShell(),country,EditorWindow.create);
		coutryEditorWindow.create();
		int ret=coutryEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(country), true);
		}
	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof Country) {
			Country country=(Country) selection;
			CountryEditorWindow coutryEditorWindow = new CountryEditorWindow(getShell(),country,EditorWindow.update);
			coutryEditorWindow.create();
			int ret=coutryEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		// TODO Auto-generated method stub
		return new CountryListWindow(getShell(),null);
	}
}
