package dressing.cam.model;

import java.util.ArrayList;
import java.util.List;

import com.badlogic.gdx.math.Vector3;

import param.Tool;
import param.cam.MachineHead;

public class RainureGcode{
	private Tool tool;
	private MachineHead head;
	private Vector3 start;
	private Vector3 end;
	private double width;
	private double depth;
	
	public RainureGcode(Tool tool, MachineHead head, Vector3 start, Vector3 end) {
		super();
		this.tool = tool;
		this.head = head;
		this.start = start;
		this.end = end;
	}
	
	public RainureGcode(Tool tool, MachineHead head, Vector3 start, Vector3 end, double width, double depth) {
		super();
		this.tool = tool;
		this.head = head;
		this.start = start;
		this.end = end;
		this.width = width;
		this.depth = depth;
	}
	
	public RainureGcode(Vector3 start, Vector3 end, double width, double depth) {
		super();
		this.start = start;
		this.end = end;
		this.width = width;
		this.depth = depth;
	}
	
	
	public RainureGcode(Vector3 start, Vector3 end) {
		super();
		this.start = start;
		this.end = end;
	}

	public Tool getTool() {
		return tool;
	}
	public void setTool(Tool tool) {
		this.tool = tool;
	}
	public MachineHead getHead() {
		return head;
	}
	public void setHead(MachineHead head) {
		this.head = head;
	}
	public Vector3 getStart() {
		return start;
	}
	public void setStart(Vector3 start) {
		this.start = start;
	}
	public Vector3 getEnd() {
		return end;
	}
	public void setEnd(Vector3 end) {
		this.end = end;
	}

	public double getWidth() {
		return width;
	}

	public void setWidth(double width) {
		this.width = width;
	}

	public double getDepth() {
		return depth;
	}

	public void setDepth(double depth) {
		this.depth = depth;
	}
	
	@Override
	public String toString() {
		return "RainureGcode [tool=" + tool + ", head=" + head + ", start=" + start + ", end=" + end + ", width="
				+ width + ", depth=" + depth + "]";
	}

	public static void main(String[] args) {
		List<RainureGcode> rainures=new ArrayList<RainureGcode>();
		RainureGcode rn=new RainureGcode(new Vector3(0, 580, 0), new Vector3(720, 580, 0), 6, 6);
		rainures.add(rn);
		rn=new RainureGcode(new Vector3(728, 580, 0), new Vector3(1400, 580, 0), 6, 7);
		rainures.add(rn);
		rn=new RainureGcode(new Vector3(1400, 580, 0), new Vector3(1700, 580, 0), 6, 7);
		rainures.add(rn);
		rainures =Util.assembleRainures(rainures, true, true);
		rainures.stream().forEach(r->System.err.println(r.toString()));
	}
}
