package test;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.backends.lwjgl.LwjglAWTCanvas;

import javax.swing.*;

public class LibGdxJFrameMouseExample extends ApplicationAdapter {
    private ShapeRenderer shapeRenderer;
    private float circleX = 200;
    private float circleY = 200;
    private float radius = 50;

    @Override
    public void create() {
        shapeRenderer = new ShapeRenderer();

        // Input handling for mouse movement
        Gdx.input.setInputProcessor(new InputAdapter() {
            @Override
            public boolean mouseMoved(int screenX, int screenY) {
                // Convert LibGDX's Y (origin top-left) to OpenGL Y (origin bottom-left)
                circleX = screenX;
                circleY = Gdx.graphics.getHeight() - screenY;
                return true;
            }
        });
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.3f, 1);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(1, 0, 0, 1);
        shapeRenderer.circle(circleX, circleY, radius);
        shapeRenderer.end();
    }

    @Override
    public void dispose() {
        shapeRenderer.dispose();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("LibGDX + JFrame Mouse Example");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setSize(800, 600);

            // Create LibGDX canvas
            LwjglAWTCanvas canvas = new LwjglAWTCanvas(new LibGdxJFrameMouseExample());
            frame.add(canvas.getCanvas());

            frame.setVisible(true);
        });
    }
}
