package test;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.backends.lwjgl.LwjglAWTCanvas;

import javax.swing.*;

public class LibGdxJFrameDragExample extends ApplicationAdapter {
    private ShapeRenderer shapeRenderer;

    // Circle data
    private float circle1X = 200, circle1Y = 200, radius1 = 50;
    private float circle2X = 500, circle2Y = 300, radius2 = 70;

    // Drag state
    private boolean dragging = false;
    private int selectedCircle = -1; // -1 = none, 1 = circle1, 2 = circle2

    @Override
    public void create() {
        shapeRenderer = new ShapeRenderer();

        Gdx.input.setInputProcessor(new InputAdapter() {
            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                float y = Gdx.graphics.getHeight() - screenY;

                // Check if we clicked inside circle1
                if (isInsideCircle(screenX, y, circle1X, circle1Y, radius1)) {
                    selectedCircle = 1;
                    dragging = true;
                }
                // Check if we clicked inside circle2
                else if (isInsideCircle(screenX, y, circle2X, circle2Y, radius2)) {
                    selectedCircle = 2;
                    dragging = true;
                }
                return true;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
                if (dragging) {
                    float y = Gdx.graphics.getHeight() - screenY;
                    if (selectedCircle == 1) {
                        circle1X = screenX;
                        circle1Y = y;
                    } else if (selectedCircle == 2) {
                        circle2X = screenX;
                        circle2Y = y;
                    }
                }
                return true;
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                dragging = false;
                selectedCircle = -1;
                return true;
            }
        });
    }

    private boolean isInsideCircle(float px, float py, float cx, float cy, float r) {
        float dx = px - cx;
        float dy = py - cy;
        return dx * dx + dy * dy <= r * r;
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.3f, 1);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);

        // Circle 1: red
        shapeRenderer.setColor(1, 0, 0, 1);
        shapeRenderer.circle(circle1X, circle1Y, radius1);

        // Circle 2: green
        shapeRenderer.setColor(0, 1, 0, 1);
        shapeRenderer.circle(circle2X, circle2Y, radius2);

        shapeRenderer.end();
    }

    @Override
    public void dispose() {
        shapeRenderer.dispose();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("LibGDX + JFrame Drag Example");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setSize(800, 600);

            // Create LibGDX canvas
            LwjglAWTCanvas canvas = new LwjglAWTCanvas(new LibGdxJFrameDragExample());
            frame.add(canvas.getCanvas());

            frame.setVisible(true);
        });
    }
}