package test;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.backends.lwjgl.LwjglAWTCanvas;

import java.awt.Canvas;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.*;

public class LibGdGridZoomDragRectangles extends ApplicationAdapter {
    static Canvas lastcanvass=null;
    static int lastwidth,lasthight;
    static float lastzoom= 1.0f; 
    static Vector3 lastcameraposition = new Vector3();
    private ShapeRenderer shapeRenderer;
    private OrthographicCamera camera;
    private final Vector3 tmp = new Vector3();
    private final Vector3 tmp2 = new Vector3();

    // Circles
    private float circle1X = 0, circle1Y = 0, radius1 = 100;
    private float circle2X = 500, circle2Y = 300, radius2 = 70;

    // Drag state
    private boolean draggingCircle = false;
    private int selectedCircle = -1; 
    private float dragOffsetX = 0f, dragOffsetY = 0f;

    // Camera pan state
    private boolean panning = false;
    private int lastPanX, lastPanY;

    // Grid settings
    private float gridSize1m = 1000f; // change for finer/coarser snapping
    private float gridSize = 100f; // change for finer/coarser snapping
    private float gridSize1cm = 10f; // change for finer/coarser snapping

    private boolean snapEnabled = true;

    private boolean cameraInitialized = false;
    
    // UI
    private SpriteBatch batch;
    private BitmapFont font;
    private SpriteBatch batch2;
    
    private Stage stage;
    ScreenViewport screenviewport;
    
    
    private Texture rectTexture,hauttexture;
    // Memory monitor
    private static final Runtime runtime = Runtime.getRuntime();
    
    @Override
    public void resize(int width, int height) {
        if (!cameraInitialized) {

        	
        } else {
            camera.viewportWidth = width;
            camera.viewportHeight = height;
            camera.update();
//            screenviewport.update(width, height);
        }
        camera.zoom = lastzoom;
        camera.position.set(lastcameraposition);
    }
    
    @Override
    public void create() {
        shapeRenderer = new ShapeRenderer();
        rectTexture = new Texture("C:\\ProgramData\\supercad\\pictures\\0b6ede76-e8e7-437c-85ed-5585c8c99d15_1753955410068.jpg"); // ensure asset exists
        hauttexture = new Texture("C:\\ProgramData\\supercad\\pictures2d\\element bas top view.png"); // ensure asset exists

        
        
        if(camera == null) {
            camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            camera.setToOrtho(false);
            camera.update();
            screenviewport = new ScreenViewport(camera) {
                @Override
                public void update(int screenWidth, int screenHeight, boolean centerCamera) {
                    // Empty - preserves zoom/pan state
                    setScreenBounds(0, 0, screenWidth, screenHeight);
                    setWorldSize(screenWidth * 1, screenHeight * 1);
  
                }
            };
            screenviewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        }
        if(stage == null) {
            stage = new Stage(screenviewport) {
            	@Override
            	public boolean mouseMoved(int screenX, int screenY) {
            		// TODO Auto-generated method stub
            		//return super.mouseMoved(screenX, screenY);
            		return true;
            	}
            };
        }
        
        batch = new SpriteBatch();
        font = new BitmapFont();
        batch2 = new SpriteBatch();

        // Create custom rectangle actors (now with camera reference for proper hit detection)
        RectActor rect = new RectActor(500, 650, Color.BLUE, shapeRenderer, camera,hauttexture);
        rect.setPosition(55, 100);
        stage.addActor(rect);
        
        RectActor rect2 = new RectActor(720, 450, Color.RED, shapeRenderer, camera,rectTexture);
        rect2.setPosition(300, 200);
        stage.addActor(rect2);

        RectActor rect3 = new RectActor(18, 620, Color.RED, shapeRenderer, camera,rectTexture);
        rect3.setPosition(80, 90);
        stage.addActor(rect3);
        
        
        // Input multiplexer to handle both stage (rectangle selection) and custom input (pan/zoom/circles)
        InputMultiplexer multiplexer = new InputMultiplexer();
        multiplexer.addProcessor(stage); // Stage handles rectangle input first
        multiplexer.addProcessor(new InputAdapter() {
            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                if (button == Input.Buttons.LEFT) {
                    // Check if we clicked on a circle (only if no rectangle was selected)
                    if (stage.hit(screenX, screenY, true) == null) {
                        tmp.set(screenX, Gdx.graphics.getHeight() - screenY, 0);
                        camera.unproject(tmp);
                        float worldX = tmp.x;
                        float worldY = tmp.y;

                        if (isInsideCircle(worldX, worldY, circle1X, circle1Y, radius1)) {
                            selectedCircle = 1;
                            draggingCircle = true;
                            dragOffsetX = worldX - circle1X;
                            dragOffsetY = worldY - circle1Y;
                            return true;
                        } else if (isInsideCircle(worldX, worldY, circle2X, circle2Y, radius2)) {
                            selectedCircle = 2;
                            draggingCircle = true;
                            dragOffsetX = worldX - circle2X;
                            dragOffsetY = worldY - circle2Y;
                            return true;
                        }
                    }
                } else if (button == Input.Buttons.RIGHT) {
                    panning = true;
                    lastPanX = screenX;
                    lastPanY = screenY;
                    return true;
                }
                return false;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
                if (draggingCircle) {
                    tmp.set(screenX, Gdx.graphics.getHeight() - screenY, 0);
                    camera.unproject(tmp);
                    float worldX = tmp.x;
                    float worldY = tmp.y;

                    if (selectedCircle == 1) {
                        circle1X = snap(worldX - dragOffsetX);
                        circle1Y = snap(worldY - dragOffsetY);
                    } else if (selectedCircle == 2) {
                        circle2X = snap(worldX - dragOffsetX);
                        circle2Y = snap(worldY - dragOffsetY);
                    }
                    return true;
                } else if (panning) {
                    int dx = screenX - lastPanX;
                    int dy = screenY - lastPanY;
                    float newX = camera.position.x - dx * camera.zoom;
                    float newY = camera.position.y + dy * camera.zoom;
                    camera.position.set(snap(newX), snap(newY), 0);
                    camera.update();
                    lastcameraposition = camera.position.cpy();
                    lastPanX = screenX;
                    lastPanY = screenY;
                    return true;
                }
                return false;
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                if (button == Input.Buttons.LEFT) {
                    draggingCircle = false;
                    selectedCircle = -1;
                } else if (button == Input.Buttons.RIGHT) {
                    panning = false;
                }
                return true;
            }

            @Override
            public boolean scrolled(int amount) {
                final float zoomFactor = 1.1f;
                int mx = Gdx.input.getX();
                int my = Gdx.input.getY();
                
                tmp.set(mx, Gdx.graphics.getHeight() - my, 0);
                camera.unproject(tmp);
                float beforeX = tmp.x;
                float beforeY = tmp.y;

                if (amount > 0) {
                    camera.zoom *= zoomFactor;
                } else if (amount < 0) {
                    camera.zoom /= zoomFactor;
                }
                camera.zoom = MathUtils.clamp(camera.zoom, 0.005f, 200f);
                camera.update();
                lastzoom = camera.zoom;
                
                tmp2.set(mx, Gdx.graphics.getHeight() - my, 0);
                camera.unproject(tmp2);
                camera.position.add(beforeX - tmp2.x, beforeY - tmp2.y, 0);
                camera.update();
                lastcameraposition = camera.position.cpy();
                return true;
            }
        });
        
        Gdx.input.setInputProcessor(multiplexer);
    }

    private boolean isInsideCircle(float px, float py, float cx, float cy, float r) {
        float dx = px - cx;
        float dy = py - cy;
        return dx * dx + dy * dy <= r * r;
    }

    private float snap(float value) {
        if (!snapEnabled) return value;
        return Math.round(value / gridSize1cm) * gridSize1cm;
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.3f, 1);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

        camera.update();
        shapeRenderer.setProjectionMatrix(camera.combined);

        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(1, 0, 0, 1);
        shapeRenderer.circle(circle1X, circle1Y, radius1);
        shapeRenderer.setColor(0, 1, 0, 1);
        shapeRenderer.circle(circle2X, circle2Y, radius2);
        shapeRenderer.end();

        drawGrid();
        drawGridMapInfos();
        batch.begin();
        int mx = Gdx.input.getX();
        int my = Gdx.input.getY();
        int modmy= Gdx.graphics.getHeight() - my;
        tmp.set(mx, my, 0);
        
        camera.unproject(tmp);
        float snappedX = snap(tmp.x);
        float snappedY = snap(tmp.y);
        String coords = String.format("X: %.2f  Y: %.2f w:%d h:%d", tmp.x, tmp.y, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        font.draw(batch, coords, 10, 20);
        String rawcoords = String.format("X: %d  Y: %d ", mx, my);
        font.draw(batch, rawcoords, 10, 50);
        batch.end();
        
        batch2.begin();
        font.draw(batch2, getMemoryUsageString(), Gdx.graphics.getWidth()-150, 20);
        batch2.end();
        
        //stage.act(Gdx.graphics.getDeltaTime());
        stage.draw();
    }

    private String getMemoryUsageString() {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        float usedMB = usedMemory / (1024f * 1024f);
        float maxMB = maxMemory / (1024f * 1024f);
        return String.format("Mem: %.1f / %.0f MB", usedMB, maxMB);
    }
    
    private void drawGrid() {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        float left = camera.position.x - camera.viewportWidth * camera.zoom / 2f;
        float right = camera.position.x + camera.viewportWidth * camera.zoom / 2f;
        float bottom = camera.position.y - camera.viewportHeight * camera.zoom / 2f;
        float top = camera.position.y + camera.viewportHeight * camera.zoom / 2f;
        
        // m line
        int xcount=(int) (right/gridSize1m);

        
        //print 1 cm
        if(xcount<=2) {
            shapeRenderer.setColor(0.3f, 0.3f, 0.3f, 1);
            for (float x = 0; x <= right; x += gridSize1cm) {
                shapeRenderer.line(x, 0, x, top);
            }
            for (float y = 0; y <= top; y += gridSize1cm) {
                shapeRenderer.line(0, y, right, y);
            }
        }
        
        //print 10 cm scale
         shapeRenderer.setColor(0.3f, 0.8f, 0.3f, 1);
          for (float x = 0; x <= right; x += gridSize) {
                shapeRenderer.line(x, 0, x, top);
          }
            for (float y = 0; y <= top; y += gridSize) {
                shapeRenderer.line(0, y, right, y);
            }
        
        


        
        

        shapeRenderer.setColor(0.9f, 0.1f, 0.1f, 1);
        for (float x = 0; x <= right; x += gridSize1m) {
            shapeRenderer.line(x, 0, x, top);
            xcount++;
        }
        for (float y = 0; y <= top; y += gridSize1m) {
            shapeRenderer.line(0, y, right, y);
        }
        shapeRenderer.end();
    }

    private void drawGridMapInfos() {
    	batch.begin();
    	
       
        
        float left = camera.position.x - camera.viewportWidth * camera.zoom / 2f;
        float right = camera.position.x + camera.viewportWidth * camera.zoom / 2f;
        float bottom = camera.position.y - camera.viewportHeight * camera.zoom / 2f;
        float top = camera.position.y + camera.viewportHeight * camera.zoom / 2f;
        // m line
        shapeRenderer.setColor(0.9f, 0.1f, 0.1f, 1);
        int repx=0;
        for (float x = 0; x <= right; x += gridSize1m) {
//            shapeRenderer.line(x, 0, x, top);
            String rep = repx<=1?String.format("%d m",repx):String.format("%d",repx);
            tmp.set(x-20, -10, 0);
            
            camera.project(tmp);
            font.draw(batch,rep, tmp.x, tmp.y);
            repx++;
        }
        
        int repy=0;
        for (float y = 0; y <= top; y += gridSize1m) {
//            shapeRenderer.line(0, y, right, y);
        	
            String rep = repx>1?String.format("%d",repy):"";
            tmp.set(-40, y+10, 0);
            
            camera.project(tmp);
            font.draw(batch,rep, tmp.x, tmp.y);
            repy++;
        }
        batch.end();
    }
    @Override
    public void dispose() {
        shapeRenderer.dispose();
        batch.dispose();
        font.dispose();
        stage.dispose();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("LibGDX + JFrame Drag + Zoom + Pan + Snap Grid");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setSize(800, 600);
      
            frame.addComponentListener(new ComponentAdapter() {
                @Override
                public void componentResized(ComponentEvent e) {
                    if(lasthight != frame.getContentPane().getHeight() || lastwidth != frame.getContentPane().getWidth()) {
                        lastwidth = frame.getContentPane().getWidth();
                        lasthight = frame.getContentPane().getHeight();
                        if(lastcanvass != null) {
                            frame.remove(lastcanvass);
                        }
  		                LwjglAWTCanvas canvas = new LwjglAWTCanvas(new LibGdGridZoomDragRectangles());
                        lastcanvass = canvas.getCanvas();
                        frame.add(lastcanvass);
                        frame.validate();
                    }
                }
            });
            frame.setVisible(true);
        });
    }
}

// Enhanced RectangleActor with proper hit detection and dragging using InputListener
class RectActor extends Actor {
    private float width, height;
    private Color color;
    private ShapeRenderer shapeRenderer;
    private OrthographicCamera camera;
    private TextureRegion textureRegion;
    private boolean hasTexture = false;
    
    public RectActor(float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera) {
        this(width, height,color,shapeRenderer,camera, (TextureRegion)null);
    }
    // For textured rectangles
    public RectActor(float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera, Texture texture) {
        this(width, height,color,shapeRenderer,camera, new TextureRegion(texture));
    }

    public RectActor(float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera, TextureRegion textureRegion) {
        this.width = width;
        this.height = height;
        this.color = color;
        this.shapeRenderer = shapeRenderer;
        this.camera = camera;
        if(textureRegion!=null) {
            this.textureRegion = textureRegion;
            this.hasTexture = true;
        }

        setSize(width, height);
        setTouchable(Touchable.enabled); // Enable touch events
        inputListner();
        
    }

    private void inputListner() {
    	// Add InputListener for drag functionality
        addCaptureListener(new InputListener() {
            private float dragOffsetX, dragOffsetY;
            private float cumulx,cumuly;
            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
           
                if (button == Input.Buttons.LEFT) {
//                    System.err.println("Down X:"+x+"Down Y:"+y);
                    dragOffsetX =x;
                    dragOffsetY =y ;  
                    cumulx=0;
                    cumuly=0;
                 	getStage().setKeyboardFocus(RectActor.this);
                    return true;
                }
                return false;
            }
            
            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
//                System.out.println("Drag X:"+x+"drag Y:"+y);
                Vector3 world = new Vector3(x, y, 0);
                cumulx+=world.x;
                cumuly+=world.y;
                setPosition(getX()+world.x-dragOffsetX,getY()+world.y-dragOffsetY);
            }
        });
        addListener(new InputListener() {
        	@Override
        	public boolean keyDown(InputEvent event, int keycode) {
        		if(keycode==Keys.S){
        			setPosition(1000,1000);
        		}
        		return true;
        	}
        });
    }
    public RectActor(float x, float y, float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera) {
        this(width, height, color, shapeRenderer, camera);
        setPosition(x, y);
    }

    @Override
    public void draw(com.badlogic.gdx.graphics.g2d.Batch batch, float parentAlpha) {
        batch.end();
        
        Color c = getColor();

        shapeRenderer.setColor(c.r, c.g, c.b, c.a * parentAlpha);
        shapeRenderer.setProjectionMatrix(camera.combined);
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.rect(getX(), getY(), getWidth(), getHeight());
        shapeRenderer.end();
       
        
        if (hasTexture && textureRegion != null) {
        	batch.begin();
            // Draw texture
        	float fitin = 0;//5 mm fit in
            batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
            batch.draw(textureRegion, getX()+fitin, getY()+fitin, getWidth()-2*fitin, getHeight()-2*fitin);
            batch.setColor(Color.WHITE); // reset
            batch.end();
        }
        


        
        shapeRenderer.setColor(0, 0, 0, 0);
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.rect(getX(), getY(), getWidth(), getHeight());
        shapeRenderer.end();
        batch.begin();
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (!touchable) return null;
        float absx = x + getX();
        float absy = y + getY();
        Vector3 world = new Vector3(absx, absy, 0);
//        System.err.println("Hit check X:"+absx+" Y:"+absy);

        // Check if world point is inside this rectangle
        if (world.x >= getX() && world.x <= getX() + getWidth() &&
            world.y >= getY() && world.y <= getY() + getHeight()) {
//            System.err.println("Hit Match !!!  X:"+absx+" Y:"+absy);
            return this;
        }
        return null;
    }
}