package test;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglAWTCanvas;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;

public class GridCircleApp2 extends ApplicationAdapter {
    private static final int GRID_WIDTH = 10;
    private static final int GRID_HEIGHT = 10;
    private static final float CELL_SIZE = 50f;
    
    private ShapeRenderer shapeRenderer;
    private Vector2 circle1;
    private Vector2 circle2;
    
    @Override
    public void create() {
        shapeRenderer = new ShapeRenderer();
        
        // Initialize circles at grid positions (2,2) and (7,7)
        circle1 = new Vector2(2, 2);
        circle2 = new Vector2(7, 7);
    }
    
    @Override
    public void render() {
        handleInput();
        draw();
    }
    
    private void handleInput() {
        float speed = 1f; // Grid units per second
        
        // Circle 1 controls (WASD)
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.W)) circle1.y += speed * Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.S)) circle1.y -= speed * Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.A)) circle1.x -= speed * Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.D)) circle1.x += speed * Gdx.graphics.getDeltaTime();
        
        // Circle 2 controls (Arrow keys)
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.UP)) circle2.y += speed * Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.DOWN)) circle2.y -= speed * Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.LEFT)) circle2.x -= speed * Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(com.badlogic.gdx.Input.Keys.RIGHT)) circle2.x += speed * Gdx.graphics.getDeltaTime();
        
        // Keep circles within grid bounds
        circle1.x = Math.max(0, Math.min(GRID_WIDTH - 1, circle1.x));
        circle1.y = Math.max(0, Math.min(GRID_HEIGHT - 1, circle1.y));
        circle2.x = Math.max(0, Math.min(GRID_WIDTH - 1, circle2.x));
        circle2.y = Math.max(0, Math.min(GRID_HEIGHT - 1, circle2.y));
    }
    
    private void draw() {
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.1f, 1);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);
        
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        
        // Draw grid
        shapeRenderer.setColor(Color.LIGHT_GRAY);
        for (int x = 0; x <= GRID_WIDTH; x++) {
            shapeRenderer.rectLine(x * CELL_SIZE, 0, x * CELL_SIZE, GRID_HEIGHT * CELL_SIZE, 1f);
        }
        for (int y = 0; y <= GRID_HEIGHT; y++) {
            shapeRenderer.rectLine(0, y * CELL_SIZE, GRID_WIDTH * CELL_SIZE, y * CELL_SIZE, 1f);
        }
        
        // Draw circles
        shapeRenderer.setColor(Color.BLUE);
        shapeRenderer.circle(
            (circle1.x + 0.5f) * CELL_SIZE, 
            (circle1.y + 0.5f) * CELL_SIZE, 
            CELL_SIZE * 0.4f
        );
        
        shapeRenderer.setColor(Color.RED);
        shapeRenderer.circle(
            (circle2.x + 0.5f) * CELL_SIZE, 
            (circle2.y + 0.5f) * CELL_SIZE, 
            CELL_SIZE * 0.4f
        );
        
        shapeRenderer.end();
    }
    
    @Override
    public void dispose() {
        shapeRenderer.dispose();
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("LibGDX + JFrame + Grid + Hint");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setSize(800, 600);

            LwjglAWTCanvas canvas = new LwjglAWTCanvas(new GridCircleApp2());
            frame.add(canvas.getCanvas());

//            frame.addComponentListener(new ComponentAdapter() {
//                @Override
//                public void componentResized(ComponentEvent e) {
//                    int newWidth = frame.getContentPane().getWidth();
//                    int newHeight = frame.getContentPane().getHeight();
//
//                    canvas.getCanvas().setSize(newWidth, newHeight); // adjust canvas size
//                    canvas.getApplicationListener().resize(newWidth, newHeight); // notify LibGDX
//                }
//            });
            frame.setVisible(true);
        });
    }
}