package gdxapp.screens.room;

import java.awt.Canvas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;

import dressing.events.Event;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.Intervale;
import dressing.model.ProjectManager;
import dressing.ui.ChangeCommandController;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ActionProcessor;
import gdxapp.Commun.AltitudeSorter;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.Measure;
import gdxapp.Commun.Preferences;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.DrawingHelper;
import gdxapp.fabs3d.WoodCovering;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.GeometryObject2D;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Plinth;
import gdxapp.object3d.PlinthObject;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.quotation.Quotation;
import gdxapp.quotation.QuotationSorter;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.wall.Wall2D;
import gdxapp.screens.wall.WallFragment;
import gdxapp.shapes.FlecheSegment;
import gdxapp.shapes.LineSegment;
import gdxapp.shapes.ShapeType;
import gdxapp.ui.ActionItem;
import gdxapp.ui.Note;
import gdxapp.ui.ObjectMenuList;
import geometry.Arc;
import geometry.CompoundShape;
import geometry.Polygon;
import geometry.PolygonDrawer;
import geometry.Shape;
import reporting.htmlReporting.ElementReport;

public class RoomController implements ScreenController<Object2D> {

	public static final String TOP_VIEW = "TOP_VIEW";
	private static final String TAG = RoomController.class.getName();
	
	public Stage stage;
	public Stage uiStage;
	Image background;
	private final ArrayList<Actor> actors = new ArrayList<Actor>();
	public Polygon polygon;
	Table backgroundLayer = new Table();
	public Table controlLayer = new Table();
	Stack stack = new Stack();
	public InputMultiplexer inputMultiplexer;
	public static boolean refresh;
	public static Object2D selectedActor;
	public static boolean synchronize;
	private static RoomController instance;
	public ChangeCommandController changeCommandController = new ChangeCommandController();
	public ArrayList<Quotation> quotations;
	private Surface selectedSurface;
	private static PolygonSpriteBatch polyBatch;
	private ArrayList<Edge> edges = new ArrayList<Edge>();
	private ArrayList<Vector2> criticalPoints;
	
	private Matrix4 sceneToWorldTransform ;
	private Matrix4 worldToSceneTransform;
	private ArrayList<Shape> wallsSurfaces;
	private HashMap<GeometryObject2D, Object2D> marbleExtrusions;
	
	private Wall2D editedWall;
	private boolean handle;

	// ui properties
	private Skin skin;

	
	    static Canvas lastcanvass=null;
	    static int lastwidth,lasthight;
	    static float lastzoom= 1.0f; 
	    static Vector3 lastcameraposition = new Vector3();
	    private ShapeRenderer shapeRenderer;
	    private OrthographicCamera camera;
	    private final Vector3 tmp = new Vector3();
	    private final Vector3 tmp2 = new Vector3();

	    // Circles
	    private float circle1X = 0, circle1Y = 0, radius1 = 10;

	    // Drag state
	    private float dragOffsetX = 0f, dragOffsetY = 0f;

	    // Camera pan state
	    private boolean panning = false;
	    private int lastPanX, lastPanY;
	    // Grid settings
	    // Grid settings
	    private float gridSize1m = 1000f; // change for finer/coarser snapping
	    private float gridSize = 100f; // change for finer/coarser snapping
	    private float gridSize1cm = 10f; // change for finer/coarser snapping
	    private boolean snapEnabled = true;

	    // UI
	    private SpriteBatch custombatch;
	    private BitmapFont font;
	    private SpriteBatch batch2;
	    
	    ScreenViewport screenviewport ;
	    Stage tempstage;
	    // Memory monitor
	    private static final Runtime runtime = Runtime.getRuntime();
	    
	public RoomController() {
		init();
	}

	public static RoomController getInstance() {
		synchronized (RoomController.class) {
			if (instance == null) {
				instance = new RoomController();
			}
			return instance;
		}
	}
	public ShapeRenderer getShapeRenderer() {
		return shapeRenderer;
	}
	public void calculateSceneToWorldTranform() {
		float scaleX = 1000f;//1 m in 3d equivalent 1000mm in 2d
		float scaleY = 1000f;
		Vector3 sx = new Vector3(1.0f / scaleX, 0, 0);
		Vector3 sy = new Vector3(0.0f, 1.0f / scaleY, 0.0f);
		Vector3 sz = new Vector3(0.0f, 0.0f, 1.0f);
		Matrix4 scaleM = new Matrix4(
				new float[] { sx.x, sx.y, sx.z, 0, sy.x, sy.y, sy.z, 0, sz.x, sz.y, sz.z, 0, 0, 0, 0, 1 });
		Matrix4 rotationM = new Matrix4(new float[] { 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 1 }).tra();
		this.sceneToWorldTransform = rotationM.mul(scaleM);
		this.worldToSceneTransform = this.sceneToWorldTransform.cpy().inv();
		
		// Create transform: 2D top view (XY) → 3D world (XZ plane)
//		this.sceneToWorldTransform = new Matrix4()
//		    .setToRotation(Vector3.X, -90) // rotate the 2D XY plane to lie on XZ
//		    .trn(0, 0, 0);                 // optional translation (e.g. ground height)
//
//		this.worldToSceneTransform = this.sceneToWorldTransform.cpy().inv();
	}

	public Matrix4 getSceneToWorldTransform() {
//		if (sceneToWorldTransform == null)
//			calculateSceneToWorldTranform();
//		return sceneToWorldTransform.cpy();
//		return new Matrix4();
		
		if (sceneToWorldTransform == null)
		calculateSceneToWorldTranform();
		return sceneToWorldTransform.cpy();
	}

	public Matrix4 getWorldToSceneTransform() {
//		if (worldToSceneTransform == null)
//			calculateSceneToWorldTranform();
//		return worldToSceneTransform.cpy();
//		return new Matrix4();
		
		if (worldToSceneTransform == null)
		calculateSceneToWorldTranform();
		return worldToSceneTransform.cpy();

	}

	void init() {    
		shapeRenderer = new ShapeRenderer();
        if(camera==null) {
            camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            camera.setToOrtho(false);
            camera.update();
            screenviewport =new ScreenViewport(camera) {
            	@Override
            	public void update(int screenWidth, int screenHeight, boolean centerCamera) {
            		// TODO Auto-generated method stub
            		//super.update(screenWidth, screenHeight, centerCamera);
            		  // Set screen bounds so isInsideViewport() works correctly
                    setScreenBounds(0, 0, screenWidth, screenHeight);
            	}
            };
            screenviewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
          
 
        }
        if(stage==null) {
        	  //Initialize stage with screen viewport
            stage = new Stage(screenviewport);
//    		uiStage = new Stage(screenviewport);
    		tempstage= new Stage(screenviewport);
//            stage = new Stage(new ScreenViewport());
    		uiStage = new Stage(new ScreenViewport());
        }
        
        custombatch = new SpriteBatch();
        font = new BitmapFont();
        batch2 = new SpriteBatch();

        
        //Input multiplexer to handle both stage (rectangle selection) and custom input (pan/zoom/circles)
        inputMultiplexer = new InputMultiplexer();
//        inputMultiplexer.addProcessor(tempstage); // Stage handles rectangle input first
        inputMultiplexer.addProcessor(uiStage); // Stage handles rectangle input first
        inputMultiplexer.addProcessor(stage); // Stage handles rectangle input first
        inputMultiplexer.addProcessor(new ActionController());
        inputMultiplexer.addProcessor(new InputAdapter() {
            @Override
            public boolean keyDown(int keycode) {
            	if(Gdx.input.isKeyPressed(Input.Keys.MINUS)){
            		zommInOut(-1);
            	}else if(Gdx.input.isKeyPressed(Input.Keys.PLUS)){
            		zommInOut(1);
            	}
            	return false;
            }
            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                if (button == Input.Buttons.RIGHT) {
                    panning = true;
                    lastPanX = screenX;
                    lastPanY = screenY;
                    return false;
                }
                return false;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
            	if (panning) {
                    int dx = screenX - lastPanX;
                    int dy = screenY - lastPanY;
                    float newX = camera.position.x - dx * camera.zoom;
                    float newY = camera.position.y + dy * camera.zoom;
                    camera.position.set(snap(newX), snap(newY), 0);
                    camera.update();
                    lastcameraposition = camera.position.cpy();
                    lastPanX = screenX;
                    lastPanY = screenY;
                    return false;
                }
                return false;
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                if (button == Input.Buttons.LEFT) {
                } else if (button == Input.Buttons.RIGHT) {
                    panning = false;
                }
                return false;
            }

            @Override
            public boolean scrolled(int amount) {
            	zommInOut(amount);
                return false;
            }
      
        
        
        });

        Gdx.input.setInputProcessor(inputMultiplexer);
        
        
        // Create custom rectangle actors (now with camera reference for proper hit detection)
//        RectActor rect = new RectActor(500, 650, Color.BLUE, shapeRenderer, camera,hauttexture);
//        rect.setPosition(55, 100);
//        tempstage.addActor(rect);
//        
//        RectActor rect2 = new RectActor(720, 450, Color.RED, shapeRenderer, camera,rectTexture);
//        rect2.setPosition(300, 200);
//        tempstage.addActor(rect2);
//
//        RectActor rect3 = new RectActor(18, 620, Color.RED, shapeRenderer, camera,rectTexture);
//        rect3.setPosition(80, 90);
//        tempstage.addActor(rect3);
//        
        
//		inputMultiplexer = new InputMultiplexer();
//		inputMultiplexer.addProcessor(uiStage);
//		inputMultiplexer.addProcessor(stage);
//		inputMultiplexer.addProcessor(new ActionController());
//		Gdx.input.setInputProcessor(inputMultiplexer);
		buildStage();
		subscribe(SceneEvent.DELETE_OBJECT.name(), SceneEvent.DISPLAY_ACTIONS_MENU.name(),
				SceneEvent.VOID_CLICK.name(), SceneEvent.OBJECT_SELECTED.name(),
				SceneEvent.EDIT_OBJECT.name(), SceneEvent.SHOW_OBJECT.name(),
				SceneEvent.HIDE_OBJECT.name(), SceneEvent.GENERATE_REPORT.name(),
				SceneEvent.OBJECT_CHANGED.name());
	}

	
	public void buildStage() {
//		rebuildBackgroundLayer();
		stage.clear();
		stage.addActor(stack);
		stack.setFillParent(true);
		stack.add(backgroundLayer);
	}

	private void rebuildBackgroundLayer() {
		backgroundLayer.clearChildren();
		if (background == null) {
			Pixmap pixmap = DrawingHelper.createBackgroundPixmap(Math.round(stage.getWidth()),
					Math.round(stage.getHeight()), 1, 0.1f);
			Texture texture = new Texture(pixmap);
			pixmap.dispose();
			background = new Image(texture);
			background.addListener(new InputListener() {
				@Override
				public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
					GroupSelection.getInstance().clearSelection();
					stage.setScrollFocus(null);
					stage.setKeyboardFocus(null);
					return false;
				}
			});
		}

		backgroundLayer.add(background).grow();
	}

	// creating and update functions

	@Override
	public void dropActor(Object actor, float x, float y) {
//		Vector2 location = MathUtilities.screenToStageCoords(this.stage, x, Gdx.graphics.getHeight() - y);
//		float XCenter=this.stage.getWidth()/2;
//		float YCenter=this.stage.getHeight()/2;
//		Vector3 cameraPosition=this.stage.getCamera().position;
////		location.x=location.x - (XCenter-cameraPosition.x);
//		location.y=location.y - (YCenter-cameraPosition.y);
		Vector2 location = new Vector2(x, y);
		if (actor instanceof WorldObject) {
			ProjectManager.getManager().getCurrentScene().addActor((WorldObject) actor, false);
			Object2D object2d = ((WorldObject) actor).create2DObject();
			object2d.adjustTextureAndColors();
			object2d.setPosition(location.x, location.y);
			updateObject2D(object2d);
			stage.addActor(object2d);
			stage.getActors().sort(AltitudeSorter.getSorter());
			actors.add(object2d);
		}
	}

	public void resizeStage() {
		calculateSceneToWorldTranform();
//		rebuildBackgroundLayer();
		adaptObjectsToStage();
	}

	@Override
	public void reloadActors() {
		if (this.marbleExtrusions != null)
			this.marbleExtrusions.clear();
		removeDeletedActors();
		ArrayList<WorldObject> erronousObjects = new ArrayList<WorldObject>();
		for (WorldObject wObject : ProjectManager.getManager().getCurrentScene().getSceneObjects()) {
			Actor actor = (Actor) getObject(wObject);
			if (actor == null) {
				actor = wObject.create2DObject();
				addActor(actor);
				try {
					((Object2D)actor).adjustTextureAndColors();

				}catch (Exception e) {
					e.printStackTrace();
					System.out.println("deleting object " + ((Object2D)actor).getWorldObject());
					erronousObjects.add(wObject);
					continue;
				}
				actors.add(actor);
				addObject2D(actor);
				stage.addActor(actor);

			} else {
				if (!stage.getActors().contains(actor, true)) {
					stage.addActor(actor);
				}
			}
		}
		for(WorldObject erronous: erronousObjects) {
			ProjectManager.getManager().getCurrentScene().removeWorldObject(erronous);
		}
		adaptObjectsToStage();
		stage.getActors().sort(AltitudeSorter.getSorter());
		for (Note note : ProjectManager.instance.getCurrentScene().getNotes()) {
			if (note.getContext() == null && !stage.getActors().contains(note, true)) {
				stage.addActor(note);
			}
		}
		for (Measure measure : ProjectManager.instance.getCurrentScene().getMeasures()) {
			if (measure.getContext() == null && !stage.getActors().contains(measure.getLineSegment(), true)) {
				stage.addActor(measure.getLineSegment());
			}
		}
		for (Fleche fleche : ProjectManager.instance.getCurrentScene().getFleches()) {
			if (fleche.getContext() == null && !stage.getActors().contains(fleche.getFlecheSegment(), true)) {
				stage.addActor(fleche.getFlecheSegment());
			}
		}
		calculateCriticalPoints();
	}

	private void addObject2D(Actor actor) {
		actors.add(actor);
		stage.addActor(actor);
		if(actor instanceof Wall2D) {
			if(this.wallsSurfaces == null)
				this.wallsSurfaces = new ArrayList<Shape>();
			this.wallsSurfaces.addAll(((Wall2D)actor).getSides());
		}
	}

	public void adaptObjectsToStage() {
		for (int i = 0; i < stage.getActors().size; i++) {
			Actor actor = stage.getActors().get(i);
			if (actor instanceof Object2D) {
				updateObject2D((Object2D) actor);
				((Object2D) actor).setTopView(true);
				((Object2D) actor).calculateRotatedVertices();
			}
		}
	}

	public void updateWorldObject(Object2D object2d) {
		Vector3 position = new Vector3();
		position.x = (object2d.getX()) + 0.5f * object2d.getWidth();
		position.y = (object2d.getY() + 0.5f* object2d.getHeight());
		if (object2d.getWorldObject().getRealWorldPosition() == null) {
			position.z = 0.5f*object2d.getWorldObject().getRealWorldDimension().y;
		} else {
			position.z = object2d.getWorldObject().getRealWorldPosition().y;
		}
		Matrix4 transform = getSceneToWorldTransform();
		Vector3 realpos = position.mul(transform);
		object2d.getWorldObject().setRealWorldPosition(realpos);
	}
	private void updateKitchenElement(KitchenElement element) {
		Object2D object2D = (Object2D) getObject(element);
		if(object2D != null) {
			Vector4 realDim = object2D.getWorldObject().getRealWorldDimension();
			float width = getScaleX() * object2D.getWorldObject().getRealWorldDimension().x;
			float height = realDim.w > 0.001f? realDim.w:realDim.z;
			height *= getScaleY();
			object2D.setWidth(width);
			object2D.setHeight(height);
			if (element.getRealWorldPosition() != null) {
				Matrix4 worldToStageTransform = getWorldToSceneTransform();
				Vector3 pos = object2D.getWorldObject().getRealWorldPosition().cpy().mul(worldToStageTransform);
				pos.x -= width / 2.f;
				pos.y -= height / 2.f;
				object2D.setPosition(pos.x, pos.y);
			}
			object2D.setOrigin(width / 2.0f, height / 2.0f);
			object2D.setRotation(object2D.getWorldObject().getRotation());
		}
	};
	private void updateWall(Wall wall) {
		Wall2D wall2D = (Wall2D) getActor(wall);
		if(wall2D != null) {
			wall2D.geometryChanged();
			wall2D.setVisible(true);
			calculateWallSurfaces();
		}
	};

	private void updateGeometryObject(GeometryObject geometryObject) {
		GeometryObject2D geometryObject2D = (GeometryObject2D) getActor(geometryObject);
		if(geometryObject2D != null) {
			geometryObject2D.geometryChanged();
			geometryObject2D.setVisible(true);
			calculateWallSurfaces();
		}
	}

	private void updatePlinth(PlinthObject plinth) {
		Plinth geometryObject2D = (Plinth) getActor(plinth);
		if(geometryObject2D != null) {
			geometryObject2D.geometryChanged();
			geometryObject2D.setVisible(true);
		}
	}

	private void updateWoodCovering(WoodCovering covering) {
		
	}

	public void updateObject2D(Object2D object2D) {
		float width = getScaleX() * object2D.getWorldObject().getRealWorldDimension().x;
		float height = getScaleY() * object2D.getWorldObject().getRealWorldDimension().z;
		if (object2D.getWorldObject() instanceof KitchenElement) {
			KitchenElement kitchenElement = (KitchenElement) object2D.getWorldObject();
			if (kitchenElement.getDesignObject() != null
					&& kitchenElement.getDesignObject().getDesignCaissonType().contains("COINS_L")) {
				try {
					String largeur = kitchenElement.getMechanicDesign().getPublicParam("global.largeur")
							.getDefaultvalue();
					height = Float.parseFloat(largeur) * 0.001f * getScaleX();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		object2D.setWidth(width);
		object2D.setHeight(height);
		if (object2D.getWorldObject().getRealWorldPosition() != null) {
			Matrix4 worldToStageTransform = getWorldToSceneTransform();
			Vector3 pos = object2D.getWorldObject().getRealWorldPosition().cpy().mul(worldToStageTransform);
			pos.x -= width / 2.f;
			pos.y -= height / 2.f;
			object2D.setPosition(pos.x, pos.y);
		}
		object2D.setOrigin(width / 2.0f, height / 2.0f);
		object2D.setRotation(object2D.getWorldObject().getRotation());
		object2D.firePropertyChange("position", 2, 1);
	}
	
	
	
	@Override
	public void updateObject(WorldObject object) {
		if(object == null) {
			try {
				object.getRealWorldPosition();
			}catch (NullPointerException e) {
				MessageDialog.openError(Display.getDefault().getActiveShell(), "Erreur", "erreur lors de modification de l'objet!");
				System.err.println("attempt to update null object!");
				e.printStackTrace();
				return;
			}
		}
		if (object instanceof KitchenElement) {
			updateKitchenElement((KitchenElement) object);
		} else if (object instanceof Wall) {
			updateWall((Wall) object);
		} else if (object instanceof PlinthObject) {
			updatePlinth((PlinthObject) object);
		} else if (object instanceof GeometryObject) {
			updateGeometryObject((GeometryObject) object);
		} else if (object instanceof WoodCovering) {

		} else {
			updateObject2D( getObject(object));
		}
	}
		
	


	public void resolveMarbleExtrusion() {
		if (this.marbleExtrusions == null) {
			this.marbleExtrusions = new HashMap<GeometryObject2D, Object2D>();
		}
		// clear no longer valid extrusion
		ArrayList<GeometryObject2D> marbleToRemove = new ArrayList<>();
		for (GeometryObject2D marble : marbleExtrusions.keySet()) {
			if (!marble.contains(marbleExtrusions.get(marble))) {
				marbleToRemove.add(marble);
				marble.getGeometryObject().getGeometry().getExtrusion().getNodes().clear();
			}
		}
		for (GeometryObject2D marble : marbleToRemove) {
			marbleExtrusions.remove(marble);
			marble.calculateVerticesData();
			marble.getGeometryObject().setRequireRefrech(true);
		}
		ArrayList<GeometryObject2D> geometries = getGeometries();
		for (GeometryObject2D geometry : geometries) {
			for (Actor actor : stage.getActors()) {
				if (geometries.contains(actor))
					continue;
				if (actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					var isExtrusionMaker = object2D.getWorldObject().getProperties()
							.getOrDefault("is_extrusin_maker", false);
					boolean extrusionMaker = false;
					if(isExtrusionMaker instanceof String) {
						extrusionMaker = Boolean.parseBoolean((String) isExtrusionMaker);
					}else {
						extrusionMaker = (boolean) isExtrusionMaker;
					}
					
					if (geometry.contains(object2D) && extrusionMaker)
						makeExtrusion(geometry, object2D);
				}
			}
		}
	}

	private void makeExtrusion(GeometryObject2D geometry, Object2D object2d) {
		CompoundShape extrusion = new CompoundShape();
		ArrayList<Vector2> extrusionVertices = new ArrayList<Vector2>();
		for (int i = 0; i < object2d.getRotatedVertices().size(); i++) {
			extrusionVertices.add(new Vector2(object2d.getRotatedVertices().get(i)));
		}
		Polygon polygon = new Polygon();
		polygon.setVertices(extrusionVertices);
		extrusion.addNode(polygon);
		geometry.getGeometryObject().getGeometry().setExtrusion(extrusion);
		geometry.getGeometryObject().getGeometry().setPerfored(true);
		geometry.getGeometryObject().setRequireRefrech(true);
		this.marbleExtrusions.put(geometry, object2d);
	}

	public void clearActors() {
		Array<Actor> actors = new Array<>();
		actors.addAll(getUIStage().getActors());
		for (Actor actor : actors) {
			if (actor instanceof Object2D || actor instanceof Note || actor instanceof LineSegment
					|| actor instanceof FlecheSegment || actor instanceof Wall2D) {
				actor.remove();
			}
		}
		actors = null;
	}

	public void removeDeletedActors() {
		ArrayList<Actor> garbage = new ArrayList<Actor>();
		boolean recalculateSurfaces = false;
		for (Actor actor : actors) {
			if (actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				if (!ProjectManager.getManager().getCurrentScene().getSceneObjects().contains(object2D.getWorldObject())) {
					object2D.remove();
					((Object2D) actor).dispose();
					garbage.add(actor);
				}
			}
			if (actor instanceof Plinth) {
				Plinth object2D = (Plinth) actor;
				if (!ProjectManager.getManager().getCurrentScene().getSceneObjects()
						.contains(object2D.getPlinthObject())) {
					object2D.remove();
					garbage.add(actor);
				}
			}
			if (actor instanceof Wall2D) {
				Wall2D object2D = (Wall2D) actor;
				if (!ProjectManager.getManager().getCurrentScene().getSceneObjects().contains(object2D.getWorldObject())) {
					object2D.remove();
					garbage.add(actor);
					recalculateSurfaces = true;
				}
			}
		}
		for (Actor actor : garbage) {
			actors.remove(actor);
		}
		if(recalculateSurfaces)
			calculateWallSurfaces();
	}

	public void updateActorsRealWorldPosition() {
		for (Actor actor : getStage().getActors()) {
			if (actor instanceof Object2D) {
				updateWorldObject((Object2D) actor);
			}
		}
	}

	// rendering functions
	public void createQuotations() {
		if (this.quotations == null)
			this.quotations = new ArrayList<Quotation>();
		quotations.clear();
		Array<Actor> actors = new Array<Actor>();
		actors.addAll(stage.getActors());
		for (Actor actor : actors) {
			if (actor instanceof Object2D) {
				Object2D object2d = (Object2D) actor;
				if ((object2d.getWorldObject() instanceof Wall
						|| object2d.getWorldObject().getType().equals(ObjectType.MODELED))
						&& (object2d.getWorldObject().isDrawOuterQuotation()
								|| ActionProcessor.isShowOuterQuotations())) {
					ArrayList<Quotation> quots = object2d.getQuotations();
					if (quots.size()==1|| quots.get(0).getLength() > quots.get(1).getLength()) {
						quotations.add(quots.get(0));
					} else {
						quotations.add(quots.get(1));
					}
				}
			}
			if (actor instanceof Wall2D && ActionProcessor.isShowOuterQuotations()) {
				quotations.addAll(((Wall2D) actor).getQuotations());
			}
		}
		QuotationSorter.getInstance().setQuotations(quotations);
	}

	public void drawCriticalPoints() {
		calculateCriticalPoints();
		DrawingHelper.getDebugRenderer().begin(com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType.Filled);
		DrawingHelper.getDebugRenderer().setColor(Color.GOLD);
		for (Vector2 point : criticalPoints) {
			DrawingHelper.getDebugRenderer().circle(point.x, point.y, 3);
		}
		DrawingHelper.getDebugRenderer().setColor(Color.BLACK);
		DrawingHelper.getDebugRenderer().end();
	}

    private float snap(float value) {
        if (!snapEnabled) return value;
        return Math.round(value / gridSize1cm) * gridSize1cm;
    }
    public  void drawGrid() {
    	 shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
         float left = camera.position.x - camera.viewportWidth * camera.zoom / 2f;
         float right = camera.position.x + camera.viewportWidth * camera.zoom / 2f;
         float bottom = camera.position.y - camera.viewportHeight * camera.zoom / 2f;
         float top = camera.position.y + camera.viewportHeight * camera.zoom / 2f;
         
         // m line
         int xcount=(int) (right/gridSize1m);

         
         //print 1 cm
         if(xcount<=2) {
             shapeRenderer.setColor(0.3f, 0.3f, 0.3f, 1);
             for (float x = 0; x <= right; x += gridSize1cm) {
                 shapeRenderer.line(x, 0, x, top);
             }
             for (float y = 0; y <= top; y += gridSize1cm) {
                 shapeRenderer.line(0, y, right, y);
             }
         }
         
         //print 10 cm scale
          shapeRenderer.setColor(0.3f, 0.2f, 0.8f, 1);
           for (float x = 0; x <= right; x += gridSize) {
                 shapeRenderer.line(x, 0, x, top);
           }
             for (float y = 0; y <= top; y += gridSize) {
                 shapeRenderer.line(0, y, right, y);
             }
         
         


         
         

         shapeRenderer.setColor(0.9f, 0.1f, 0.1f, 1);
         for (float x = 0; x <= right; x += gridSize1m) {
             shapeRenderer.line(x, 0, x, top);
             xcount++;
         }
         for (float y = 0; y <= top; y += gridSize1m) {
             shapeRenderer.line(0, y, right, y);
         }
         shapeRenderer.end();
         
         
    }
    public void handleCameraInput() {
        float speed = 2000 * Gdx.graphics.getDeltaTime(); // frame-rate independent
        float move = speed * camera.zoom;

        if (Gdx.input.isKeyPressed(Input.Keys.Z)) {
            camera.position.y += move;
        } else if (Gdx.input.isKeyPressed(Input.Keys.S)) {
            camera.position.y -= move;
        }

        if (Gdx.input.isKeyPressed(Input.Keys.Q)) {
            camera.position.x -= move;
        } else if (Gdx.input.isKeyPressed(Input.Keys.D)) {
            camera.position.x += move;
        }

        camera.update();
    }
    
    public void handleZoom() {
        float amount = 10 * Gdx.graphics.getDeltaTime(); // frame-rate independent
        if (Gdx.input.isKeyPressed(Input.Keys.MINUS)) {
        	zommInOut(-1*amount);
        } else if (Gdx.input.isKeyPressed(Input.Keys.PLUS)) {
        	zommInOut(amount);
        }
    }
    public void zommInOut(float amount) {
    	final float zoomFactor = 1.1f;
        int mx = Gdx.input.getX();
        int my = Gdx.input.getY();
        
//        tmp.set(mx, Gdx.graphics.getHeight() - my, 0);
        tmp.set(mx, my, 0);
        camera.unproject(tmp);
        float beforeX = tmp.x;
        float beforeY = tmp.y;

        if (amount > 0) {
            camera.zoom *= zoomFactor;
        } else if (amount < 0) {
            camera.zoom /= zoomFactor;
        }
        camera.zoom = MathUtils.clamp(camera.zoom, 0.005f, 200f);
        camera.update();
        lastzoom = camera.zoom;
//        tmp2.set(mx, Gdx.graphics.getHeight() - my, 0);
//        camera.unproject(tmp2);
//        camera.position.add(beforeX - tmp2.x, beforeY - tmp2.y, 0);
//        camera.update();
//        lastcameraposition = camera.position.cpy();
    }
    
    public void zommInOutCSSS(float amount) {
        final float zoomStep = 1.1f;

        int mx = Gdx.input.getX();
        int my = Gdx.input.getY();

        // Convert mouse position to world coords
        tmp.set(mx, Gdx.graphics.getHeight() - my, 0);
        camera.unproject(tmp);
        Vector2 cursorWorld = new Vector2(tmp.x, tmp.y);

        // Save old zoom
        float oldZoom = camera.zoom;

        // Change zoom
        if (amount > 0) {
            camera.zoom *= zoomStep;  // Zoom out
        } else if (amount < 0) {
            camera.zoom /= zoomStep;  // Zoom in
        }

        camera.zoom = MathUtils.clamp(camera.zoom, 0.005f, 200f);

        // Compute zoom delta
        float zoomChange = camera.zoom - oldZoom;

        // Direction vector from camera center to cursor
        Vector2 camPos = new Vector2(camera.position.x, camera.position.y);
        Vector2 dir = cursorWorld.cpy().sub(camPos);

        // Normalize direction and scale movement proportionally
        float moveFactor = (amount < 0 ? 0.5f : -0.5f) * zoomChange / oldZoom; 
        camera.position.add(new Vector3(dir.scl(moveFactor),0));

        camera.update();
        lastzoom = camera.zoom;
        lastcameraposition = camera.position.cpy();
    }
	public void ajustcamera() {
        camera.update();
        shapeRenderer.setProjectionMatrix(camera.combined);

        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(1, 0, 0, 1);
        shapeRenderer.circle(circle1X, circle1Y, radius1);
        shapeRenderer.end();
		
	}
	
	public void drawMapInfos() {
		    drawGridMapInfos();
		    custombatch.begin();
	        int mx = Gdx.input.getX();
	        int my = Gdx.input.getY();
	        int modmy= Gdx.graphics.getHeight() - my;
	        tmp.set(mx, my, 0);
	        
	        camera.unproject(tmp);
	        font.setColor(Color.BLACK);
	        float snappedX = snap(tmp.x);
	        float snappedY = snap(tmp.y);
	        String coords = String.format("X: %.2f  Y: %.2f w:%d h:%d", tmp.x, tmp.y, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
	        font.draw(custombatch, coords, 50, 50);

	        String rawcoords = String.format("X: %d  Y: %d ", mx, my);
	        font.draw(custombatch, rawcoords, 40,80);
	        custombatch.end();
	        
	        batch2.begin();
	        font.draw(batch2, getMemoryUsageString(),  Gdx.graphics.getWidth()-200,  20);
	        batch2.end();
	        
	        //stage.act(Gdx.graphics.getDeltaTime());
	        tempstage.draw();
	}
    private String getMemoryUsageString() {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        float usedMB = usedMemory / (1024f * 1024f);
        float maxMB = maxMemory / (1024f * 1024f);
        return String.format("Mem: %.1f / %.0f MB", usedMB, maxMB);
    }
    
	   private void drawGridMapInfos() {
		   custombatch.begin();
	    	
	       
	        
	        float left = camera.position.x - camera.viewportWidth * camera.zoom / 2f;
	        float right = camera.position.x + camera.viewportWidth * camera.zoom / 2f;
	        float bottom = camera.position.y - camera.viewportHeight * camera.zoom / 2f;
	        float top = camera.position.y + camera.viewportHeight * camera.zoom / 2f;
	        // m line
	        shapeRenderer.setColor(0.9f, 0.1f, 0.1f, 1);
	        int repx=0;
	        for (float x = 0; x <= right; x += gridSize1m) {
//	            shapeRenderer.line(x, 0, x, top);
	            String rep = repx<=1?String.format("%d m",repx):String.format("%d",repx);
	            tmp.set(x-20, -10, 0);
	            
	            camera.project(tmp);
	            font.draw(custombatch,rep, tmp.x, tmp.y);
	            repx++;
	        }
	        
	        int repy=0;
	        for (float y = 0; y <= top; y += gridSize1m) {
//	            shapeRenderer.line(0, y, right, y);
	        	
	            String rep = repx>1?String.format("%d",repy):"";
	            tmp.set(-40, y+10, 0);
	            
	            camera.project(tmp);
	            font.draw(custombatch,rep, tmp.x, tmp.y);
	            repy++;
	        }
	        custombatch.end();
	    }
	   
	// placing functions

	public void calculateCriticalPoints() {
		if (criticalPoints == null) {
			criticalPoints = new ArrayList<Vector2>();
		} else {
			criticalPoints.clear();
		}
		for (Actor actor : stage.getActors()) {

			if (actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				criticalPoints.addAll(object2D.calculateAttachmentPosition());
			}
			
		}
	}

	public static WorldObject getClosest(WorldObject target, Array<WorldObject> brothers) {
		if (target == null || brothers == null || brothers.size < 1) {
			return null;
		}
		Vector3 targetPos = target.getRealWorldPosition();
		Vector4 targetDim = target.getRealWorldDimension();
		//
		WorldObject closest = null;
		float distance = 10000000;
		for (WorldObject objectX : brothers) {
			if (objectX.equals(target)) {
				continue;
			}
			if (objectX instanceof Wall) {
				continue;
			}
			Vector3 objectXPos = objectX.getRealWorldPosition();
			Vector4 objectXDim = objectX.getRealWorldDimension();

			Intervale yintTarget = new Intervale(targetPos.y - targetDim.y / 2, true, targetPos.y + targetDim.y / 2,
					true);
			Intervale yintBro = new Intervale(objectXPos.y - objectXDim.y / 2, true, objectXPos.y + objectXDim.y / 2,
					true);
			Intervale yIntesect = yintBro.getintersection(yintTarget);

			if (yIntesect == null || yIntesect.isPoint()) {
				continue;
			}
			final float a = targetPos.x - objectXPos.x;
			final float b = targetPos.y - objectXPos.y;

			final float c = targetPos.z - objectXPos.z;

			double distbyOrigin = Math.sqrt(a * a + b * b + c * c);
			if (distbyOrigin <= distance) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}

	public static void adaptobjecttoBrothersBySurface(Object2D object2d) {
		ArrayList<WorldObject> brothers = new ArrayList<WorldObject>();
		brothers.addAll(ProjectManager.instance.getCurrentScene().getSceneObjects());
		brothers.remove(object2d.getWorldObject());
		WorldObject target = object2d.getWorldObject();

		if (brothers != null && brothers.size() > 0) {
			ArrayList<Surface> surfaces = getClosestbrotherSurface(target, brothers);
			if (surfaces != null) {
				Surface broSurface = surfaces.get(0);
				Surface targetSurface = surfaces.get(1);

				Vector3 normale = broSurface.getNormal().cpy().nor();
				Vector2 middle = new Vector2(targetSurface.getStart().x + targetSurface.getEnd().x,
						targetSurface.getStart().z + targetSurface.getEnd().z).scl(0.5f);

				float dist = MathUtilities.lineToPointDistance(middle.x, middle.y, broSurface.getStart().x,
						broSurface.getStart().z, broSurface.getEnd().x, broSurface.getEnd().z);
				Vector2 point = MathUtilities.getclosestPoint(middle.x, middle.y, broSurface.getStart().x,
						broSurface.getStart().z, broSurface.getEnd().x, broSurface.getEnd().z);
				Vector2 vector = point.cpy().sub(middle);
				float scalar = vector.cpy().dot(new Vector2(normale.x, normale.z));
				if (scalar < 0) {
					dist *= -1;
				}
				normale.scl(dist);
				target.getRealWorldPosition().add(normale);
			} else {
				System.err.println("surfaces is null");
			}

		}
		((AbstractScreen) Scene.game.getScreen()).getController().updateWorldObject(object2d);

	}

	public static ArrayList<Surface> getClosestbrotherSurface(WorldObject target, ArrayList<WorldObject> brothers) {
		if (target == null || brothers == null || brothers.size() < 1) {
			return null;
		}
		Vector3 targetPos = target.getRealWorldPosition();
		Vector4 targetDim = target.getRealWorldDimension();

		//
		Surface closestsurface = null;
		Surface surfacetarget = null;

		float distance = 10000000.0f;
		target.getContainerBox().update();

		ArrayList<Surface> targetsurfaces = new ArrayList<Surface>();
		targetsurfaces.add(target.getContainerBox().getFace());
		targetsurfaces.add(target.getContainerBox().getBack());
		targetsurfaces.add(target.getContainerBox().getLeft());
		targetsurfaces.add(target.getContainerBox().getRight());
		for (WorldObject bro : brothers) {
			if (bro.equals(target) || bro.isHidden()|| bro.getType().equals(ObjectType.POLY)|| bro.getType().equals(ObjectType.MODELED)) {
				continue;
			}
			if (bro instanceof Wall) {
				continue;
			}
			boolean isvalid = false;
			Vector3 objectXPos = bro.getRealWorldPosition();
			Vector4 objectXDim = bro.getRealWorldDimension();

			Intervale yintTarget = new Intervale(targetPos.y - targetDim.y / 2, true, targetPos.y + targetDim.y / 2,
					true);
			Intervale yintBro = new Intervale(objectXPos.y - objectXDim.y / 2, true, objectXPos.y + objectXDim.y / 2,
					true);
			Intervale yIntesect = yintBro.getintersection(yintTarget);

			if (yIntesect == null || yIntesect.isPoint()) {
				continue;
			}

			bro.getContainerBox().update();
			ArrayList<Surface> surfaces = new ArrayList<Surface>();
			surfaces.add(bro.getContainerBox().getFace());
			surfaces.add(bro.getContainerBox().getBack());
			surfaces.add(bro.getContainerBox().getLeft());
			surfaces.add(bro.getContainerBox().getRight());
			// determine the closest possible surface if there any and determine its
			// distance from our target object
			for (Surface targetSurface : targetsurfaces) {
				for (Surface surface : surfaces) {
					if (MathUtilities.iscontains(targetPos.x, targetPos.z, surface.getStart().x, surface.getStart().z,
							surface.getEnd().x, surface.getEnd().z)) {
						if (targetSurface.getNormal().isCollinearOpposite(surface.getNormal())) {
							float pdistance = MathUtilities.lineToPointDistance(targetPos.x, targetPos.z,
									surface.getStart().x, surface.getStart().z, surface.getEnd().x, surface.getEnd().z);
							float xdistance = (float) (Math.abs(pdistance) - target.getRealWorldDimension().x / 2);
							if (xdistance < 0.1f && Math.abs(pdistance) < Math.abs(distance)) {
								closestsurface = surface;
								surfacetarget = targetSurface;
								distance = Math.abs(pdistance);
							}
						}
					}
				}
			}
		}
		if (closestsurface == null || surfacetarget == null) {
			return null;

		} else {
			ArrayList<Surface> surfaces = new ArrayList<Surface>();
			surfaces.add(closestsurface);
			surfaces.add(surfacetarget);

			return surfaces;
		}

	}

	public void placeActorOnEdge(Edge edge, Object2D object2D) {
		String role = "";
		try {
			role = object2D.getWorldObject().getModel().getInfo().getProperties().getProperty("role", "");
		}catch (Exception e) {
			role = "";
		}
		//check if edge corner is close to corner
		Vector2 translation = new Vector2(Float.MAX_VALUE, Float.MAX_VALUE);
		Vector2 edgeConnection = null;
		for(var edgeCorner: edge.getVertices()) {
			for(var corner: object2D.getRotatedVertices()) {
				Vector2 translationToCorner = edgeCorner.cpy().sub(corner);
				if(translationToCorner.len2() < translation.len2()) {
					translation.set(translationToCorner);
					edgeConnection = edgeCorner;
				}
			}
		}
		if(translation.len() < 20 && !object2D.getWorldObject().isConstraint()) {
			float rotation = edge.getRotation();;
			float objectRotation = object2D.getRotation();
			if(Math.round(Math.abs(rotation - objectRotation)) % 90 > 1) {
				rotation = rotation - 180;
				object2D.getWorldObject().setRotation(rotation);
				object2D.setRotation(rotation);
			}
			Vector2 translationToCorner = new Vector2(Float.MAX_VALUE, Float.MAX_VALUE);;
			for(var corner: object2D.getRotatedVertices()) {
				Vector2 trans = edgeConnection.cpy().sub(corner);
				if(trans.len2() < translationToCorner.len2()) {
					translationToCorner.set(trans);
				}				
			}
			object2D.moveBy(translationToCorner.x, translationToCorner.y);
			return;
		}
		
		
		Vector2 positionOnEdge = edge.projectPoint(object2D.getAbsoluteOrigin());
		//constraint by size
		float x = object2D.getWorldObject().getRealWorldDimension().x;
		if(object2D.getWorldObject().isConstraint())
			x+= 0.1f;
		float lengthOnScreen = new Vector3(x,0,0).mul(worldToSceneTransform).sub(new Vector3().mul(worldToSceneTransform)).len(); 
		float halfLength = lengthOnScreen/2.0f;
		float dst0 = positionOnEdge.dst(edge.getV0());
		float dst1 = positionOnEdge.dst(edge.getV1());
		float maxThreshold = 0.05f *getScaleX();
		if(dst0 < dst1) {
			if(dst0 - halfLength < maxThreshold) {
				positionOnEdge.set(edge.getV0().cpy().add(edge.getDirector().nor().scl(halfLength)));	
			}
		}else {
			 if(dst1 - halfLength < maxThreshold ) {
					positionOnEdge.set(edge.getV1().cpy().add(edge.getDirector().nor().scl(-halfLength)));
				}
		}
		//end constraint
		translation = positionOnEdge.sub(object2D.getAbsoluteOrigin());
		if (object2D.getWorldObject().isConstraint()) {
			if(role.equals("door")) {
				translation.add(edge.getNormal().scl(-object2D.getHeight() / 4.0f));
			}else {
				translation.add(edge.getNormal().scl(-object2D.getHeight() / 2.0f));
			}
		} else {
			translation.add(edge.getNormal().scl(object2D.getHeight() / 2.0f));
		}

		object2D.moveBy(translation.x, translation.y);
		float rotation = 180 + edge.getRotation();
		object2D.getWorldObject().setRotation(rotation);
		object2D.setRotation(rotation);
		
		if (object2D.getWorldObject().isConstraint()) {
			Vector3 center = new Vector3(edge.projectPoint(object2D.getAbsoluteOrigin()),
					object2D.getWorldObject().getRealWorldPosition().y).mul(getSceneToWorldTransform());
			if (role.equals("door")) {
				ProjectManager.getManager().getCurrentScene().addDoor(object2D.getWorldObject(), center);
			} else {
				ProjectManager.getManager().getCurrentScene().addConstraint(object2D.getWorldObject(), center);
			}
		}
	}

	public void placeActorOnArc(Arc arc, Object2D object2D) {
		Vector2 positionOnEdge = arc.projectPoint(object2D.getAbsoluteOrigin());
		Vector2 translation = positionOnEdge.sub(object2D.getAbsoluteOrigin());// .cpy().sub(arc.getCenter()).nor().scl(object2D.getHeight()/2));
		Vector2 trans = object2D.getAbsoluteOrigin().cpy().sub(positionOnEdge).nor().scl(object2D.getWidth() / 2.0f);
		translation.sub(trans);
		object2D.moveBy(translation.x, translation.y);
		Vector2 tangent = object2D.getAbsoluteOrigin().sub(arc.getCenter());
		float rotation = tangent.angle() + 180;
		object2D.getWorldObject().setRotation(rotation);
		object2D.setRotation(rotation);
	}

	// selection and search functions
	public Object2D getSelectedActor() {
		Object2D object2D = null;
		WorldObject selected = ProjectManager.instance.getCurrentScene().getSelectedobject();
		if (selected != null) {
			Array<Actor> actors = new Array<Actor>();
			actors.addAll(getStage().getActors());
			for (Actor actor : actors) {
				if (actor instanceof Object2D) {
					Object2D objectX = (Object2D) actor;
					if (objectX.getWorldObject() == selected) {
						object2D = objectX;
					}
				}
			}
		}
		return object2D;
	}

	public void selectSurface(Vector2 point) {
		ArrayList<Shape> surfaces = new ArrayList<Shape>();
		for (Wall2D wall : getWalls()) {
			surfaces.addAll(wall.getSides());
		}
		if (!surfaces.isEmpty()) {
			Shape closestShape = surfaces.get(0);
			for (int i = 1; i < surfaces.size(); i++) {
				if (surfaces.get(i).distanceTo(point) < closestShape.distanceTo(point))
					closestShape = surfaces.get(i);
			}
			if (closestShape.distanceTo(point) < 50) {
				if (closestShape instanceof Edge) {
					Edge edge = (Edge) closestShape;
					Optional<WallFragment> fragment = ProjectManager.getManager().getCurrentScene().findFragment(edge);
					float height = Preferences.WALL_HEIGHT;
					if (fragment.isPresent()) {
						height = fragment.get().getHeight();
					}
					Vector2 start = edge.getV0().cpy(), end = edge.getV1().cpy();
					Vector3 s = new Vector3(start, 0).mul(getSceneToWorldTransform());
					Vector3 e = new Vector3(end, height).mul(getSceneToWorldTransform());
					setSelectedSurface(new Surface(s, e));
				}
			}
		}
	}

	// events
	@Override
	public void handle(Event event) {
		if(!handle)
			return;
		SceneEvent EVENT = SceneEvent.valueOf(event.getTopic());
		switch (EVENT) {
		case DELETE_OBJECT:
			removeActor(event.getData());
			break;
		case DISPLAY_ACTIONS_MENU:
			displayRightClickMenu(event.getData());
			break;
		case OBJECT_SELECTED:
		case VOID_CLICK:
			removeObjectMenuList();
			break;
		case EDIT_OBJECT:
			Display.getDefault().asyncExec(() -> editObject(event));
			break;
		case SHOW_OBJECT:
			showElement(event);
			break;
		case HIDE_OBJECT : 
			hideElement(event);
			break;
		case GENERATE_REPORT:
			generateReport(event);
			break;
		case OBJECT_DROP:
			objectDropped((Map<String, Object>) event.getData());
			break;
		case OBJECT_CHANGED:
			updateObject((WorldObject)event.getData());
			break;
		}
	}

	private void removeObjectMenuList() {
		ObjectMenuList.getInstance(null).remove();
	}

	public void objectDropped(Map<String, Object> data) {
		Object object = data.get("object");
		Vector2 location = (Vector2) data.getOrDefault("location", new Vector2(600,600));
		stage.screenToStageCoordinates(location);
		dropActor(object,location.x, location.y);
	}

	private void generateReport(Event event) {
		if (event.getData() != null && event.getData() instanceof KitchenElement) {
			KitchenElement kitchenElement = (KitchenElement) event.getData();
			ElementReport report = new ElementReport(kitchenElement);
			report.generate(true);
		}

	}

	private void showElement(Event event) {
		if (event.getData() instanceof WorldObject) {
			Object2D object2D = null;
			try {
				object2D = (Object2D) getObject((WorldObject) event.getData());
				if (!stage.getActors().contains(object2D, true)) {
					stage.addActor(object2D);
				}
				stage.getActors().sort(AltitudeSorter.getSorter());
			} catch (Exception e) {
				System.err.println("error displaying object2D " + event.getData());
			}

		}
	}
	
	private void hideElement(Event event) {
		var data = event.getData();
		if (data != null && data instanceof WorldObject) {
			ProjectManager.getManager().getCurrentScene().hide((WorldObject) data);

		}
	}
	
	private void editObject(Event event) {
		var target = event.getData();
		if(target instanceof Wall2D || target instanceof GeometryObject2D) {
			editWall( (Object2D) target);
		}
	}
	
	private void displayRightClickMenu(Object data) {
		if (ProjectManager.getInstance().getCurrentProject() == null)
			return;
		ObjectMenuList menu;
		try {
			Map<String, Object> details = (Map<String, Object>) data;
			List<ActionItem> actions = (List<ActionItem>) details.get("actions");
			menu = ObjectMenuList.getInstance(actions);
		}catch (Exception e) {
			e.printStackTrace();
			return;
		}
		
        int mx = Gdx.input.getX();
        int my = Gdx.input.getY();
        Vector3 temp=  uiStage.getCamera().unproject(new Vector3(mx, my, 0));
		menu.setPosition(temp.x,temp.y);

		menu.setZIndex(1000);
		uiStage.addActor(menu);
		uiStage.setKeyboardFocus(menu);
		uiStage.setScrollFocus(menu);
	}



	// getters and setters

	public float getScaleX() {

		return 1000f;
	}

	public float getScaleY() {
//		return stage.getHeight() / Preferences.WORLD_HEIGHT;
		return 1000f;
	}

	public ChangeCommandController getChangeCommandController() {
		return changeCommandController;
	}

	public void setChangeCommandController(ChangeCommandController changeCommandController) {
		this.changeCommandController = changeCommandController;
	}

	@Override
	public Object2D getObject(WorldObject worldObject) {
		Object2D object2D = null;
		for (Actor actor : actors) {
			if (actor instanceof Object2D && ((Object2D) actor).getWorldObject() == worldObject) {
				object2D = (Object2D) actor;
				break;
			}
		}
		return object2D;
	}

	@Override
	public Stage getUIStage() {
		return this.uiStage;
	}

	@Override
	public float[] getScales() {
		return new float[] { getScaleX(), getScaleY() };
	}

	public void debugEdges() {
		if (edges == null)
			edges = new ArrayList<Edge>();
		edges.clear();
		Array<Actor> actors = new Array<Actor>();
		actors.addAll(getUIStage().getActors());
		for (Actor actor : actors) {
			if (actor instanceof Object2D) {
				Object2D object2d = (Object2D) actor;
				edges.addAll(object2d.calculateEdges());
			}
		}
	}

	public void debugEdges(Object2D object2D) {
		if (edges == null)
			edges = new ArrayList<Edge>();
		edges.clear();
		Array<Actor> actors = new Array<Actor>();
		actors.addAll(getUIStage().getActors());
		for (Actor actor : actors) {
			if (actor instanceof Object2D) {
				Object2D object2dX = (Object2D) actor;
				if (object2dX == object2D)
					continue;
				edges.addAll(object2dX.calculateEdges());
			}
		}
	}

	private boolean debugEdges;

	public boolean isDebugEdges() {
		return debugEdges;
	}

	public void setDebugEdges(boolean debugEdges) {
		this.debugEdges = debugEdges;
	}

	public ArrayList<Edge> getEdges() {
		return edges;
	}

	public void setEdges(ArrayList<Edge> edges) {
		this.edges = edges;
	}

	public static PolygonSpriteBatch getPolyBatch() {
		if (polyBatch == null)
			polyBatch = new PolygonSpriteBatch();
		return polyBatch;
	}

	public ArrayList<Vector2> getCriticalPoints() {
		if (criticalPoints == null)
			calculateCriticalPoints();
		return criticalPoints;
	}

	public void drawShape(gdxapp.shapes.ShapeType type) {
		GroupSelection.getInstance().clearSelection();
		CompoundShape shape = null;
		for (Actor actor : stage.getActors()) {
			if (actor instanceof CompoundShape) {
				shape = (CompoundShape) actor;
				break;
			}
		}
		if (!this.stage.getActors().contains(PolygonDrawer.getInstance(), true)) {
			this.stage.addActor(PolygonDrawer.getInstance());
		}
		PolygonDrawer.getInstance().setTransform(getSceneToWorldTransform());
		boolean closed = type == ShapeType.POLYGON;
		PolygonDrawer.getInstance().begin(closed);
		getUIStage().setKeyboardFocus(PolygonDrawer.getInstance());
	}

	public Surface getSelectedSurface() {
		return selectedSurface;
	}

	public void setSelectedSurface(Surface selectedSurface) {
		this.selectedSurface = selectedSurface;
	}

	public ArrayList<Wall2D> getWalls() {
		ArrayList<Wall2D> walls = new ArrayList<Wall2D>();
		Array<Actor> actors = new Array<Actor>();
		actors.addAll(getStage().getActors());
		for (Actor actor : actors) {
			if (actor instanceof Wall2D) {
				walls.add((Wall2D) actor);
			}
		}		return walls;
	}
	

	public void editWall(Object2D geometryObject) {
		GroupSelection.getInstance().clearSelection();
		if (!this.stage.getActors().contains(PolygonDrawer.getInstance(), true))
			this.stage.addActor(PolygonDrawer.getInstance());
		PolygonDrawer.getInstance().setTransform(getSceneToWorldTransform());
		try {
			PolygonDrawer.getInstance().edit(geometryObject.getWorldObject());
			geometryObject.setVisible(false);
		}catch (Exception e) {
			System.err.println("unable to get a polygin from wall object");
		}
	}



	public Wall2D getWall(CompoundShape compoundShape) {
		Wall2D wall = null;
		for (Wall2D wallX : getWalls()) {
			if (wallX.getGeometry().equals(compoundShape)) {
				wall = wallX;
				break;
			}
		}
		return wall;
	}

	public void calculateWallSurfaces() {
		if (wallsSurfaces == null)
			wallsSurfaces = new ArrayList<>();
		wallsSurfaces.clear();
		for (Wall2D wall : getWalls()) {
			wallsSurfaces.addAll(wall.getSides());
		}
	}

	private Object2D getActor(WorldObject worldObject) {
		for (Actor actor : stage.getActors()) {
			if (actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				if (object2D.getWorldObject() == worldObject)
					return object2D;
			}
		}
		return null;
	}

	public ArrayList<Shape> getWallsSurfaces() {
		if (wallsSurfaces == null)
			calculateWallSurfaces();
		return wallsSurfaces;
	}

	public ArrayList<GeometryObject2D> getGeometries() {
		ArrayList<GeometryObject2D> geometries = new ArrayList<GeometryObject2D>();
		for (Actor actor : stage.getActors()) {
			if (actor instanceof GeometryObject2D)
				geometries.add((GeometryObject2D) actor);
		}
		return geometries;
	}

	@Override
	public void rectifyPosition(Object2D object2d) {
		if (object2d.getWorldObject().getType() != ObjectType.POLY) {
			if (!getWallsSurfaces().isEmpty()) {
				Shape closestShape = getWallsSurfaces().get(0);
				ArrayList<Edge> edges = object2d.getEdges();
				Edge closestEdge = edges.get(0);
				if (edges != null && edges.size() == 4) {
					float closestDistance = 10000000.0f;
					for (int i = 0; i < getWallsSurfaces().size(); i++) {
						Shape shape = getWallsSurfaces().get(i);
						for (int j = 0; j < edges.size(); j++) {
							Edge edge = edges.get(j);
							if (shape.distanceTo(edge.getMiddle()) < closestDistance) {
								closestEdge = edge;
								closestShape = shape;
								closestDistance = shape.distanceTo(edge.getMiddle());
							}
						}
					}
				}

				float dst = closestShape.distanceTo(closestEdge.getMiddle());
				dst/=getScaleX();
				if (closestEdge != null && closestShape.distanceTo(closestEdge.getMiddle()) / getScaleX() < 0.1f) {
					if (closestShape instanceof Edge) {
						placeActorOnEdge((Edge) closestShape, object2d);
					}

					if (closestShape instanceof Arc) {
						placeActorOnArc((Arc) closestShape, object2d);
					}
				}
			}
			WorldObject target = object2d.getWorldObject();
			if (!object2d.getWorldObject().isConstraint() && !(target instanceof Wall ) && !target.getType().equals(ObjectType.POLY) && !target.getType().equals(ObjectType.MODELED)) {
				adaptobjecttoBrothersBySurface(object2d);
			}
		}
	}

	public void addSurfaceSelector() {
		if (!stage.getActors().contains(SurfaceSelector.getInstance(), true)) {
			stage.addActor(SurfaceSelector.getInstance());
			stage.setKeyboardFocus(SurfaceSelector.getInstance());
		}

	}

	public Vector3 toRealWorldCoordinate(Vector3 coords) {
		return coords.cpy().mul(sceneToWorldTransform);
	}

	@Override
	public void clear() {
		GroupSelection.getInstance().clearSelection();
		for (Actor actor : actors) {
			if (actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				object2D.remove();
				((Object2D) actor).dispose();
			}
			if (actor instanceof Plinth) {
				Plinth object2D = (Plinth) actor;
				object2D.remove();
			}
			if (actor instanceof Wall2D) {
				Wall2D object2D = (Wall2D) actor;
				object2D.remove();
			}
		}
		actors.clear();
		stage.clear();
		stage.addActor(stack);
	}

	@Override
	public void addActor(Object actor) {
		
	}

	@Override
	public void removeActor(Object actor) {
		try {
			Object2D object2D = getObject((WorldObject) actor);
			actors.remove(object2D);
			object2D.delete();
			if(actor instanceof Wall) {
				calculateWallSurfaces();
			}
		}catch (NullPointerException | ClassCastException e) {
			e.printStackTrace();
		}
	}

	public boolean isHandle() {
		return handle;
	}

	public void setHandle(boolean handle) {
		this.handle = handle;
	}

	@Override
	public void reloadActor(WorldObject... worldObject) {
		
	}

	@Override
	public Stage getStage() {
		return stage;
	}



	


}
//Enhanced RectangleActor with proper hit detection and dragging using InputListener
class RectActor extends Actor {
 private float width, height;
 private Color color;
 private ShapeRenderer shapeRenderer;
 private OrthographicCamera camera;
 private TextureRegion textureRegion;
 private boolean hasTexture = false;
 
 public RectActor(float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera) {
     this(width, height,color,shapeRenderer,camera, (TextureRegion)null);
 }
 // For textured rectangles
 public RectActor(float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera, Texture texture) {
     this(width, height,color,shapeRenderer,camera, new TextureRegion(texture));
 }

 public RectActor(float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera, TextureRegion textureRegion) {
     this.width = width;
     this.height = height;
     this.color = color;
     this.shapeRenderer = shapeRenderer;
     this.camera = camera;
     if(textureRegion!=null) {
         this.textureRegion = textureRegion;
         this.hasTexture = true;
     }

     setSize(width, height);
     setTouchable(Touchable.enabled); // Enable touch events
     inputListner();
     
 }

 private void inputListner() {
 	// Add InputListener for drag functionality
     addCaptureListener(new InputListener() {
         private float dragOffsetX, dragOffsetY;
         private float cumulx,cumuly;
         @Override
         public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        
             if (button == Input.Buttons.LEFT) {
//                 System.err.println("Down X:"+x+"Down Y:"+y);
                 dragOffsetX =x;
                 dragOffsetY =y ;  
                 cumulx=0;
                 cumuly=0;
              	getStage().setKeyboardFocus(RectActor.this);
                 return true;
             }
             return false;
         }
         
         @Override
         public void touchDragged(InputEvent event, float x, float y, int pointer) {
//             System.out.println("Drag X:"+x+"drag Y:"+y);
             Vector3 world = new Vector3(x, y, 0);
             cumulx+=world.x;
             cumuly+=world.y;
             setPosition(getX()+world.x-dragOffsetX,getY()+world.y-dragOffsetY);
         }
     });
     addListener(new InputListener() {
     	@Override
     	public boolean keyDown(InputEvent event, int keycode) {
     		if(keycode==Keys.S){
     			setPosition(1000,1000);
     		}
     		return true;
     	}
     });
 }
 public RectActor(float x, float y, float width, float height, Color color, ShapeRenderer shapeRenderer, OrthographicCamera camera) {
     this(width, height, color, shapeRenderer, camera);
     setPosition(x, y);
 }

 @Override
 public void draw(com.badlogic.gdx.graphics.g2d.Batch batch, float parentAlpha) {
     batch.end();
     
     Color c = getColor();

     shapeRenderer.setColor(c.r, c.g, c.b, c.a * parentAlpha);
     shapeRenderer.setProjectionMatrix(camera.combined);
     shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
     shapeRenderer.rect(getX(), getY(), getWidth(), getHeight());
     shapeRenderer.end();
    
     
     if (hasTexture && textureRegion != null) {
     	batch.begin();
         // Draw texture
     	float fitin = 0;//5 mm fit in
         batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
         batch.draw(textureRegion, getX()+fitin, getY()+fitin, getWidth()-2*fitin, getHeight()-2*fitin);
         batch.setColor(Color.WHITE); // reset
         batch.end();
     }
     


     
     shapeRenderer.setColor(0, 0, 0, 0);
     shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
     shapeRenderer.rect(getX(), getY(), getWidth(), getHeight());
     shapeRenderer.end();
     batch.begin();
 }

 @Override
 public Actor hit(float x, float y, boolean touchable) {
     if (!touchable) return null;
     float absx = x + getX();
     float absy = y + getY();
     Vector3 world = new Vector3(absx, absy, 0);
//     System.err.println("Hit check X:"+absx+" Y:"+absy);

     // Check if world point is inside this rectangle
     if (world.x >= getX() && world.x <= getX() + getWidth() &&
         world.y >= getY() && world.y <= getY() + getHeight()) {
//         System.err.println("Hit Match !!!  X:"+absx+" Y:"+absy);
         return this;
     }
     return null;
 }
}