package gdxapp.screens.ObjectEditor;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextField.TextFieldFilter.DigitsOnlyFilter;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.ui.parts.GdxPart;
import gdxapp.assets.AssetFont;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;
import gdxapp.fabs3d.BezierCurve;
import gdxapp.scenes.SceneEvent;

public class PlumbingEditor implements DrawableInputProcessor {
	
	private Camera camera;
	private final  Vector3 tmpRealWorldPoint = new Vector3();
	private final Vector3 tmpV0 = new Vector3(), tmpV1 = new Vector3(), tmpRelative = new Vector3();
	private long lastClickDate;
	private final ArrayList<Vector3> line = new ArrayList<Vector3>();;
	private final ArrayList<ArrayList<Vector3>> lines = new ArrayList<ArrayList<Vector3>>();
	private boolean lineStarted;
	private static PlumbingEditor editor;
	private Stage uiStage;
	private Vector3 origin;
	private Label locationLbl;
	
	private InputProcessor inputProcessor;
	
	private PointerWindow pointerWindow;
	
	private final Matrix4 rcs = new Matrix4();                        //
	//the realtive coordinate system
	
	private PlumbingEditorUiLayer uiLayer;
	
	private PlumbingEditor() {
		prepareUILayer();
	}
	
	private void prepareUILayer() {
		uiStage = new Stage(new ScreenViewport());
		uiLayer = new PlumbingEditorUiLayer();
		uiLayer.setFillParent(true);
		uiLayer.setDebug(false, false);
		uiStage.addActor(uiLayer);
		createComponents();	
	}


	private void createComponents() {
		pointerWindow = new PointerWindow("enter location", AssetsTextures.getInstance().getSkin());
		pointerWindow.setSize(200, 150);		
		pointerWindow.setVisible(false);
		uiLayer.getContentBar().add(pointerWindow).center();
		locationLbl = new Label("", AssetsTextures.getInstance().getSkin());
		uiStage.addActor(locationLbl);
	}

	private void addPointToPath(int xPos, int yPos, int zPos) {
		if(lineStarted == false)
			startLine();
		Vector3 relativePos = new Vector3(xPos, yPos, zPos).scl(0.001f);
		line.add(relativePos.add(origin));
	}
	
	public void createPipe() {
		ArrayList<Vector3[]> controlPoints = calculateControlPoints(line);
		for(Vector3[] pipe: controlPoints) {
			BezierCurve curve = new BezierCurve(100, pipe);
			ModelInstance instance = new ModelInstance(curve.getModel());
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.PIPE_CREATED.name(), instance));
		}
	}
	
	public ArrayList<Vector3[]> calculateControlPoints(ArrayList<Vector3> linearPath) {
		ArrayList<Vector3[]> pipes = new ArrayList<Vector3[]>();
		if(linearPath.size() >1) {
			if(linearPath.size() == 2) {
				Vector3[] array = new Vector3[] {linearPath.get(0), linearPath.get(1)};
				pipes.add(linearPath.toArray(array)); 
			}else {
				ArrayList<Vector3[]> joints = new ArrayList<Vector3[]>();
				if(linearPath.size() > 2) {
					for(int i = 1; i < linearPath.size() - 1; i++) {
						Vector3 v, b , n, bv, nv;
							v = linearPath.get(i).cpy();
							b = linearPath.get(i - 1).cpy();
							n = linearPath.get(i + 1).cpy();
							bv = b.cpy().sub(v).nor().scl(0.005f);
							nv = n.cpy().sub(v).nor().scl(0.005f);
							joints.add(new Vector3[] {v.cpy().add(bv), v, v.cpy().add(nv)});
					}
				}
				
				ArrayList<Vector3[]> segments = new ArrayList<Vector3[]>();
				segments.add(new Vector3[] {linearPath.get(0), joints.get(0)[0]});
				for(int i = 0; i < joints.size() - 1; i++) {
					Vector3 s = joints.get(i)[2];
					Vector3 e = joints.get(i + 1)[0];
					segments.add(new Vector3[] {s, e});
				}
				segments.add(new Vector3[] {linearPath.get(linearPath.size() - 1), joints.get(joints.size() - 1)[0]});
				pipes.addAll(segments);
				pipes.addAll(joints);
			}
			
		}		
		
		return pipes;
	}

	public void start() {
		lines.clear();
		line.clear();
	}
	
	public void startLine() {
		line.clear();
		lineStarted = true;
	}
	
	public void end() {
		
	}
	
	public void endLine() {
		if(line.size() > 1) {
			createPipe();
			ArrayList<Vector3> newLine = new ArrayList<Vector3>();
			newLine.addAll(line);
			lines.add(newLine);
		}
		line.clear();
		lineStarted = false;
	}
	
	@Override
	public boolean keyDown(int keycode) {
		return true;
	}

	@Override
	public boolean keyUp(int keycode) {
		if(keycode == Input.Keys.ESCAPE) {
			endLine();
		}
		return true;
	}

	@Override
	public boolean keyTyped(char character) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDown(int screenX, int screenY, int pointer, int button) {
		System.err.println("point at: " + tmpRealWorldPoint);
		long currentDate = System.currentTimeMillis();
		if(currentDate - lastClickDate < 400) {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.END_PLUMB_EDITOR.name(), null));
			return true;
		}
		lastClickDate = currentDate;
		
		if(button == Input.Buttons.LEFT) {
			pointerWindow.setVisible(true);
			pointerWindow.setModal(true);
			pointerWindow.setPosition(tmpRealWorldPoint.cpy().sub(origin).scl(1000));
			uiLayer.getContentBar().add(pointerWindow);
			this.inputProcessor = Gdx.input.getInputProcessor();
			Gdx.input.setInputProcessor(uiStage);
			
		}else {
			
		}
		return true;
	}

	@Override
	public boolean touchUp(int screenX, int screenY, int pointer, int button) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDragged(int screenX, int screenY, int pointer) {
		return false;
	}

	@Override
	public boolean mouseMoved(int screenX, int screenY) {
		float z = ScreenUtilities.getDepthFromBuffer(screenX, Gdx.graphics.getHeight() - screenY);
		tmpRealWorldPoint.set(camera.unproject(new Vector3(screenX, screenY, z)));
		
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		return false;
	}
	
	@Override
	public void draw(Batch batch) {
		DrawingHelper.getDebugRenderer().setProjectionMatrix(batch.getProjectionMatrix());
		DrawingHelper.getDebugRenderer().begin(ShapeType.Filled);
		for(ArrayList<Vector3> lineX: lines) {
			drawLine(lineX, Color.BLUE, 10);
		}
		
		if(lineStarted) {
			DrawingHelper.getDebugRenderer().setColor(Color.RED);
			if(line.size() > 0) {
				for(int i = 0; i < line.size() - 1; i++) {
					tmpV0.set(camera.project(line.get(i).cpy()));
					tmpV1.set(camera.project(line.get(i + 1).cpy()));
					DrawingHelper.getDebugRenderer().rectLine(tmpV0.x, tmpV0.y, tmpV1.x, tmpV1.y, 10f);
				}
				tmpV0.set(camera.project(line.get(line.size() - 1).cpy()));
				tmpV1.set(camera.project(tmpRealWorldPoint.cpy()));
				DrawingHelper.getDebugRenderer().rectLine(tmpV0.x, tmpV0.y, tmpV1.x, tmpV1.y, 10f);
			}
		}
		
		tmpV0.set(camera.project(origin.cpy()));
		DrawingHelper.getDebugRenderer().circle(tmpV0.x, tmpV0.y, 20);
		DrawingHelper.getDebugRenderer().end();
		drawCurrentMouseLocation(batch);
	
		//draw the ui
//		Point point = GdxPart.scrollPane.getScrollPosition();
//		Dimension dims = GdxPart.scrollPane.getSize();
//		uiLayer.pad(point.y, point.x, Gdx.graphics.getHeight() - point.y - dims.height, Gdx.graphics.getWidth() -point.x - dims.width);
//		uiLayer.invalidateHierarchy();
		uiLayer.act(0.017f);
		uiStage.act();
		uiStage.draw();
	}

	private void drawCurrentMouseLocation(Batch batch) {
		tmpV0.set(camera.project(origin.cpy()));
		tmpV1.set(camera.project(tmpRealWorldPoint.cpy()));
		tmpV1.sub(tmpV0);
		Vector3 vx = tmpV0.cpy().add(tmpV1.cpy().scl(Vector3.X));
		Vector3 vy = tmpV0.cpy().add(tmpV1.cpy().scl(Vector3.Y));
		DrawingHelper.drawCutLine(tmpV0.x, tmpV0.y, tmpV0.x + tmpV1.x, tmpV0.y + tmpV1.y, batch, Color.BLUE, 2);
		DrawingHelper.drawCutLine(vx.x, vx.y, tmpV0.x + tmpV1.x, tmpV0.y + tmpV1.y, batch, Color.RED, 2);
		DrawingHelper.drawCutLine(vy.x, vy.y, tmpV0.x + tmpV1.x, tmpV0.y + tmpV1.y, batch, Color.GREEN, 2);
		//draw texts
		//Vector3 realWorldVec = tmpRealWorldPoint.cpy().sub(origin);
		Vector3 originLocal = camera.project(origin.cpy());
		int scsX = Gdx.input.getX();
		int scsY =  Gdx.input.getY();
		float depth = ScreenUtilities.getDepthFromBuffer(scsX, Gdx.graphics.getHeight() - scsY);
		
		if(Gdx.input.isKeyPressed(Keys.D)) {
			System.err.println(scsY);
		}
		int x = Gdx.input.getX();
		int y = Gdx.graphics.getHeight() - Gdx.input.getY();
		float z = ScreenUtilities.getDepthFromBuffer(x, y);
		Vector3 realWorldVec = tmpRealWorldPoint.cpy();
		realWorldVec.set(Math.round(realWorldVec.x * 1000), Math.round(realWorldVec.y * 1000), Math.round(realWorldVec.z * 1000));
		String xStr = String.valueOf((int)realWorldVec.x);
		String yStr = String.valueOf((int)realWorldVec.y);
		String zStr = String.valueOf((int)realWorldVec.z);

		locationLbl.setText("X:" + xStr + ",Y:" + yStr + ",Z:" + zStr);
		locationLbl.setPosition(tmpV0.x + tmpV1.x + 2, tmpV0.y + tmpV1.y);
	}


	private void drawLine(ArrayList<Vector3> line, Color color, float width) {
		if(line.size() > 0) {
			DrawingHelper.getDebugRenderer().setColor(color);
			for(int i = 0; i < line.size() - 1; i++) {
				tmpV0.set(camera.project(line.get(i).cpy()));
				tmpV1.set(camera.project(line.get(i + 1).cpy()));
				//DrawingHelper.getDebugRenderer().rectLine(tmpV0.x, tmpV0.y, tmpV1.x, tmpV1.y, width);
				
				Vector3 fontPosition = new Vector3();
				String text;
				GlyphLayout layout;
				Vector3 relativePosition;
				//draw start 
				uiStage.getBatch().begin();
				fontPosition.set(tmpV0);
				relativePosition = line.get(i).cpy().sub(origin).scl(100);
				text = "X:" + (int)relativePosition.x + "Y:" + (int)relativePosition.y + "Z:" + (int)relativePosition.z;
				layout = new GlyphLayout(AssetFont.getInstance().getFont(), text);
				AssetFont.getInstance().getSmallFont().draw(uiStage.getBatch(), text, fontPosition.x, fontPosition.y - 10, 50, Align.center, false);
				//draw end
				if(i == line.size()-2) {
					fontPosition.set(tmpV1);
					relativePosition = line.get(i + 1).cpy().sub(origin).scl(100);
					text = "X:" + (int)relativePosition.x + " Y:" + (int)relativePosition.y + " Z:" + (int)relativePosition.z;
					layout = new GlyphLayout(AssetFont.getInstance().getFont(), text);
					AssetFont.getInstance().getSmallFont().draw(uiStage.getBatch(), text, fontPosition.x, fontPosition.y - 10, 50, Align.center, false);
				}
				//draw length
				fontPosition.set(tmpV1.cpy().add(tmpV0).scl(0.5f));
				relativePosition = line.get(i + 1).cpy().sub(line.get(i)).scl(100);
				text = (int)relativePosition.len() + "cm";
				layout = new GlyphLayout(AssetFont.getInstance().getSmallFont(), text);
				AssetFont.getInstance().getSmallFont().draw(uiStage.getBatch(), text, fontPosition.x, fontPosition.y - 10, 50, Align.center, false);
				uiStage.getBatch().end();

				
			}
		}		
	}

	public Camera getCamera() {
		return camera;
	}
	public void setCamera(Camera camera) {
		this.camera = camera;
		updateRCS();
	}
	
	


	private void updateRCS() {
		Vector3 x = camera.unproject(Vector3.X.cpy()).sub(camera.unproject(Vector3.Zero.cpy()));
		Vector3 y = camera.unproject(Vector3.Y.cpy().scl(-1)).sub(camera.unproject(Vector3.Zero.cpy()));
		Vector3 z = camera.unproject(Vector3.Z.cpy()).sub(camera.unproject(Vector3.Zero.cpy())).nor().scl(x.len());
		this.rcs.set(x, y, z, origin);
	}




	public Stage getUiStage() {
		return uiStage;
	}


	public void setUiStage(Stage uiStage) {
		this.uiStage = uiStage;
	}


	public static PlumbingEditor getEditor() {
		if(editor == null)
			editor = new PlumbingEditor();
		editor.prepareUILayer();
		return editor;
	}


	public ArrayList<ArrayList<Vector3>> getLines() {
		return lines;
	}
	
	
	
	
	public Vector3 getOrigin() {
		return origin;
	}
	public void setOrigin(Vector3 origin) {
		this.origin = origin;
	}
	
	


	
	class PlumbingEditorUiLayer extends Table implements EventHandler{
		
		
		Table topBar;
		Table contentBar;
		
		public PlumbingEditorUiLayer() {
			super();
			createTopBar();
		} 
		
		
		void createTopBar() {
			ImageButton selectBtn;
			ImageButton drawBtn;
			ImageButton clearAllBtn;
			selectBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.SELECT_STYLE));
			drawBtn =  new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.PIPE_STYLE));
			topBar = new Table();
			topBar.row().height(50);
			topBar.add(selectBtn);
			topBar.add(drawBtn);
			top();
			add(topBar);
			contentBar = new Table();
			row();
			add(contentBar).grow();
		}
		

		@Override
		public void handle(Event event) {
			
		}


		public Table getTopBar() {
			return topBar;
		}


		public void setTopBar(Table topBar) {
			this.topBar = topBar;
		}


		public Table getContentBar() {
			return contentBar;
		}


		public void setContentBar(Table contentBar) {
			this.contentBar = contentBar;
		}
		
		
		
		
	}
	
	class PointerWindow extends Window{
		
		Label labelX, labelY, labelZ ;
		TextField tfx, tfy, tfz;
		TextButton addTBTN, cancelTBTN;
		
		public PointerWindow(String title, Skin skin) {
			super(title, skin);
			createContent();
		}
		
		public void createContent() {
			labelX = new Label("X:", AssetsTextures.getInstance().getSkin());
			tfx = new TextField("",AssetsTextures.getInstance().getSkin());
			labelY = new Label("Y:", AssetsTextures.getInstance().getSkin());
			tfy = new TextField("",AssetsTextures.getInstance().getSkin());
			labelZ = new Label("Z:", AssetsTextures.getInstance().getSkin());
			tfz = new TextField("",AssetsTextures.getInstance().getSkin());
			DigitsOnlyFilter digitsonlyFilter = new DigitsOnlyFilter();
			tfx.setTextFieldFilter(digitsonlyFilter);
			tfy.setTextFieldFilter(digitsonlyFilter);
			tfz.setTextFieldFilter(digitsonlyFilter);
			addTBTN = new TextButton("OK", AssetsTextures.getInstance().getSkin());
			cancelTBTN = new TextButton("Cancel", AssetsTextures.getInstance().getSkin());
			addTBTN.addListener(new ChangeListener() {
				@Override
				public void changed(ChangeEvent event, Actor actor) {
					int xPos, yPos, zPos;
					try {
						xPos = Integer.valueOf(tfx.getText());
						yPos = Integer.valueOf(tfy.getText());
						zPos = Integer.valueOf(tfz.getText());
						addPointToPath(xPos, yPos, zPos);
						pointerWindow.remove();
					}catch (NumberFormatException e) {
						tfx.setText("");
						tfy.setText("");
						tfz.setText("");
						return;
					}	
					Gdx.input.setInputProcessor(inputProcessor);
				}
			});	
			cancelTBTN.addListener(new ClickListener() {
				@Override
				public void clicked(InputEvent event, float x, float y) {
					pointerWindow.remove();
					Gdx.input.setInputProcessor(inputProcessor);
				}
			});
			
			Table content = new Table();
			content.add(labelX).width(40);
			content.add(tfx).width(120);
			content.add(labelY).width(40);
			content.add(tfy).width(120);
			content.add(labelZ).width(40);
			content.add(tfz).width(120);
			content.row().center();
			content.add(addTBTN).colspan(3).grow();
			content.add(cancelTBTN).colspan(3).grow();
			add(content);
		}
		
		public void setPosition(int x, int y, int z) {
			tfx.setText(String.valueOf(x));
			tfy.setText(String.valueOf(y));
			tfz.setText(String.valueOf(z));
		};
		
		public void setPosition(Vector3 v) {
			tfx.setText(String.valueOf((int)v.x));
			tfy.setText(String.valueOf((int)v.y));
			tfz.setText(String.valueOf((int)v.z));
		};
	
	}
}
