package gdxapp.assets;

import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap.Format;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.Texture.TextureFilter;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Align;

import dressing.mathutils.MathUtilities;
import dressing.model.DesignObject3D;
import dressing.model.types.CaissonType;
import dressing.model.types.PortType;
import dressing.model.types.PorteDirection;
import gdxapp.Commun.Preferences;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceScreen;

/*
    this class contains static method to help drawing shapes and do some geometrics transformations
 */
public class DrawingHelper {

    private static ShapeRenderer debugRenderer = new ShapeRenderer();
    private static SDFFont font = AssetFont.getInstance().getFont();
    
    private static final Vector2 tmpV20 = new Vector2(), tmpV21 = new Vector2();
    
    public static Pixmap drawRectangle(int width, int height, Color color){
        Pixmap pixmap = new Pixmap(width,height, Pixmap.Format.RGBA8888);
        pixmap.setColor(color);
        pixmap.fill();
        return pixmap;
    }
    
    public static void drawCercle(float x, float y, float radius,Batch batch ) {
    	boolean batchInterrupted = false;
    	if(batch.isDrawing()) {
    		batch.end();
    		batchInterrupted = true;
    	}
    	debugRenderer.setProjectionMatrix(batch.getProjectionMatrix());
    	debugRenderer.setColor(Color.WHITE);
    	debugRenderer.begin(ShapeType.Line);
    	debugRenderer.circle(x, y, radius);
    	debugRenderer.end();
    	if(batchInterrupted)
    		batch.begin();
    }
    
    
    
    public static void drawLine(Vector2 start, Vector2 end, Batch batch,Color color,int thickness) {
    	boolean batchInterrupted = false;
    	if(batch.isDrawing()) {
    		batch.end();
    		batchInterrupted = true;
    	}
        Gdx.gl.glLineWidth(thickness);
        debugRenderer.setProjectionMatrix(batch.getProjectionMatrix());
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(color);
        debugRenderer.line(start, end);
        debugRenderer.end();
        Gdx.gl.glLineWidth(1);
    	if(batchInterrupted)
    		batch.begin();
    }
    
    public static void drawCutLine(float x0, float y0, float x1, float y1, Batch batch,Color color,int thickness ){
    	tmpV20.set(x0, y0);
    	tmpV21.set(x1, y1);
    	float distance = tmpV20.dst(tmpV21);
        Vector2 se = tmpV21.cpy().sub(tmpV20).nor().scl(5);
        Vector2 tmpStart = tmpV20.cpy();
        Vector2 tmpEnd = tmpStart.cpy().add(se);
        if(debugRenderer == null)
        	debugRenderer = new ShapeRenderer();
        debugRenderer.setProjectionMatrix(batch.getProjectionMatrix());
        boolean batchinterrupted = false;
        if(batch.isDrawing()) {
        	batch.end();
        	batchinterrupted = true;
        }
        debugRenderer.begin(ShapeRenderer.ShapeType.Filled);
        debugRenderer.setColor(color);
        do{
        	debugRenderer.rectLine(tmpStart.x, tmpStart.y, tmpEnd.x, tmpEnd.y, thickness);
            tmpStart.add(se).add(se);
            tmpEnd = tmpStart.cpy().add(se);
        }
        while(tmpEnd.cpy().sub(tmpV20).len() < distance);
        debugRenderer.end();
        if(batchinterrupted)
        	batch.begin();    }
    
    public static void drawCutLine(Vector2 start, Vector2 end, Batch batch,Color color,int thickness ){
    	drawCutLine(start.x, start.y, end.x, end.y, batch, color, thickness);
    }
    
    public static Pixmap createBackgroundPixmap(int width, int height,float bigStep, float smallStep){
        Pixmap pixmap = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        pixmap.fill();
        int pointV;
        int pointH;
        int maxLineNumbers = Math.max(Math.round(Preferences.WORLD_WIDTH/smallStep), Math.round(Preferences.WORLD_HEIGHT/smallStep));
        int big = Math.round(bigStep/smallStep);
        // Draw a blue-colored horizental line on square
        for(int i = 0; i < maxLineNumbers + 1 ; i ++){
            pointV = Math.round(height * i /Preferences.WORLD_HEIGHT * smallStep);
            pointH = Math.round(width * i /Preferences.WORLD_WIDTH * smallStep);
            pixmap.setColor(10/255f, 10/255f, 70/255f, 0.1f);
            if(i%big == 0)
                pixmap.setColor(10/255f, 80/255f, 122/255f, 0.3f);
            pixmap.drawLine(0, pointV, width, pointV);
            pixmap.drawLine(pointH,0, pointH, height);
        }
        // Draw a black-colored border around square
        pixmap.setColor(0, 0, 0, 1);
        pixmap.drawRectangle(0, 0, width, height);
        return pixmap;
    }
    
    public static Pixmap createHachedPixmap(){
        Pixmap pixmap = new Pixmap(2048, 2048, Pixmap.Format.RGBA8888);
        pixmap.setColor(Color.BROWN);
        pixmap.fill();
        // Draw a blue-colored horizental line on square
        pixmap.setColor(Color.BLACK);
//        for(int i = 0; i < 2048 ; i ++){
//        	if(i % 10 == 0)
//        		pixmap.drawLine(0, i, i, 0);
//        }
        // Draw a black-colored border around square
        pixmap.setColor(0, 0, 0, 1);
        pixmap.drawRectangle(0, 0, 2048, 2048);
        return pixmap;
    }
    
	public static void drawText(String text, Vector3 position, float rotation, Color color, float scale, Batch batch) {
		GlyphLayout layout = new GlyphLayout(font, text);
		float textWidth = layout.width;
		float textHeight = font.getLineHeight();
        position.x -= textWidth * .5f;
        position.y -= textHeight *.5f;
		boolean batchInterrupted = false;
		if(batch.isDrawing()) {
			batch.end();
			batchInterrupted = true;
		}
		batch.getProjectionMatrix().translate(position).rotate(Vector3.Z, rotation);
		batch.begin();
		font.draw(batch, text, 0, 0, textWidth, Align.center, false, color);
		batch.end();
		batch.getProjectionMatrix().rotate(Vector3.Z, -rotation).translate(position.scl(-1));
		if(batchInterrupted)
			batch.begin();
	}
	
    
    public static void drawActorBorders(Actor actor, boolean cutLines) {
    	Vector2 v0 = new Vector2(actor.getX(), actor.getY());
    	Vector2 v1 = new Vector2(actor.getX() + actor.getWidth(), actor.getY());
    	Vector2 v2 = new Vector2(actor.getX() + actor.getWidth(), actor.getY() + actor.getHeight());
    	Vector2 v3 = new Vector2(actor.getX() , actor.getY() + actor.getHeight());
    	if(cutLines) {
    		drawCutLine(v0, v1, actor.getStage().getBatch(), Color.BLACK, 2);
        	drawCutLine(v1, v2, actor.getStage().getBatch(), Color.BLACK, 2);
        	drawCutLine(v2, v3, actor.getStage().getBatch(), Color.BLACK, 2);
        	drawCutLine(v3, v0, actor.getStage().getBatch(), Color.BLACK, 2);
    	}else {
    		drawLine(v0, v1, actor.getStage().getBatch(), Color.BLACK, 2);
    		drawLine(v1, v2, actor.getStage().getBatch(), Color.BLACK, 2);
    		drawLine(v2, v3, actor.getStage().getBatch(), Color.BLACK, 2);
    		drawLine(v3, v0, actor.getStage().getBatch(), Color.BLACK, 2);
    	}
    }
    
    public static void drawQuotations(Object2D actor, Batch batch){
        if(debugRenderer == null)
        	debugRenderer = new ShapeRenderer();
        boolean batchInterrupted = false;
        if(batch.isDrawing()) {
        	batch.end();
        	batchInterrupted = true;
        }
        int width=0;
        int height=0;
        if(actor.getWorldObject()!=null) {
        	if( actor.getWorldObject() instanceof KitchenElement && ((KitchenElement) actor.getWorldObject()).getDesignObject()!=null) {
        		width=(int) (actor.getWorldObject().getActiveWidth() * 1000);
        		height = Math.round((float)( ((KitchenElement) actor.getWorldObject()).getDesignObject().getHauteurext()));
        	}else {
        	width=(int) (actor.getWorldObject().getRealWorldDimension().x * 1000);
        	height=(int) (actor.getWorldObject().getRealWorldDimension().y*1000);
        	}
        }
        GlyphLayout layout = new GlyphLayout(font , width + ".0000");
        float textWidth = layout.width;
        float textHeight = font.getLineHeight();
//        float scale = (1.0f * actor.getWidth())/textWidth;
//        if(scale==0) {
//        	scale=1;
//        }
//        font.getData().setScale(scale,1);
        batch.getProjectionMatrix().translate(actor.getWidth() * .5f + actor.getX(), actor.getY() + textHeight, 0);
        batch.begin();
        font.draw(batch,width + "", 0, 0,0,Align.center,false, Color.RED); 
        batch.end();
        batch.getProjectionMatrix().translate(-actor.getWidth() * .5f - actor.getX(), - actor.getY() - textHeight, 0);
        //font.getData().setScale(1.5f,1.5f);
        
        batch.getProjectionMatrix().translate(new Vector3(actor.getX() + .1f * actor.getWidth(),actor.getY() + .5f * actor.getHeight(),0)).rotate(Vector3.Z,90);
        batch.begin();
        font.draw(batch, height + "",0 , 0, 0, Align.center, true, Color.RED);
        batch.end();
        batch.getProjectionMatrix().rotate(Vector3.Z, -90).translate(-actor.getX() - .1f * actor.getWidth(),-(actor.getY() + .5f * actor.getHeight()),0);
        if(batchInterrupted) {
            batch.begin();
        }
    }
    
    public static void drawQuotationsTopView(Object2D actor, Batch batch){
    	if(! (actor.getWorldObject() instanceof KitchenElement))
    		return;
        if(debugRenderer == null)
        	debugRenderer = new ShapeRenderer();
        boolean batchInterrupted = false;
        if(batch.isDrawing()) {
        	batch.end();
        	batchInterrupted = true;
        }
        try {

        	 String text = Math.round( ((KitchenElement) actor.getWorldObject()).getDesignObject().getLongeurext()) + "";
        	 GlyphLayout layout = new GlyphLayout(font, text);
             layout.setText(font, text);
             float halfWidth = 0.0f;//layout.width/2.0f;
             float halfHeight = 0.0f;// layout.height/2.0f;
             Vector2 translation = actor.getAbsoluteOrigin().cpy().add(halfWidth, halfHeight); 
             batch.getProjectionMatrix().translate( translation.x  ,  translation.y,0).rotate(Vector3.Z, actor.getRotation() );
             batch.begin();
             font.draw(batch, text, 0, 0, 0, Align.center, false, Color.WHITE);
             batch.end();
             batch.getProjectionMatrix().rotate(Vector3.Z, -actor.getRotation()) .translate(-translation.x  ,  -translation.y,0);
        }catch (Exception e) {
        	e.printStackTrace();
		}finally {
			 if(batchInterrupted) {
		            batch.begin();
		        }
		}

       
         
    }
    
    
    
    public static void drawRotatedEdges(Object2D actor, Batch batch, float thickness, Color color){
    	if(actor.getRotatedVertices() != null && actor.getRotatedVertices().size()> 1) {
    		if(debugRenderer == null)
            	debugRenderer = new ShapeRenderer();
            Matrix4 projection = batch.getProjectionMatrix();
            debugRenderer.setProjectionMatrix(projection);
            debugRenderer.begin(ShapeRenderer.ShapeType.Filled);
            debugRenderer.setColor(color);
            int size = actor.getRotatedVertices().size()-1;
            for(int i = 0; i < size; i ++) {
            	debugRenderer.rectLine(actor.getRotatedVertices().get(i), actor.getRotatedVertices().get(i+1),thickness);
            }
        	debugRenderer.rectLine(actor.getRotatedVertices().get(0), actor.getRotatedVertices().get(size),thickness);
            debugRenderer.end();
    	}
    }
    
    public static void drawDistanceLines(Object2D object2D, Batch batch) {
    	Vector2 a = new Vector2(), b = new Vector2();
    	Object2D target = object2D.getClosestObject(a, b);
    	if(target != null) {
    		if(debugRenderer == null)
    			debugRenderer = new ShapeRenderer();
    		debugRenderer.setProjectionMatrix(batch.getProjectionMatrix());
    		debugRenderer.setColor(new Color(0.8f,.6f,0,.5f));
    		debugRenderer.begin(ShapeType.Filled);
    		debugRenderer.setColor(Color.BLUE);
    		debugRenderer.rectLine(a, b, 1);
    		debugRenderer.end();
    	}
    }
    
    public static void drawDoors(Object2D actor,Batch batch) {
    	if(debugRenderer == null)
        	debugRenderer = new ShapeRenderer();
        Matrix4 projection = batch.getProjectionMatrix();
        debugRenderer.setProjectionMatrix(projection);
        batch.end();
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        if(actor.getWorldObject() instanceof KitchenElement) {
        	KitchenElement kitchenElement = (KitchenElement) actor.getWorldObject();
        	if(kitchenElement.getDesignObject() == null)
        		return;
        	
        	actor.calculateRotatedVertices();
        	PortType porteType = kitchenElement.getDesignObject().getPorteType();
    		String caissonType= kitchenElement.getDesignObject().getDesignCaissonType();
    		PorteDirection porteDir= kitchenElement.getDesignObject().getPorteDirection();
    		DesignObject3D design = kitchenElement.getDesignObject();
            if(porteType != null &&(caissonType!=null && !caissonType.contentEquals("BLOCK_TIROIR") && !caissonType.contentEquals("PORTE_BOTEILLE")
            		&& !caissonType.contentEquals("BAS_FOUR")&& !(design.getName().toUpperCase().contains("NICHE")&& !caissonType.contentEquals("COLONNE_FOUR")))
            		&& !caissonType.contentEquals("FAUSSE_FACADE")
            		&& !caissonType.toUpperCase().contains("NICHE") )
            		{
            	if( (porteType.equals(PortType.FRANCAISE) || porteType.equals(PortType.FRANCAISE2V))) {
            		boolean isSinglePorte = kitchenElement.getDesignObject().getLongeurext()<= kitchenElement.getDesignObject().getDesignMaxPorteLongeur() && porteType.equals(PortType.FRANCAISE);
	            	if(isSinglePorte) {
	            		if(caissonType.contentEquals("HAUT_COINS")||caissonType.contentEquals("BAS_COINS")||caissonType.contentEquals("COINS_SOUS_EVIER")||caissonType.contentEquals("COLONNE_ETAGERE_COINS") ) {
		            		 drawDoorsforCoinsSimple(actor, batch);
		            	}else{
	            			 Vector2 right = actor.getRotatedVertices().get(3);
	                         Vector2 left = actor.getRotatedVertices().get(0);
	                         Vector2 end = null, start = null;
		            		if(porteDir!=null && porteDir.equals(PorteDirection.RIGHT)) {
		            			 start = left;
		            			 end = MathUtilities.rotate( left,right.cpy(), -15);
		            		}else {
		            			 start = right;
		            			 end = MathUtilities.rotate( right,left.cpy(), 15);
		            		}
		            		debugRenderer.setColor(Color.GRAY);
	                        debugRenderer.rectLine(end.x,end.y,start.x,start.y,1);
		            	}
	            		
	               }else{
	            	   if(caissonType.contentEquals("HAUT_COINS")||caissonType.contentEquals("BAS_COINS")||caissonType.contentEquals("COINS_SOUS_EVIER")||caissonType.contentEquals("COLONNE_ETAGERE_COINS") ) {
	            		 drawDoorsforCoinsSimple(actor, batch);
	            	   }else{
							Vector2 top = actor.getRotatedVertices().get(0);
							Vector2 bottom = actor.getRotatedVertices().get(3);
							Vector2 middle = new Vector2(top.x + bottom.x, top.y + bottom.y).scl(0.5f);
							Vector2 topEnd = MathUtilities.rotate(top, middle.cpy(), -15);
							Vector2 bottomEnd = MathUtilities.rotate(bottom, middle.cpy(), 15);
							debugRenderer.setColor(Color.GRAY);
							debugRenderer.rectLine(top.x, top.y, topEnd.x, topEnd.y, 1);
							debugRenderer.rectLine(bottomEnd.x, bottomEnd.y, bottom.x, bottom.y, 1);
	            	   }
	               	
	               }
            	}else

	            if((porteType.equals(PortType.BASCULANT) || porteType.equals(PortType.BASCULANT2H)|| porteType.equals(PortType.BASCULANT2H2P))) {
	        	 	Vector2 right = actor.getRotatedVertices().get(3);
	               	Vector2 left = actor.getRotatedVertices().get(0);
	               	Vector2 rightBottom = MathUtilities.rotate(right, left.cpy(),45);
	               	Vector2 leftBottom = MathUtilities.rotate(left, right.cpy(),-45);
	               	rightBottom = rightBottom.cpy().sub(right).nor().scl(10).add(right);
	               	leftBottom = leftBottom.cpy().sub(left).nor().scl(10).add(left);

	               	debugRenderer.setColor(Color.GRAY);
	                debugRenderer.rectLine(right.x,right.y,rightBottom.x,rightBottom.y,1);
	                debugRenderer.rectLine(rightBottom.x,rightBottom.y,leftBottom.x,leftBottom.y,1);
	                debugRenderer.rectLine(leftBottom.x,leftBottom.y,left.x,left.y,1);
	        	}
            }
        }
        debugRenderer.end();
        batch.begin();
    }
    public static void drawDoorsforCoinsSimple(Object2D actor,Batch batch) {
		CaissonType caissonPositionType = ((KitchenElement)actor.getWorldObject()).getDesignObject().getPositionType();
		 Vector2 right = actor.getRotatedVertices().get(3);
		 Vector2 left = actor.getRotatedVertices().get(0);
		 Vector2 middle = new Vector2(right.x + left.x, right.y + left.y).scl(0.5f);
		 Vector2 end;
    	  if(caissonPositionType.equals(CaissonType.EXTREME_GAUCHE)) {
			   end = MathUtilities.rotate(middle, right.cpy(), -15);

		  }else {
			   end = MathUtilities.rotate(middle, left.cpy(),15);

		  }
		  debugRenderer.setColor(Color.GRAY);
          debugRenderer.rectLine(middle.x,middle.y,end.x,end.y,1);
    }

    
    
	public static void drawDoorsarc(Object2D actor, Batch batch) {
    	if(debugRenderer == null)
        	debugRenderer = new ShapeRenderer();
    	boolean batchInterruped = false;
    	if(batch.isDrawing()) {
    		batch.end();
    		batchInterruped = true;
    	}
    	String sens = "GAUCHE";
    	if(actor.getWorldObject()!=null && actor.getWorldObject().getModel()!=null &&
    			actor.getWorldObject().getModel().getInfo()!=null && actor.getWorldObject().getModel().getInfo().getProperties()!=null) {
    		sens = actor.getWorldObject().getModel().getInfo().getProperties().getProperty("sens-porte","DOUBLE");
    	}
    	 
        Matrix4 projection = batch.getProjectionMatrix();

        debugRenderer.setProjectionMatrix(projection);
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(Color.GRAY);
        debugRenderer.setColor(Color.PURPLE);

        
        Vector2 start, end;
        float rotation=actor.getRotation();

        if(sens.equals("DROITE")) {
        	start = actor.getRotatedVertices().get(1);
        	end = actor.getRotatedVertices().get(2);
            debugRenderer.arc(start.x,start.y, end.dst(start), 0, 90);	
        }
        else if (sens.equals("GAUCHE")) {
            start = actor.getRotatedVertices().get(2);
        	end = actor.getRotatedVertices().get(1);
            debugRenderer.arc(start.x,start.y, end.dst(start), rotation -90,  -90,30);

        }
        else if (sens.equals("DOUBLE")) {        	
        	{
                Vector2 startpoint = actor.getRotatedVertices().get(2);
                Vector2 middlepoint = MathUtilities.middlepoint(actor.getRotatedVertices().get(2), actor.getRotatedVertices().get(3));
                middlepoint  = actor.getAbsoluteOrigin();
                Vector2 lineendpoint = new Vector2(actor.getX()+actor.getHeight(),actor.getY());
                        lineendpoint = MathUtilities.rotate(middlepoint, lineendpoint.cpy(), rotation);
                //debugRenderer.line(startpoint,lineendpoint);
                debugRenderer.arc(startpoint.x,startpoint.y, actor.getHeight()/2, rotation, 90);
        	}
        	{
                Vector2 startpoint = actor.getRotatedVertices().get(3);
                Vector2 middlepoint = MathUtilities.middlepoint(actor.getRotatedVertices().get(2), actor.getRotatedVertices().get(3));
                middlepoint  = actor.getAbsoluteOrigin();
                Vector2 lineendpoint = new Vector2(actor.getX()+actor.getHeight(),actor.getY());
                        lineendpoint = MathUtilities.rotate(middlepoint, lineendpoint.cpy(), rotation);
                //debugRenderer.line(startpoint,lineendpoint);
                debugRenderer.arc(startpoint.x,startpoint.y, actor.getHeight()/2, 270+rotation,  90);	
        	}
        }
        
        debugRenderer.end();
        if(batchInterruped)
        	batch.begin();
		
	}
	
	public static Texture drawPalette(Color colorX, Color colorY) {
		Vector3 colorXV = new Vector3(colorX.r, colorX.g, colorX.b).nor().scl(1/255f);
		Vector3 colorYV = new Vector3(colorY.r, colorY.g, colorY.b).nor().scl(1/255f);
		Pixmap pixmap = new Pixmap(256, 256, Format.RGB888);
		Vector3 tempX, tempY,tempS;
		for(int r = 0; r < pixmap.getWidth(); r++) {
			tempX = colorXV.cpy().scl(r);
			for(int g = 0; g < pixmap.getHeight(); g++) {
				tempY = colorYV.cpy().scl(g);
				tempS = tempY.add(tempX);
				pixmap.setColor(tempS.x,tempS.y,tempS.z,1);
				pixmap.drawPixel(r, g);
			}
		}
		Texture texture = new Texture(pixmap);
		pixmap.dispose();
		texture.setFilter(TextureFilter.Linear, TextureFilter.Linear);
		return texture;		
	}
	
	public static void debugMouse(Batch batch) {
		Stage stage = RoomController.getInstance().getUIStage();
		Vector2 point = MathUtilities.screenToStageCoords(stage, Gdx.input.getX(), Gdx.input.getY());
		String value = "(" + point.x + "," + point.y + ")";
		drawText(value, new Vector3(point.x + 50,point.y,0), 0, Color.BLACK, 0.5f, batch);
	}

	public static Texture createUniform(Color color, int width, int height) {
		Pixmap pixmap = new Pixmap(width, height, Format.RGBA8888);
		pixmap.setColor(color);
		pixmap.fill();
		Texture texture = new Texture(pixmap);
		pixmap.dispose();
		return texture;
	}

	public static Texture createUniColorPalette(Color color,int height) {
		Vector3 colorX  = new Vector3(color.r,color.g,color.b).nor().scl(1/256f);
		Pixmap pixmap = new Pixmap(256,10,Format.RGB888);
		Vector3 tempColor;
		for(int i = 0; i < pixmap.getWidth(); i++) {
			tempColor = colorX.cpy().scl(i);
			pixmap.setColor(tempColor.x,tempColor.y,tempColor.z,1);
			for(int j = 0; j < pixmap.getHeight(); j++) {
				pixmap.drawPixel(i, j);
			}
		}
		Texture texture = new Texture(pixmap);
		pixmap.dispose();
		return texture;
	}
	
	public static void drawSquare(Vector2 center, Batch batch, Color color, float width) {
        if(debugRenderer == null)
        	debugRenderer = new ShapeRenderer();
        boolean batchInterrupted = false;
        if(batch.isDrawing()) {
        	batch.end();
        	batchInterrupted = true;
        }
        debugRenderer.setProjectionMatrix(batch.getProjectionMatrix());
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(color);
        debugRenderer.rect(center.x - width/2f, center.y -width/2, width, width);
        debugRenderer.end();
        if(batchInterrupted) {
            batch.begin();
        }
		
	}
	
	public static void  drawPositionOnWalls(Object2D object2D) {
		SurfaceScreen screen = (SurfaceScreen) Scene.game.getScreen();
		float[] scales = screen.getController().getScales();
		ArrayList<Vector2> points = object2D.calculateAttachmentPosition();
		float stageHeight = object2D.getStage().getHeight();
		float stageWidth = object2D.getStage().getWidth();
		for(Vector2 point: points) {
			drawCercle(point.x, point.y, 3, object2D.getStage().getBatch());
			//drawing the lines
			if(object2D.getY() < stageHeight - object2D.getHeight()) {
				Vector2 end = new Vector2(points.get(4).x,stageHeight);
				drawCutLine(points.get(4), end, object2D.getStage().getBatch(), Color.BLACK, 5);
				float distance  = end.dst(points.get(4)) * scales[1];
				String value = String.valueOf(Math.round(distance * 1000));
				drawText(value, new Vector3(end.cpy().add(points.get(4)).scl(0.5f),0), 0, Color.BLACK, 1, object2D.getStage().getBatch());
			}
			if(object2D.getY() > 0) {
				Vector2 end = new Vector2(points.get(5).x,0);
				drawCutLine(points.get(5), end, object2D.getStage().getBatch(), Color.BLACK, 5);
				float distance  = end.dst(points.get(5)) * scales[1];
				String value = String.valueOf(Math.round(distance * 1000));
				drawText(value, new Vector3(end.cpy().add(points.get(5)).scl(0.5f),0), 0, Color.BLACK, 1, object2D.getStage().getBatch());
			}
			if(object2D.getX() > 0) {
				Vector2 end = new Vector2(0,points.get(6).y);
				drawCutLine(points.get(6), end, object2D.getStage().getBatch(), Color.BLACK, 5);
				float distance  = end.dst(points.get(6)) * scales[0];
				String value = String.valueOf(Math.round(distance * 1000));
				drawText(value, new Vector3(end.cpy().add(points.get(6)).scl(0.5f),0), 0, Color.BLACK, 1, object2D.getStage().getBatch());
			}
			if(object2D.getX() + object2D.getWidth() <  stageWidth) {
				Vector2 end = new Vector2(stageWidth, points.get(7).y);
				drawCutLine(points.get(7), end, object2D.getStage().getBatch(), Color.BLACK, 5);
				float distance  = end.dst(points.get(7)) * scales[0];
				String value = String.valueOf(Math.round(distance * 1000));
				drawText(value, new Vector3(end.cpy().add(points.get(7)).scl(0.5f),0), 0, Color.BLACK, 1, object2D.getStage().getBatch());
			}
		}
	}

	public static ShapeRenderer getDebugRenderer() {
		if(debugRenderer == null)
			debugRenderer = new ShapeRenderer();
		return debugRenderer;
	}

	public static void setDebugRenderer(ShapeRenderer debugRenderer) {
		DrawingHelper.debugRenderer = debugRenderer;
	}
	
	
	
}
