package dressing.ui;

import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class ScrolledTabCorrect {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("CTabFolder Scroll Test");
        shell.setLayout(new FillLayout());
        shell.setSize(400, 300);

        // Create the CTabFolder
        CTabFolder tabFolder = new CTabFolder(shell, SWT.BORDER);
        tabFolder.setSimple(false);

        // First tab - normal content
        CTabItem normalTab = new CTabItem(tabFolder, SWT.NONE);
        normalTab.setText("Normal Tab");
        Composite normalComp = new Composite(tabFolder, SWT.NONE);
        normalComp.setLayout(new FillLayout());
        new Label(normalComp, SWT.NONE).setText("This is a normal tab.");
        normalTab.setControl(normalComp);

        // Second tab - scrollable content
        CTabItem secondtab = new CTabItem(tabFolder, SWT.NONE);
        secondtab.setText("Scrollable Tab");

        Composite tempcomosite = new Composite(tabFolder, SWT.NONE);
        tempcomosite.setLayout(new FillLayout());
        
        ScrolledComposite scrolled = new ScrolledComposite(tempcomosite, SWT.V_SCROLL | SWT.H_SCROLL);

        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);

        Composite scrollContent = new Composite(scrolled, SWT.NONE);
        GridLayout gridLayout = new GridLayout(1, false);
        scrollContent.setLayout(gridLayout);

        // Add many labels
        for (int i = 0; i < 100; i++) {
            new Label(scrollContent, SWT.NONE).setText("Item " + i);
        }

        // Let ScrolledComposite compute the size dynamically

        
        scrollContent.setSize(scrollContent.computeSize(SWT.DEFAULT, SWT.DEFAULT));
        scrolled.setContent(scrollContent);
        scrollContent.pack();
       
        secondtab.setControl(tempcomosite);
        tabFolder.setSelection(0);

        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch())
                display.sleep();
        }
        display.dispose();
    }
}