package dressing.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.swt.ResourceManager;

import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.ListEditorWindow;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public abstract class ElementComboSelect extends Composite implements Notifier{
	private ElementProviderImp elementProvider;
	private ComboViewer comboViewer;
	private Button btnAdd;
	private Button btnList;
	private Button btnModify;
	int buttonSize=30;
	
	
	public ElementComboSelect(Composite parent, int style, ElementProviderImp elementProvider) {
		super(parent, style);
		this.elementProvider = elementProvider;
		comboViewer.setLabelProvider(getLabelProvider());
		comboViewer.setContentProvider(getContentProvider());
		comboViewer.setInput(getinput());
	}

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public ElementComboSelect(Composite parent, int style) {
		super(parent, style);
		GridLayout clayout=new GridLayout(4, false);
		clayout.verticalSpacing=0;
		clayout.marginHeight=0;
		clayout.marginWidth=2;

		setLayout(clayout);
		comboViewer = new ComboViewer(this,SWT.READ_ONLY);
		Combo combo = comboViewer.getCombo();
		GridData gd_combo = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		combo.setLayoutData(gd_combo);
		comboViewer.setLabelProvider(getLabelProvider());
		comboViewer.setContentProvider(getContentProvider());
		comboViewer.setInput(getinput());

		btnModify = new Button(this, SWT.NONE);
		GridData gd_btnModify = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnModify.heightHint = buttonSize;
		gd_btnModify.widthHint = buttonSize;
		btnModify.setLayoutData(gd_btnModify);
		btnModify.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Modify();
			}
		});
		btnModify.setImage(ResourceManager.getPluginImage("Dressing", "icons/update.png"));
		
		btnList = new Button(this, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = buttonSize;
		gd_btnList.heightHint = buttonSize;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				listElements();
			}
		});
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		
		btnAdd = new Button(this, SWT.NONE);
		GridData gd_btnAdd = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnAdd.heightHint = buttonSize;
		gd_btnAdd.widthHint = buttonSize;
		btnAdd.setLayoutData(gd_btnAdd);
		btnAdd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				addElement();
			}
		});
		btnAdd.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));

	}
	
	public void refresh() {
		getComboViewer().setInput(getinput());
		getComboViewer().refresh();
	}
	public abstract IContentProvider getContentProvider();

	public abstract IBaseLabelProvider getLabelProvider();

	public abstract Object getinput();

	public abstract void addElement();

	public void listElements() {
		ListEditorWindow listWindow=getListEditorWindow();
		listWindow.create();
		listWindow.setSelect(true);
		int ret=listWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().setSelection(new StructuredSelection(listWindow.getSelection()), true);
		}
		getComboViewer().refresh();
	}

	public abstract void Modify();
	
	public abstract ListEditorWindow getListEditorWindow();
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	@Override
	public EList<Adapter> eAdapters() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean eDeliver() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void eSetDeliver(boolean deliver) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void eNotify(Notification notification) {
		// TODO Auto-generated method stub
		
	}

	public ElementProviderImp getElementProvider() {
		return elementProvider;
	}

	public void setElementProvider(ElementProviderImp elementProvider) {
		this.elementProvider = elementProvider;
	}

	public ComboViewer getComboViewer() {
		return comboViewer;
	}

	public void setComboViewer(ComboViewer comboViewer) {
		this.comboViewer = comboViewer;
	}

	public Button getBtnAdd() {
		return btnAdd;
	}

	public void setBtnAdd(Button btnAdd) {
		this.btnAdd = btnAdd;
	}

	public Button getBtnList() {
		return btnList;
	}

	public void setBtnList(Button btnList) {
		this.btnList = btnList;
	}

	public Button getBtnModify() {
		return btnModify;
	}

	public void setBtnModify(Button btnModify) {
		this.btnModify = btnModify;
	}

}
