package supercad.graphics;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;

public class Vertex {
	private Vector3 position = new Vector3();
	private Vector3 normal = new Vector3();
	private Vector2 textureCoords = new Vector2();
	
	public Vertex() {}

	public Vertex(Vector3 position) {
		super();
		this.position = position;
	}

	public Vertex(Vector3 position, Vector3 normal, Vector2 textureCoords) {
		super();
		this.position = position;
		this.normal = normal;
		this.textureCoords = textureCoords;
	}
	
	//helper function to create a libgdx vertexInfo from vertex
	public VertexInfo toVertexInfo() {
		VertexInfo info = new VertexInfo();
		info.setPos(this.position.cpy());
		info.setNor(this.normal.cpy());
		info.setUV(this.textureCoords.cpy());
		return info;
	}

	public Vector3 getPosition() {
		return position;
	}

	public void setPosition(Vector3 position) {
		this.position = position;
	}

	public Vector3 getNormal() {
		return normal;
	}

	public void setNormal(Vector3 normal) {
		this.normal = normal;
	}

	public Vector2 getTextureCoords() {
		return textureCoords;
	}

	public void setTextureCoords(Vector2 textureCoords) {
		this.textureCoords = textureCoords;
	}

	public void setTextureCoords(float u, float v) {
		this.textureCoords = new Vector2(u, v);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((normal == null) ? 0 : normal.hashCode());
		result = prime * result + ((position == null) ? 0 : position.hashCode());
		result = prime * result + ((textureCoords == null) ? 0 : textureCoords.hashCode());
		return result;
	}
	
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Vertex other = (Vertex) obj;
		if (normal == null) {
			if (other.normal != null)
				return false;
		} else if (!normal.epsilonEquals(other.normal))
			return false;
		if (position == null) {
			if (other.position != null)
				return false;
		} else if (!position.epsilonEquals(other.position))
			return false;
		if (textureCoords == null) {
			if (other.textureCoords != null)
				return false;
		} else if (!textureCoords.epsilonEquals(other.textureCoords))
			return false;
		return true;
	}
}
